/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */

package gui;

import processing.core.*;


/*
 * The StartAnimation is running as long as there isn't enough data 
 * to start the paintingprocess. The more data is collected the smaller it gets,
 * until completely vanishes and the painting process starts.
 */
public class StartAnimation {
	
	private PApplet parent;
	private PShape loadingSymbol;
	
	
	private float SCALESTEPS = (float) 0.8;
	private float ROTATIONSTEPS = (float) 0.05;
	private float CANVAS_STRUCTURE_LIGHT = 20;
	private float CANVAS_STRUCTURE_DARK = 40;
	private long TIME_SPAN_FOR_NOTEDETECTION = 4000;
	
	//the sizes for the animation
	private int scale0 = 55;
	private int scale1 = 40;
	private int scale2 = 25;
	private int scale3 = 10;
	private float scale = 70;
	
	
	private boolean direction = false;
	
	//rescueing the note detection
	private boolean firstBeatGotPlayed = false;
	private long trynoteDetection;
	
	
	//are we there yet?
	private boolean ready = false;
	
	
	public StartAnimation(PApplet parent){
		this.parent = parent;
		loadingSymbol = parent.loadShape("gui/StartAnimation.svg");
	}
	
	public void setAnimStage(int stage){
		//where are we in the animation right now/how much data was already collected?
		if(!ready){
			parent.background(255);
			parent.smooth();
			setScale(stage);
			loadingSymbol.rotate((float)ROTATIONSTEPS);
			if(scale != 0){
				parent.shape(loadingSymbol, parent.width/2, parent.height/2, scale, scale);
			}
		}
	}
	
	
	private void setScale(int stage){
		
		//we fade the scale according to how much data has been collected already.
		int currentStage = stage;
		if(firstBeatGotPlayed){
			//if the notedetection takes too long, we start anyway, with a grey scalebrush
			if(System.currentTimeMillis() - trynoteDetection > TIME_SPAN_FOR_NOTEDETECTION){
				currentStage = 3;
			}
		}
		if(currentStage == 0){
			if(scale<scale0 && direction==true){
				scale += SCALESTEPS;
			}else{
				scale -= SCALESTEPS;
				direction = false;
				if(scale<scale1){
					direction = true;
				}
			}
		}
		if(currentStage == 1){
			if(scale<scale1&& direction==true){
				scale += SCALESTEPS;
			}else{
				scale -= SCALESTEPS;
				direction = false;
				if(scale<scale2){
					direction = true;
				}
			}
		}
		if(currentStage == 2){
			if(scale<scale2 && direction==true){
				scale += SCALESTEPS;
			}else{
				scale -= SCALESTEPS;
				direction = false;
				if(scale<scale3){
					direction = true;
				}
			}
		}
		if(currentStage == 3){
			structureCanvas(scale);
			if(scale<scale3 && direction==true){
				scale += SCALESTEPS;
			}else{
				scale -= SCALESTEPS;
				direction = false;
				if(scale<=0){
					parent.background(255);
					ready = true;
					parent.delay(200);
					structureCanvas(0);
					return;
				}
				
			}
		}
	}
	
	public boolean getReadyState(){
		return ready;
	}
	
	public void startTheAnimation(){
		scale = 70; 		//this is a little twitch in the animation, that shows that we started collecting data.
		trynoteDetection = System.currentTimeMillis();
		firstBeatGotPlayed = true;
	}
	
	public void structureCanvas(float scale){
		// give the Canvas a canvas-like structure
		int y = 0;
		if(scale!=0){
			parent.loadPixels();
			for(int currentPixel = 0; currentPixel < parent.width*parent.height; currentPixel++){  
				int xPixel = currentPixel - (y*parent.width);
				if((xPixel % 2 == 0 && y % 2 == 1) || (xPixel % 2 == 1 && y % 2 ==0)  ){
					parent.pixels[currentPixel] = parent.color((int) (255 - (CANVAS_STRUCTURE_LIGHT*(1/scale))));
				}
				if(xPixel % 2 == 0 && y % 2 ==0){
					parent.pixels[currentPixel] = parent.color((int) (255 - (CANVAS_STRUCTURE_DARK*(1/scale))));
				}
				if((currentPixel+1) % parent.width == 0){
					y++;
				}
			}
			parent.updatePixels();
		}else{
			for(int currentPixel = 0; currentPixel < parent.width*parent.height; currentPixel++){  
				int xPixel = currentPixel - (y*parent.width);
				if((xPixel % 2 == 0 && y % 2 == 1) || (xPixel % 2 == 1 && y % 2 ==0) ){
					parent.stroke((int) (255 - (CANVAS_STRUCTURE_LIGHT-5)));
					parent.line(xPixel+1,y+1,xPixel+1,y+1);
				}
				if(xPixel % 2 == 0 && y % 2 ==0){
					parent.stroke((int) (255 - (CANVAS_STRUCTURE_DARK-5)));
					parent.line(xPixel+1,y+1,xPixel+1,y+1);
				}
				if((currentPixel+1) % parent.width == 0){
					y++;	
				}
			}
		}
	}
	
}
