/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */

package graphic;

/*
 * The direction management gets it's data from the noteTurningPoints
 * and translates them to curves that are painted by the Brush.
 * Important values are: 
 * - the main direction (where do we turn)
 * - the turns (how often do we change the direction)
 */

public class DirectionManagement {
	
	// STATICS THAT ALLOW FINETUNING
	private int STEPS_INCREASE = 25; 		//more steps, slower turning
	private int MAXMIMUM_INCREASE = 60;		//the starting value
	private float BASIC_SPEED = (float)0.3; // in what steps are we turning?
	// -----------------------------
	
	
	private float adjustedSteps = 1;
	private float oldDirectionX = 0;
	private float oldDirectionY = 1;
	private float newDirectionX = 0;
	private float newDirectionY = 1;
	
	private float translateDirectionX = 0;
	private float translateDirectionY = 0;
	
	private int lastTranslations = 0;
	private int translationsTodo = 0;
	
	private int lastTranslationSteps = 10;
	
	private int stepsX = 10;
	private int stepsY = 10;
	
	public DirectionManagement(){
		adjustedSteps = STEPS_INCREASE;
	}
	
	public void adjustSteps(int hPs){
		adjustedSteps = STEPS_INCREASE +(MAXMIMUM_INCREASE - hPs);
	}
	
	public float analyseDirectionX(int turns, int mainDirection){
		
		if(turns != lastTranslations){
			lastTranslations = turns;
			translationsTodo = turns;
			lastTranslationSteps = (int) (turns*adjustedSteps);
			translateDirectionX = oldDirectionX;
		}
		newDirectionX = mainDirection*turns*BASIC_SPEED;
		if(stepsX == 0){
			stepsX = (int) (turns*adjustedSteps);
		}
		translateDirectionX();
		return oldDirectionX;
	}
	
	public float analyseDirectionY(int turns, int mainDirection){
		newDirectionY = mainDirection*turns*BASIC_SPEED;
		translateDirectionY();
		return oldDirectionY;
	}
	
	// translation functions for x and y values
	private void translateDirectionX(){
		if(stepsX > 0){
			oldDirectionX += (newDirectionX-oldDirectionX) / stepsX; 
			stepsX--;
		}else{
			oldDirectionX = newDirectionX;
			if(translationsTodo > 0){
				newDirectionX = translateDirectionX;
				translateDirectionX = oldDirectionX;
				translationsTodo--;
				stepsX = lastTranslationSteps;
				stepsY = lastTranslationSteps;
			}
		}
	}
	
	private void translateDirectionY(){
		if(stepsY > 0){
			oldDirectionY += (newDirectionY-oldDirectionY) / stepsY; 
			stepsY--;
		}else{
			oldDirectionY = newDirectionY;
			if(translationsTodo > 0){
				newDirectionY = translateDirectionY;
				translateDirectionY = oldDirectionY;
				translationsTodo--;
			}
		}
	}
	// ----------------------------------------
}
