/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */
package graphic;

import java.util.HashMap;

/*
 * The Color Management translates the data from the NoteDetection into colors.
 * The colors are from the scjabin keyboard fpr majors.
 * Parallel minors are the same color but dirtier.
 * also the average pitch is important. The deeper the tone the darker the color, and 
 * the other way around. 
 */

public class ColorManagement {
	
	// STATICS THAT ALLOW FINETUNING
	private int MIX_STRENGTH = -1; //MIX_STRENGTH<0 = more basic color, MIX_STRENGTH > 0 = more current color;
	
	private int PITCH_CORRECTION = 65;
	private int PITCH_MULTIPLIER = 6;
	
	// -----------------------------

	private HashMap<String, int[]> colorMap = new HashMap<String, int[]>();
	
	//colour_palette_03.psd
	private int[] cDur = {255, 64, 39 };
	private int[] gDur = {255, 118, 8 };
	private int[] dDur = {255, 207, 39 };
	private int[] aDur = {39, 188, 4 };
	private int[] eDur = {180, 180, 180 };
	private int[] hDur = {61, 140, 248 };
	private int[] fisDur = {102, 2031,240};
	private int[] desDur = {181, 107, 250 };
	private int[] asDur = {170, 35, 209 };
	private int[] esDur = {105, 88, 170 };
	private int[] bDur = {113, 147, 181 };
	private int[] fDur = {165, 62, 38 };
	
	private int[] aMoll = {131, 76,69 };
	private int[] eMoll = {189, 132,87 };
	private int[] hMoll = {185, 150, 27};
	private int[] fisMoll = {71, 128, 57};
	private int[] cisMoll = {87, 110, 115};
	private int[] gisMoll = {77, 104, 140};
	private int[] disMoll = {63,121, 142 };
	private int[] bMoll = {144, 104, 180 };
	private int[] fMoll = {131, 76, 147 };
	private int[] cMoll = {84, 75, 118 };
	private int[] gMoll = {75, 92, 110 };
	private int[] dMoll = {107,49, 41 };
	
	/* colour_palette_02.psd
	private int[] cDur = {137, 255, 22 };
	private int[] gDur = {22, 143, 255 };
	private int[] dDur = {22, 49, 255 };
	private int[] aDur = {0, 123, 10 };
	private int[] eDur = {255, 224, 53 };
	private int[] hDur = {65, 7, 254 };
	private int[] fisDur = {254, 141, 7};
	private int[] desDur = {7, 254, 210 };
	private int[] asDur = {7, 94, 254 };
	private int[] esDur = {164, 7, 254 };
	private int[] bDur = {7, 170, 254 };
	private int[] fDur = {112, 7, 254 };
	
	private int[] aMoll = {254, 187, 7 };
	private int[] eMoll = {53, 7,254 };
	private int[] hMoll = {141, 32, 32};
	private int[] fisMoll = {108, 65, 190};
	private int[] cisMoll = {213, 255, 65};
	private int[] gisMoll = {35, 46, 118};
	private int[] disMoll = {38,151, 27 };
	private int[] bMoll = {170, 5, 5 };
	private int[] fMoll = {83, 5, 170 };
	private int[] cMoll = {17, 117, 175 };
	private int[] gMoll = {227, 138, 32 };
	private int[] dMoll = {51, 187, 150 };
	*/
	
	public ColorManagement(){
		colorMap.put("C-Dur", cDur);
		colorMap.put("G-Dur", gDur);
		colorMap.put("D-Dur", dDur);
		colorMap.put("A-Dur", aDur);
		colorMap.put("E-Dur", eDur);
		colorMap.put("B-Dur", hDur);
		colorMap.put("F#-Dur", fisDur);
		colorMap.put("C#-Dur", desDur);
		colorMap.put("G#-Dur", asDur);
		colorMap.put("D#-Dur", esDur);
		colorMap.put("Bb-Dur", bDur);
		colorMap.put("F-Dur", fDur);
		
		colorMap.put("A-moll", aMoll);
		colorMap.put("E-moll", eMoll);
		colorMap.put("B-moll", hMoll);
		colorMap.put("F#-moll", fisMoll);
		colorMap.put("C#-moll", cisMoll);
		colorMap.put("G#-moll", gisMoll);
		colorMap.put("D#-moll", disMoll);
		colorMap.put("Bb-moll", bMoll);
		colorMap.put("F-moll", fMoll);
		colorMap.put("C-moll", cMoll);
		colorMap.put("G-moll", gMoll);
		colorMap.put("D-moll", dMoll);
	}
	
	public int[] getColor(String note, int pitch, String mainTune){
		int[] mix = {128, 128, 128};
		int[] basic = {128, 128, 128};
		if(colorMap.containsKey(note)){
			mix[0] = colorMap.get(note)[0];
			mix[1] = colorMap.get(note)[1];
			mix[2] = colorMap.get(note)[2];
		}
		if(colorMap.containsKey(mainTune)){
			basic[0] = colorMap.get(mainTune)[0];
			basic[1] = colorMap.get(mainTune)[1];
			basic[2] = colorMap.get(mainTune)[2];
		}
		
		if(MIX_STRENGTH < 0){
			mix[0] = (Math.abs(MIX_STRENGTH)*basic[0] + mix[0])/(Math.abs(MIX_STRENGTH)+1);
			mix[1] = (Math.abs(MIX_STRENGTH)*basic[1] + mix[1])/(Math.abs(MIX_STRENGTH)+1);
			mix[2] = (Math.abs(MIX_STRENGTH)*basic[2] + mix[2])/(Math.abs(MIX_STRENGTH)+1);
		}
		if(MIX_STRENGTH > 0){
			mix[0] = (Math.abs(MIX_STRENGTH)*mix[0] + basic[0])/(Math.abs(MIX_STRENGTH)+1);
			mix[1] = (Math.abs(MIX_STRENGTH)*mix[1] + basic[1])/(Math.abs(MIX_STRENGTH)+1);
			mix[2] = (Math.abs(MIX_STRENGTH)*mix[2] + basic[2])/(Math.abs(MIX_STRENGTH)+1);
		}
		if(MIX_STRENGTH== 0){
			mix[0] = (mix[0] + basic[0])/2;
			mix[1] = (mix[1] + basic[1])/2;
			mix[2] = (mix[2] + basic[2])/2;
		}
		
		
		
		int pitchCorrection = (pitch-PITCH_CORRECTION)*PITCH_MULTIPLIER;
		for(int x=0; x<3; x++){
			mix[x] += pitchCorrection;
			if(mix[x] < 0){
				mix[x] = 0;
			}
			if(mix[x]>255){
				mix[x] = 255;
			}
		}

		return mix;
	}

}
