/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */
package graphic;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import processing.core.PApplet;

/*
 * The CanvasAnalysis analyses the canvas to check where the lightest point is.
 * Here we start the brush again.
 */
public class CanvasAnalysis {
	
	private PApplet parent;
	private int checkSizeX;
	private int checkSizeY;
	private int amountX;
	
	private int currentMode = 0;
	private int[]availibleFields;
	private int MODE = 10;
	
	public CanvasAnalysis(PApplet parent, int checkSizeX, int checkSizeY){
		this.parent = parent;
		this.checkSizeX = checkSizeX;	//how wide are the tiles for the analysis?
		this.checkSizeY = checkSizeY;	//how high are the tiles for the analysis?
		amountX = parent.width/checkSizeX; 
	}
	
	public SortedMap<Integer, Integer> analyseCanvas(boolean mode){
		
		HashMap<Integer, Integer> analysedPixels = new HashMap<Integer, Integer> ();
		
		parent.loadPixels();
		int y = 0;
		int field = 0;
		int y_fields = 0;
		int x = 0;
		for(int currentPixel = 0; currentPixel < (parent.width*parent.height -2); currentPixel+=4){  
				// put fieldValues into HashMap
				// sort by Brightness
					if(analysedPixels.containsKey(field)){
						int oldFieldValue = analysedPixels.get(field);
						analysedPixels.put(field, (int) (oldFieldValue+parent.brightness(parent.pixels[currentPixel])));
					}else{
						analysedPixels.put(field, (int)(parent.brightness(parent.pixels[currentPixel])));
					}
				//-----------
			if((currentPixel+4) % checkSizeX == 0){
				x++;
			}
			if((currentPixel+4) % checkSizeX == 0 && (x) % amountX == 0){
				y++;
				x= 0;
			}
			if((currentPixel+4) % checkSizeX == 0 && x % amountX == 0 &&  y % checkSizeY == 0){
				y=0;
				y_fields++;
			}
			field = x + y_fields*amountX;
		}
		SortedMap<Integer, Integer> sortedFields;
		if(mode){
			sortedFields = new TreeMap<Integer, Integer>(new ValueComparerWhite<Integer, Integer>(analysedPixels));
		}else{
			sortedFields = new TreeMap<Integer, Integer>(new ValueComparerBlack<Integer, Integer>(analysedPixels));
		}
		sortedFields.putAll(analysedPixels);
		//----------------------
		return sortedFields;
	}
	
	
	public int[] getNewPosition(boolean mode){
		// mode -> true = search for whitespace , false -> search for blackspace
		//long start = System.currentTimeMillis();
		int[] ret = new int[2];
		SortedMap<Integer, Integer> sortedFields = analyseCanvas(mode);
		int pos;
		
		if(sortedFields.isEmpty()){
			pos = 300;
		}else{
			pos = sortedFields.firstKey();
		}
		availibleFields = new int[0];
		
		int x = 0;
		for (Iterator<Integer> iter = sortedFields.keySet().iterator(); iter.hasNext();) {
			availibleFields = reSizeArray(availibleFields, iter.next());
				x++;
		}
		
		//System.out.println(java.util.Arrays.toString(availibleFieldsCheck));
		if(currentMode<availibleFields.length){
			pos = availibleFields[currentMode];
		}else{
			pos = ((parent.height/checkSizeY) *amountX / 2);
		}
		currentMode++;
		if(currentMode == MODE){
			currentMode = 0;
		}
		
		ret[0] = checkSizeX/2 + (pos%amountX)*checkSizeX;
		ret[1] = checkSizeY/2 + ((pos - (pos%amountX))/amountX)*checkSizeY;
		
		//System.out.println(System.currentTimeMillis() - start);
		return ret;
	}
	

	private int[] reSizeArray(int[] oldArray, int value){
		int[] copy = new int[oldArray.length + 1];
		for(int i = 0; i < oldArray.length; i++){
			copy[i]=oldArray[i];
		}
		copy[oldArray.length] = value;
		return copy;
	}

	
	public static class ValueComparerWhite<K, V extends Comparable<V>> implements Comparator<K>{
		
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		// ValueComparer from http://paaloliver.wordpress.com/2006/01/24/sorting-maps-in-java/
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		
		private Map<K, V>  data = null;
		
		public ValueComparerWhite (Map<K, V> data){
			this.data = data;
		}

		public int compare(K key1, K key2) {
			V value1 = this.data.get(key1);
			V value2 = this.data.get(key2);
			int c = value2.compareTo(value1);
			if (0 != c)
				return c;
			Integer h1 = key1.hashCode(), h2 = key2.hashCode();
			return h1.compareTo(h2);
			}
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	}
public static class ValueComparerBlack<K, V extends Comparable<V>> implements Comparator<K>{
		
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		// ValueComparer from http://paaloliver.wordpress.com/2006/01/24/sorting-maps-in-java/
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		
		private Map<K, V>  data = null;
		
		public ValueComparerBlack (Map<K, V> data){
			this.data = data;
		}

		public int compare(K key1, K key2) {
			V value1 = this.data.get(key1);
			V value2 = this.data.get(key2);
			int c = value1.compareTo(value2);
			if (0 != c)
				return c;
			Integer h1 = key1.hashCode(), h2 = key2.hashCode();
			return h1.compareTo(h2);
			}
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	}

}
