/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */

package audio;
/*
 * get the average volume during the TIME_SPAN
 */
public class VolumeAnalyser {
	
	// STATICS THAT ALLOW FINETUNING
	private long TIME_SPAN = 2000;
	// -----------------------------
	
	private int totalVolume = 0;
	private int currentVolume = 0;
	private int lastcurrentVolume = 0;
	private long startSecond = 0;
	private int averageVolume = 0;
	
	private int totalPlayedBeats = 0;
	private int currentPlayedBeats = 0;
	private int runTime= 0;
	
	private boolean firstHit = true;
	private boolean firstCheck = true;
	
	private boolean ready = false;
	
	public VolumeAnalyser(){
		
	}

	
	public void beatGotPlayed(int volume){
		if(firstHit){
			firstHit = false;
			startSecond = System.currentTimeMillis();
		}
		totalPlayedBeats++;
		currentPlayedBeats++;
		totalVolume += volume;
		currentVolume += volume;
		analyseVolume();
	}
	
	private void analyseVolume(){
		if(System.currentTimeMillis() - startSecond > TIME_SPAN){
			if(currentPlayedBeats == 0){
				ready = false;
			}
			//count the runs through this loop
			runTime++;
			//analsye the volume
			analyseTotalVolume();
			lastcurrentVolume = currentVolume / currentPlayedBeats;
			//reset currents
			currentVolume = 0;
			currentPlayedBeats = 0;
			startSecond = System.currentTimeMillis();
			//--------------
			//System.out.println(" Volume --- current: " + lastcurrentVolume + "   average: " + averageVolume);
		}
	}
	
	private void analyseTotalVolume(){
		if(firstCheck){
			firstCheck = false;
		}else{
			ready = true;
			averageVolume = totalVolume/totalPlayedBeats;
		}
	}
	
	public boolean getReadyState(){
		return ready;
	}
	
	public int getaverageVolume(){
		return averageVolume;
	}
	
	public int getcurrentVolume(){
		return lastcurrentVolume;
	}
}
