/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */

package audio;
/*
 * get the average pitch during the TIME_SPAN
 */
public class PitchDetection {
	
	// STATICS THAT ALLOW FINETUNING
	private long TIME_SPAN = 750;
	// -----------------------------
	
	private long startingPoint;
	private int pitchCounter = 0;
	private int currentPitch = 0;
	private int lastPitch = 0;
	
	private boolean firstNote = true;
	
	public PitchDetection(){

	}
	
	public void noteOnEvent(int pitch){
		if(firstNote){
			firstNote = false;
			startingPoint = System.currentTimeMillis();
		}
		pitchCounter++;
		currentPitch += pitch;
		if(System.currentTimeMillis() - startingPoint > TIME_SPAN){
			if(pitchCounter > 0){
				lastPitch = currentPitch / pitchCounter;
			}
			currentPitch = 0;
			pitchCounter = 0;
			startingPoint = System.currentTimeMillis();
			//System.out.println("Pitch  "+lastPitch);
		}
	}
	
	public int getCurrentPitch(){
		return lastPitch;
	}
}
