/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */
package audio;
/*
 * get the current amount of turns and the mainDirection during the TIME_SPAN
 */
public class NoteTurningPoints {
	
	// STATICS THAT ALLOW FINETUNING
	private int BASIC_NOTE = 50;
	private long TIME_SPAN = 750;
	// -----------------------------
	
	private int previousNote = 0;
	private boolean direction = true;
	private int lastMainDirection = 0;
	private int mainDirection = 0;
	private int lastAverageTurns = 0;
	private int currentAverageTurns = 0;
	private long startingPoint;
	private boolean firstNote = true;
	
	public NoteTurningPoints(){
		startingPoint = System.currentTimeMillis();
	}
	
	public void noteOnEvent(int note){
		if(firstNote){
			firstNote = false;
			startingPoint = System.currentTimeMillis();
		}
		
		if(note > BASIC_NOTE){
			if(previousNote != 0){
				if(note>previousNote){
					if(!direction){
						currentAverageTurns++;
					}
					mainDirection++;
					direction = true;
				}
				if(note<previousNote){
					if(direction){
						currentAverageTurns++;
					}
					direction = false;
					mainDirection--;
				}
			}
		previousNote = note;
		}
		//--------- refresh -----------
		if(System.currentTimeMillis() - startingPoint > TIME_SPAN){
			lastAverageTurns = currentAverageTurns;
			currentAverageTurns = 0;
			lastMainDirection = mainDirection;
			mainDirection = 0;
			startingPoint = System.currentTimeMillis();
			//System.out.println("turningPoints:  "+lastAverageTurns+"  mainDirection:  " + lastMainDirection);
		}	
	}
	
	public int getAverageTurns(){
		return lastAverageTurns;
	}
	
	public int getMainDirection(){
		return lastMainDirection;
	}

}
