/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */
package audio;

import java.util.HashMap;
/*
 * get the average noteduration during the TIME_SPAN
 */

public class NoteDurations {
	
	private HashMap<Integer, Long> playedNotes = new HashMap<Integer, Long>();
	
	private boolean firstNote = true;	
	private long currentLength = 0;
	private long startingPoint;
	private long countedNotes = 0;	
	private long oldCurrentLength = 0;	
	private long TIME_SPAN = 1500;
	
	public NoteDurations(){
		
	}
	
	public void noteOnEvent(int note, int velocity){
		if(firstNote){
			firstNote = false;
			startingPoint = System.currentTimeMillis();
		}
		long localTime = System.currentTimeMillis();
		if(!(playedNotes.containsKey(note))){
			playedNotes.put(note, localTime);
		}
		countedNotes++;
	}
	
	public void noteOffEvent(int note){
		if(playedNotes.containsKey(note)){
			long length = System.currentTimeMillis() - playedNotes.get(note);
			currentLength += length;
			playedNotes.remove(note);
			
		}
		if(System.currentTimeMillis() - startingPoint > TIME_SPAN){
			startingPoint = System.currentTimeMillis();
			if(countedNotes > 0){
				oldCurrentLength  = currentLength/countedNotes;
			}
			currentLength = 0;
			countedNotes = 0;
		}
		
	}
	
	public float getCurrentAvgLength(){
		return (float)oldCurrentLength;
	}

}
