/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */
package audio;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
/*
 * Probably the most complex class.
 * All incoming notes are stored in HashMaps and analysed
 * by musical theorie terms to get the currently played tunes.
 */
public class NoteDetection {
	// STATICS THAT ALLOW FINETUNING
	private long TIME_SPAN_FOR_OVERALL_KEY = 3000;
	private long TIME_SPAN_FOR_TRIADS = 300;
	// -----------------------------
	
	private int[] clearArray = new int[0];
	private String[] notes = {"C","C#","D","D#","E","F","F#","G","G#","A","Bb","B"};
	
	
	// overall key
	private long startingPoint_for_Overall_Key;
	private HashMap<Integer, Integer> playedNotes = new HashMap<Integer, Integer>();
	// -----------
	
	// triad keys
	private int[] totalTriads = new int[0];
	private HashMap<String, Integer> playedTriads = new HashMap<String, Integer>();
	// ---------
	
	// detect triads via time
	private long startingPoint_for_Triads;
	private int[] timeTriads = new int[0];
	// ----------------------
	
	private String currentTune;
	private String[] readyTunes = new String[0];
	private boolean ready = false;
	
	private boolean firstNote = true;
	
	
	public NoteDetection(){
		
		startingPoint_for_Triads = System.currentTimeMillis();
	}
	
	public void analyseNotes(int notePlayed){
		if(firstNote){
			firstNote = false;
			startingPoint_for_Overall_Key = System.currentTimeMillis();
			startingPoint_for_Triads = System.currentTimeMillis();
		}
		//check notes
		int note = notePlayed % 12;		//Notename
		checkForTune(note);				//filter overall tune
		TriadDetection(note);			//filter played triads
	}
	
	private void TriadDetection(int note){
		// check all three notes of a triad
		boolean triadnoteExistsAlready = false;
		
		for(int i = 0; i < totalTriads.length; i++){
			if(note == totalTriads[i]){
				triadnoteExistsAlready = true;
				break;
			}
		}
		if(!triadnoteExistsAlready){
			totalTriads= reSizeArray(totalTriads, note);
			if(totalTriads.length == 3){
				checkForTriad(totalTriads);
				totalTriads = clearArray;
			}
		}
		//------------------------------------------
		//filter triads that belong together
		if((System.currentTimeMillis() - startingPoint_for_Triads)>TIME_SPAN_FOR_TRIADS){
			if(timeTriads.length == 3){
				checkForTriad(timeTriads);
			}
			startingPoint_for_Triads = System.currentTimeMillis();
			timeTriads = clearArray;
		}
		
		boolean timeTriadNoteExists = false;
		
		for (int i = 0; i<timeTriads.length; i++){
			if(note == timeTriads[i]){
				timeTriadNoteExists = true;
				break;
			}
		}
		if(!timeTriadNoteExists){
			timeTriads = reSizeArray(timeTriads, note);
		}
		//------------------------------------------
	}
	
	private void checkForTune(int note){
		//check if Note exists on overall key
		if(playedNotes.containsKey(note)){
			int newValue = playedNotes.get(note) + 1; 
			playedNotes.put(note, newValue);
		}else{
			playedNotes.put(note, 1);
		}

		// convert HashMap to sorted Array
		SortedMap<Integer, Integer> sortedNotes = new TreeMap<Integer, Integer>(new ValueComparer<Integer, Integer>(playedNotes));
		sortedNotes.putAll(playedNotes);
		
		int dur_tune = 4;
		
		int[] playedNotesCheck = new int[0];
		
		int x = 0;
		for (Iterator<Integer> iter = sortedNotes.keySet().iterator(); iter.hasNext();) {
			if(x<7){
				playedNotesCheck = reSizeArray(playedNotesCheck, iter.next());
				x++;
			}else{
				break;
			}
		}
		java.util.Arrays.sort(playedNotesCheck);
		// -------------------------------
		if((System.currentTimeMillis() - startingPoint_for_Overall_Key)>TIME_SPAN_FOR_OVERALL_KEY){
			playedNotes = new HashMap<Integer, Integer>();
			startingPoint_for_Overall_Key = System.currentTimeMillis();
			//System.out.println(currentTune);
			SortedMap<String, Integer> sortedTriads = new TreeMap<String, Integer>(new ValueComparer<String, Integer>(playedTriads));
			sortedTriads.putAll(playedTriads);			
			prepareTunesForExport(sortedTriads);
			
		}
		//
		
		// if every note was played already ------------------------------------------
		if(playedNotesCheck.length == 7){
			
			int distance = 0;
			boolean distanceCount = false;
			int i = 0;
			while(true){
				if(i == 5){
					if(playedNotesCheck[6] - playedNotesCheck[0] == 11 && distanceCount){
						break;
					}
					if(playedNotesCheck[6] - playedNotesCheck[0] == 11 && !distanceCount){
						distanceCount = true;
						dur_tune = playedNotesCheck[i];
					}
					if(playedNotesCheck[6] - playedNotesCheck[0] == 10 && distanceCount){
						distance++;
					}
					i=0;
				}else{
					i++;
				}
				if(playedNotesCheck[i+1] - playedNotesCheck[i] == 1 && distanceCount){
					break;
				}
				if(playedNotesCheck[i+1] - playedNotesCheck[i] == 1 && !distanceCount){
					distanceCount = true;
					dur_tune = playedNotesCheck[i+1];
				}
				if(playedNotesCheck[i+1] - playedNotesCheck[i] == 2 && distanceCount){
					distance++;
				}
			}
			if(distance == 3){
				dur_tune -= 5; // Abstand der ersten 
			}
			
			int moll_tune = dur_tune -3;
			
			int moll_tune_count = 0;
			if (playedNotes.containsKey(moll_tune)){
				moll_tune_count = playedNotes.get(moll_tune);
			}
			
			int dur_tune_count = 0;
			if(playedNotes.containsKey(dur_tune)){
				dur_tune_count = playedNotes.get(dur_tune);
			}
			if(dur_tune_count>moll_tune_count){
				currentTune = detectNote(dur_tune)+"-Dur";
				if(!playedTriads.containsKey(detectNote(dur_tune)+"-Dur")){
					playedTriads.put(detectNote(dur_tune)+"-Dur", 1);
					
				}else{
					int newValue = ((Integer)playedTriads.get(detectNote(dur_tune)+"-Dur")+1);
					playedTriads.put(detectNote(dur_tune)+"-Dur", newValue);
				}
			}else if(moll_tune_count>dur_tune_count){
				currentTune = detectNote(moll_tune)+"-moll";
				if(!playedTriads.containsKey(detectNote(moll_tune)+"-moll")){
					playedTriads.put(detectNote(moll_tune)+"-moll", 1);
				}else{
					int newValue = ((Integer)playedTriads.get(detectNote(moll_tune)+"-moll")+1);
					playedTriads.put(detectNote(moll_tune)+"-moll", newValue);
				}
			}
			//System.out.println(detectNote(tune));
		}
		// ------------------------------------------------------------------------------------
	}
	
	private boolean checkForTriad(int[] triadNotes){
		
		int a = triadNotes[1]-triadNotes[0];
		int b = triadNotes[2]-triadNotes[1];
		
		if((triadNotes[0]==triadNotes[1]) || (triadNotes[1]==triadNotes[2]) || (triadNotes[0]==triadNotes[2])){
			return false;
		}else{
			java.util.Arrays.sort(triadNotes);
		}
		
		//Dreiklnge erkennen
		boolean ret = false;
		if(triadNotes.length == 3){
			String triad = "no Triad found";
			if(a == 5 || b == 5){
				if(a == 5){
					if(b == 4){
						triad = detectNote(triadNotes[1]) + "-Dur";
					}else{
						triad = detectNote(triadNotes[1]) + "-moll";
					}
				}
				if(b == 5){
					if(a == 3){
						triad = detectNote(triadNotes[2]) + "-Dur";
					}else{
						triad = detectNote(triadNotes[2]) + "-moll";
					}
				}
			}
			if((a == 3 && b == 4) || (a == 4 && b == 3)){
				if(a == 4){
					triad = detectNote(triadNotes[0]) + "-Dur";
				}else{
					triad = detectNote(triadNotes[0]) + "-moll";
				}
			}
			
			if(triad!= "no Triad found"){
				ret = true;
				currentTune = triad;
				if(!playedTriads.containsKey(triad)){
					playedTriads.put(triad, 1);
				}else{
					int newValue = ((Integer)playedTriads.get(triad)+1);
					playedTriads.put(triad, newValue);
				}
				//sort the found triads
				
			}
		}
		return ret;
	}
	
	
	private String detectNote(int notePlayed){
		//Noten abgleichen
		int note = notePlayed % 12;							//Notenname
		//----------------
		return notes[note];
		
	}
	
	public static class ValueComparer<K, V extends Comparable<V>> implements Comparator<K>{
		
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		// ValueComparer from http://paaloliver.wordpress.com/2006/01/24/sorting-maps-in-java/
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		
		private Map<K, V>  data = null;
		
		public ValueComparer (Map<K, V> data){
			this.data = data;
		}

		public int compare(K key1, K key2) {
			V value1 = this.data.get(key1);
			V value2 = this.data.get(key2);
			int c = value2.compareTo(value1);
			if (0 != c)
				return c;
			Integer h1 = key1.hashCode(), h2 = key2.hashCode();
			return h1.compareTo(h2);
			}
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	}
	
	private int[] reSizeArray(int[] oldArray, int note){
		int[] copy = new int[oldArray.length + 1];
		for(int i = 0; i < oldArray.length; i++){
			copy[i]=oldArray[i];
		}
		copy[oldArray.length] = note;
		return copy;
	}
	private String[] reSizeArray(String[] oldArray, String newString){
		String[] copy = new String[oldArray.length + 1];
		for(int i = 0; i < oldArray.length; i++){
			copy[i]=oldArray[i];
		}
		copy[oldArray.length] = newString;
		return copy;
	}
	
	private void prepareTunesForExport(SortedMap<String, Integer> tunesForExport){
		readyTunes = new String[0];
		
		for (Iterator<String> iter = tunesForExport.keySet().iterator(); iter.hasNext();) {
				readyTunes = reSizeArray(readyTunes, iter.next());
		}
		ready = true;
		//System.out.println(java.util.Arrays.toString(readyTunes));
	}
	
	public void reset(){
		
	}
		
	public void resetAll(){
		playedTriads = new HashMap<String, Integer>();
	}
	
	public boolean getReadyState(){
		return ready;
	}
	public String getOverallTune(){
		String ret = "";
		if(readyTunes.length>0){
			ret = readyTunes[0];
		}
		return ret;
	}
	public String getCurrentTune(){
		return currentTune;
	}
}
