/* 
 * 2011 at the University of applied sciences Augsburg
 * as written by Claus Hoffmann for his bachelorthesis "the singing CANVAS"
 * this code is published under creative commons attribution non-commercial share-alike
 * You may rewrite and use this code as much as you like, as long as it is not for
 * commercial purposes.
 */
package audio;
/*
 * get the current hits/second.
 * As it doesn't make any sense to search for bpm,
 * we just look at the maount of notes played in the TIME_SPAN
 */
public class HpS_Counter {
	
	private long TIME_SPAN = 2000;
	
	private int totalHits = 0;
	private int currentHps = 0;
	private int lastCurrentHps = 0;
	private long startSecond = 0;
	private int averageHps = 0;
	private int runTime= 0;
	
	private boolean firstHit = true;
	private boolean firstCheck = true;
	
	private boolean ready = false;
	
	
	public HpS_Counter(){
		
	}

	
	public void beatGotPlayed(){
		if(firstHit){
			firstHit = false;
			startSecond = System.currentTimeMillis();
		}
		totalHits++;
		currentHps++;
		analyzeBeats();
	}
	
	private void analyzeBeats(){
		if(System.currentTimeMillis() - startSecond > TIME_SPAN){
			runTime++;
			analyzeTotalBeats();
			lastCurrentHps = currentHps;
			currentHps = 0;
			startSecond = System.currentTimeMillis();
			//System.out.println("HitsPerSecond --- current: "+lastCurrentHps+"   average: "+averageHps);
		}
	}
	
	private void analyzeTotalBeats(){
		if(firstCheck){
			firstCheck = false;
		}else{
			ready = true;
			averageHps = totalHits/runTime;
			
		}
	}
	
	public boolean getReadyState(){
		return ready;
	}
	
	public int getAverageHPS(){
		return averageHps;
	}
	
	public int getCurrentHPS(){
		return lastCurrentHps;
	}
}
