/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import java.lang.reflect.Method;
import promidi.MidiEvent;

class Plug {
    private final Method method;
    private final String methodName;
    private final Object object;
    private final Class objectClass;
    private int parameterKind;
    static final int MIDIEVENT = 0;
    static final int NOTE = 1;
    static final int CONTROLLER = 2;
    static final int PROGRAMCHANGE = 3;

    public Plug(Object i_object, String i_methodName) {
        this.object = i_object;
        this.objectClass = this.object.getClass();
        this.methodName = i_methodName;
        this.method = this.initPlug();
    }

    int getParameterKind() {
        return this.parameterKind;
    }

    private boolean checkParameter(Class[] objectMethodParams) throws Exception {
        if (objectMethodParams.length == 1) {
            Class paramClass = objectMethodParams[0];
            if (paramClass.getName().equals("promidi.MidiEvent")) {
                this.parameterKind = 0;
                return true;
            }
            if (paramClass.getName().equals("promidi.Note")) {
                this.parameterKind = 1;
                return true;
            }
            if (paramClass.getName().equals("promidi.Controller")) {
                this.parameterKind = 2;
                return true;
            }
            if (paramClass.getName().equals("promidi.ProgramChange")) {
                this.parameterKind = 3;
                return true;
            }
        }
        throw new Exception();
    }

    private Method initPlug() {
        if (this.methodName != null && this.methodName.length() > 0) {
            Method[] objectMethods = this.objectClass.getDeclaredMethods();
            int i = 0;
            while (i < objectMethods.length) {
                objectMethods[i].setAccessible(true);
                if (objectMethods[i].getName().equals(this.methodName)) {
                    Class[] objectMethodParams = objectMethods[i].getParameterTypes();
                    try {
                        this.checkParameter(objectMethodParams);
                        return this.objectClass.getDeclaredMethod(this.methodName, objectMethodParams);
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                ++i;
            }
        }
        throw new RuntimeException("Error on plug: >" + this.methodName + "< You can only plug methods that have a MidiEvent, a Note, a Controller or a ProgramChange as Parameter");
    }

    void callPlug(MidiEvent i_midiEvent) {
        try {
            this.method.invoke(this.object, i_midiEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error on calling plug: " + this.methodName);
        }
    }
}

