/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import java.util.Comparator;
import java.util.TreeSet;
import promidi.Controller;
import promidi.InvalidMidiDataException;
import promidi.MidiEvent;
import promidi.MidiOutDevice;
import promidi.Note;
import promidi.ProgramChange;

public class MidiOut {
    final int midiChannel;
    final MidiOutDevice midiOutDevice;
    private static NoteBuffer noteBuffer;

    MidiOut(int midiChannel, MidiOutDevice midiOutDevice) {
        if (noteBuffer == null) {
            noteBuffer = new NoteBuffer();
        }
        this.midiChannel = midiChannel;
        this.midiOutDevice = midiOutDevice;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MidiOutDevice)) {
            return false;
        }
        MidiOut midiOut = (MidiOut)object;
        if (this.midiChannel != midiOut.midiChannel) {
            return false;
        }
        return this.midiOutDevice.equals(midiOut.midiOutDevice);
    }

    public void sendEvent(MidiEvent i_event) {
        if (i_event.getChannel() > 15 || i_event.getChannel() < 0) {
            throw new InvalidMidiDataException("You tried to send to midi channel" + i_event.getChannel() + ". With midi you only have the channels 0 - 15 available.");
        }
        i_event.setChannel(this.midiChannel);
        this.midiOutDevice.sendEvent(i_event);
    }

    void sendEvent(int i_command, int i_data1, int i_data2) {
        MidiEvent event = new MidiEvent(i_command, i_data1, i_data2);
        this.sendEvent(event);
    }

    public void sendController(Controller controller) {
        block3: {
            try {
                this.sendEvent(controller);
            }
            catch (InvalidMidiDataException e) {
                if (controller.getNumber() > 127 || controller.getNumber() < 0) {
                    throw new RuntimeException("You tried to send the controller number " + controller.getNumber() + ". With midi you only have the controller numbers 0 - 127 available.");
                }
                if (controller.getValue() <= 127 && controller.getValue() >= 0) break block3;
                throw new RuntimeException("You tried to send the controller value " + controller.getValue() + ". With midi you only have the controller values 0 - 127 available.");
            }
        }
    }

    public void sendNote(Note i_note) {
        block3: {
            try {
                this.sendEvent(i_note);
                noteBuffer.addNote(this, i_note);
            }
            catch (InvalidMidiDataException e) {
                if (i_note.getPitch() > 127 || i_note.getPitch() < 0) {
                    throw new RuntimeException("You tried to send a note with the pitch " + i_note.getPitch() + ". With midi you only have pitch values from 0 - 127 available.");
                }
                if (i_note.getVelocity() <= 127 && i_note.getVelocity() >= 0) break block3;
                throw new RuntimeException("You tried to send a note with the velocity " + i_note.getVelocity() + ". With midi you only have velocities values from 0 - 127 available.");
            }
        }
    }

    public void sendProgramChange(ProgramChange i_programChange) {
        block2: {
            try {
                this.sendEvent(i_programChange);
            }
            catch (InvalidMidiDataException e) {
                if (i_programChange.getNumber() <= 127 && i_programChange.getNumber() >= 0) break block2;
                throw new RuntimeException("You tried to send the program number " + i_programChange.getNumber() + ". With midi you only have the program numbers 0 - 127 available.");
            }
        }
    }

    private static class NoteComparator
    implements Comparator {
        NoteComparator() {
        }

        public int compare(Object i_obj1, Object i_obj2) {
            CueNote note1 = (CueNote)i_obj1;
            CueNote note2 = (CueNote)i_obj2;
            return (int)(note1.offTime - note2.offTime);
        }
    }

    private static class CueNote
    extends MidiEvent {
        final MidiOut midiOut;
        final long offTime;

        CueNote(MidiOut i_midiOut, Note note, long i_offTime) {
            super(128, note.getPitch(), note.getVelocity());
            this.midiOut = i_midiOut;
            this.offTime = i_offTime;
        }

        void trigger() {
            try {
                this.midiOut.sendEvent(this);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
    }

    private static class NoteBuffer
    extends Thread {
        private long numberOfLoops = 0L;
        private final TreeSet notes = new TreeSet(new NoteComparator());

        NoteBuffer() {
            this.start();
        }

        public void run() {
            block2: while (true) {
                ++this.numberOfLoops;
                try {
                    Thread.sleep(1L);
                    Object[] cueNotes = this.notes.toArray();
                    int counter = 0;
                    while (true) {
                        if (counter >= cueNotes.length || cueNotes.length <= 0 || ((CueNote)cueNotes[counter]).offTime > this.numberOfLoops) continue block2;
                        CueNote note = (CueNote)cueNotes[counter];
                        note.trigger();
                        this.notes.remove(note);
                        ++counter;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        void addNote(MidiOut i_midiOut, Note i_note) {
            this.notes.add(new CueNote(i_midiOut, i_note, (long)i_note.getNoteLength() + this.numberOfLoops));
        }
    }
}

