/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import promidi.Controller;
import promidi.MidiDevice;
import promidi.MidiIO;
import promidi.MidiIn;
import promidi.Note;
import promidi.ProgramChange;

class MidiInDevice
extends MidiDevice
implements Receiver {
    private final Transmitter inputTrans;
    private final MidiIO promidiContext;
    private final MidiIn[] midiIns = new MidiIn[16];

    MidiInDevice(MidiIO libContext, javax.sound.midi.MidiDevice midiDevice, int deviceNumber) {
        super(midiDevice, deviceNumber);
        this.promidiContext = libContext;
        try {
            this.inputTrans = midiDevice.getTransmitter();
        }
        catch (MidiUnavailableException e) {
            throw new RuntimeException();
        }
    }

    String getName() {
        return this.midiDevice.getDeviceInfo().getName();
    }

    void open() {
        super.open();
        this.inputTrans.setReceiver(this);
    }

    void openMidiChannel(int i_midiChannel) {
        if (this.midiIns[i_midiChannel] == null) {
            this.midiIns[i_midiChannel] = new MidiIn(i_midiChannel, this.promidiContext);
        }
    }

    void closeMidiChannel(int i_midiChannel) {
        this.midiIns[i_midiChannel] = null;
    }

    void plug(Object i_object, String i_methodName, int i_midiChannel) {
        this.open();
        this.openMidiChannel(i_midiChannel);
        this.midiIns[i_midiChannel].plug(i_object, i_methodName);
    }

    public void send(MidiMessage message, long deltaTime) {
        ShortMessage shortMessage = (ShortMessage)message;
        int midiChannel = shortMessage.getChannel();
        if (this.midiIns[midiChannel] == null) {
            return;
        }
        int midiCommand = shortMessage.getCommand();
        int midiData1 = shortMessage.getData1();
        int midiData2 = shortMessage.getData2();
        if (midiCommand == 144 && midiData2 > 0) {
            Note note = new Note(midiData1, midiData2);
            this.midiIns[midiChannel].sendNoteOn(note, this.deviceNumber, midiChannel);
        } else if (midiCommand == 128 || midiData2 == 0) {
            Note note = new Note(midiData1, midiData2);
            this.midiIns[midiChannel].sendNoteOff(note, this.deviceNumber, midiChannel);
        } else if (midiCommand == 176) {
            Controller controller = new Controller(midiData1, midiData2);
            this.midiIns[midiChannel].sendController(controller, this.deviceNumber, midiChannel);
        } else if (midiCommand == 192) {
            ProgramChange programChange = new ProgramChange(midiData1);
            this.midiIns[midiChannel].sendProgramChange(programChange, this.deviceNumber, midiChannel);
        }
    }
}

