/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import processing.core.PApplet;
import promidi.MidiInDevice;
import promidi.MidiOut;
import promidi.MidiOutDevice;
import promidi.UnavailablePortException;

public class MidiIO {
    PApplet parent;
    Method noteOnMethod;
    Method noteOffMethod;
    Method controllerMethod;
    Method programChangeMethod;
    private final Vector midiInputDevices = new Vector();
    private final Vector midiOutDevices = new Vector();
    private final Map openMidiOuts = new HashMap();
    private static MidiIO instance;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private MidiIO(PApplet parent) {
        this.parent = parent;
        parent.registerDispose(this);
        try {
            Class<?> clazz = parent.getClass();
            Class[] classArray = new Class[3];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("promidi.Note");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            classArray[1] = Integer.TYPE;
            classArray[2] = Integer.TYPE;
            this.noteOnMethod = clazz.getMethod("noteOn", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class<?> clazz = parent.getClass();
            Class[] classArray = new Class[3];
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("promidi.Note");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            classArray[1] = Integer.TYPE;
            classArray[2] = Integer.TYPE;
            this.noteOffMethod = clazz.getMethod("noteOff", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class<?> clazz = parent.getClass();
            Class[] classArray = new Class[3];
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("promidi.Controller");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz4;
            classArray[1] = Integer.TYPE;
            classArray[2] = Integer.TYPE;
            this.controllerMethod = clazz.getMethod("controllerIn", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class<?> clazz = parent.getClass();
            Class[] classArray = new Class[3];
            Class<?> clazz5 = class$2;
            if (clazz5 == null) {
                try {
                    clazz5 = class$2 = Class.forName("promidi.ProgramChange");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz5;
            classArray[1] = Integer.TYPE;
            classArray[2] = Integer.TYPE;
            this.programChangeMethod = clazz.getMethod("programChange", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getAvailablePorts();
    }

    private MidiIO() {
        this.getAvailablePorts();
    }

    public static MidiIO getInstance(PApplet parent) {
        if (instance == null) {
            instance = new MidiIO(parent);
        }
        return instance;
    }

    public static MidiIO getInstance() {
        if (instance == null) {
            instance = new MidiIO();
        }
        return instance;
    }

    public static void checkMidiChannel(int i_midiChannel) {
        if (i_midiChannel < 0 || i_midiChannel > 15) {
            throw new RuntimeException("Invalid midiChannel make sure you have a channel number between 0 and 15.");
        }
    }

    public void dispose() {
        this.closePorts();
    }

    private void getAvailablePorts() {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            try {
                MidiDevice theDevice = MidiSystem.getMidiDevice(infos[i]);
                if (!(theDevice instanceof Sequencer)) {
                    if (theDevice.getMaxReceivers() != 0) {
                        this.midiOutDevices.add(new MidiOutDevice(theDevice, i));
                    } else if (theDevice.getMaxTransmitters() != 0) {
                        this.midiInputDevices.add(new MidiInDevice(this, theDevice, i));
                    }
                }
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public int numberOfInputDevices() {
        return this.midiInputDevices.size();
    }

    public int numberOfOutputDevices() {
        return this.midiOutDevices.size();
    }

    public String getInputDeviceName(int input) {
        return ((MidiInDevice)this.midiInputDevices.get(input)).getName();
    }

    public String getOutputDeviceName(int output) {
        return ((MidiOutDevice)this.midiOutDevices.get(output)).getName();
    }

    public void printInputDevices() {
        System.out.println("<< inputs: >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        int i = 0;
        while (i < this.numberOfInputDevices()) {
            System.out.println("input " + i + " : " + this.getInputDeviceName(i));
            ++i;
        }
    }

    public void printOutputDevices() {
        System.out.println("<< outputs: >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        int i = 0;
        while (i < this.numberOfOutputDevices()) {
            System.out.println("output " + i + " : " + this.getOutputDeviceName(i));
            ++i;
        }
    }

    public void printDevices() {
        this.printInputDevices();
        this.printOutputDevices();
        System.out.println("<<>>>>>>>>> >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
    }

    public void openInput(int inputDeviceNumber, int midiChannel) {
        MidiIO.checkMidiChannel(midiChannel);
        MidiInDevice midiInDevice = (MidiInDevice)this.midiInputDevices.get(inputDeviceNumber);
        midiInDevice.open();
        midiInDevice.openMidiChannel(midiChannel);
    }

    public void openInput(String inputDeviceName, int midiChannel) {
        MidiIO.checkMidiChannel(midiChannel);
        int i = 0;
        while (i < this.numberOfInputDevices()) {
            MidiInDevice midiInDevice = (MidiInDevice)this.midiInputDevices.get(i);
            if (midiInDevice.getName().equals(inputDeviceName)) {
                midiInDevice.open();
                midiInDevice.openMidiChannel(midiChannel);
            }
            ++i;
        }
        throw new RuntimeException("There is no input device with the name " + inputDeviceName + ".");
    }

    public void plug(Object i_object, String i_methodName, int i_intputDeviceNumber, int i_midiChannel) {
        MidiInDevice midiInDevice = (MidiInDevice)this.midiInputDevices.get(i_intputDeviceNumber);
        midiInDevice.plug(i_object, i_methodName, i_midiChannel);
    }

    public MidiOut getMidiOut(int midiChannel, int outDeviceNumber) {
        MidiIO.checkMidiChannel(midiChannel);
        try {
            String key = String.valueOf(midiChannel) + "_" + outDeviceNumber;
            if (!this.openMidiOuts.containsKey(key)) {
                MidiOutDevice midiOutDevice = (MidiOutDevice)this.midiOutDevices.get(outDeviceNumber);
                midiOutDevice.open();
                MidiOut midiOut = new MidiOut(midiChannel, midiOutDevice);
                this.openMidiOuts.put(key, midiOut);
            }
            return (MidiOut)this.openMidiOuts.get(key);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeException("You wanted to open the unavailable output " + outDeviceNumber + ". The available outputs are 0 - " + (this.numberOfOutputDevices() - 1) + ".");
        }
    }

    public MidiOut getMidiOut(int midiChannel, String outDeviceName) {
        int i = 0;
        while (i < this.numberOfOutputDevices()) {
            MidiOutDevice midiOutDevice = (MidiOutDevice)this.midiOutDevices.get(i);
            if (midiOutDevice.getName().equals(outDeviceName)) {
                return this.getMidiOut(midiChannel, i);
            }
            ++i;
        }
        throw new UnavailablePortException("There is no output with the name " + outDeviceName + ".");
    }

    public void closeInput(int inputNumber) {
        try {
            MidiInDevice inDevice = (MidiInDevice)this.midiInputDevices.get(inputNumber);
            inDevice.close();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UnavailablePortException("You wanted to close the unavailable input " + inputNumber + ". The available inputs are 0 - " + (this.midiInputDevices.size() - 1) + ".");
        }
    }

    public void closeInput(String inputName) {
        int i = 0;
        while (i < this.numberOfInputDevices()) {
            MidiInDevice inDevice = (MidiInDevice)this.midiInputDevices.get(i);
            if (inDevice.getName().equals(inputName)) {
                this.closeInput(i);
                return;
            }
            ++i;
        }
        throw new UnavailablePortException("There is no input with the name " + inputName + ".");
    }

    public void closeOutput(int outputNumber) {
        try {
            MidiOutDevice outDevice = (MidiOutDevice)this.midiOutDevices.get(outputNumber);
            outDevice.close();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UnavailablePortException("You wanted to close the unavailable output " + outputNumber + ". The available outputs are 0 - " + (this.midiOutDevices.size() - 1) + ".");
        }
    }

    public void closeOutput(String outputName) {
        int i = 0;
        while (i < this.numberOfOutputDevices()) {
            MidiOutDevice outDevice = (MidiOutDevice)this.midiOutDevices.get(i);
            if (outDevice.getName().equals(outputName)) {
                this.closeOutput(i);
                return;
            }
            ++i;
        }
        throw new UnavailablePortException("There is no output with the name " + outputName + ".");
    }

    public void closeInputs() {
        int i = 0;
        while (i < this.numberOfInputDevices()) {
            this.closeInput(i);
            ++i;
        }
    }

    public void closeOutputs() {
        int i = 0;
        while (i < this.numberOfOutputDevices()) {
            this.closeOutput(i);
            ++i;
        }
    }

    public void closePorts() {
        this.closeInputs();
        this.closeOutputs();
    }
}

