/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.sun.opengl.util.BufferUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PGraphics3D;
import processing.core.PImage;

public class PGraphicsOpenGL
extends PGraphics3D {
    protected GLDrawable drawable;
    protected GLContext context;
    public GL gl;
    public GLU glu;
    protected float[] projectionFloats;
    protected GLUtessellator tobj;
    protected TessCallback tessCallback;
    protected float[] lightArray = new float[]{1.0f, 1.0f, 1.0f};
    static int maxTextureSize;
    int[] textureDeleteQueue = new int[10];
    int textureDeleteQueueCount = 0;
    protected float[] colorBuffer;
    protected FloatBuffer zeroBuffer;
    protected IntBuffer pixelBuffer;
    public static boolean BIG_ENDIAN;
    private float[] ctm;
    IntBuffer getsetBuffer = BufferUtil.newIntBuffer(1);

    static {
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    public PGraphicsOpenGL() {
        this.glu = new GLU();
        this.tobj = this.glu.gluNewTess();
        this.tessCallback = new TessCallback();
        this.glu.gluTessCallback(this.tobj, 100100, this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100102, this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100101, this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100105, this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100103, this.tessCallback);
    }

    protected void allocate() {
        if (this.context == null) {
            GLCapabilities capabilities = new GLCapabilities();
            if (!this.hints[1]) {
                capabilities.setSampleBuffers(true);
                capabilities.setNumSamples(2);
            } else if (this.hints[2]) {
                capabilities.setSampleBuffers(true);
                capabilities.setNumSamples(4);
            }
            GLDrawableFactory factory = GLDrawableFactory.getFactory();
            this.drawable = factory.getGLDrawable(this.parent, capabilities, null);
            this.context = this.drawable.createContext(null);
            this.gl = this.context.getGL();
            this.settingsInited = false;
        } else {
            this.context.destroy();
            this.context = this.drawable.createContext(null);
            this.gl = this.context.getGL();
            this.reapplySettings();
        }
    }

    public GLContext getContext() {
        return this.context;
    }

    protected void detainContext() {
        try {
            while (this.context.makeCurrent() == 0) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void releaseContext() {
        this.context.release();
    }

    public boolean canDraw() {
        return this.parent.isDisplayable();
    }

    public void beginDraw() {
        if (this.drawable != null) {
            this.drawable.setRealized(this.parent.isDisplayable());
            if (!this.parent.isDisplayable()) {
                return;
            }
            this.drawable.setRealized(true);
            this.detainContext();
        }
        super.beginDraw();
        this.report("top beginDraw()");
        this.gl.glDisable(2896);
        int i = 0;
        while (i < 8) {
            this.gl.glDisable(16384 + i);
            ++i;
        }
        this.updateProjection();
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glScalef(1.0f, -1.0f, 1.0f);
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        if (this.hints[4]) {
            this.gl.glDisable(2929);
        } else {
            this.gl.glEnable(2929);
        }
        this.gl.glDepthFunc(515);
        this.gl.glFrontFace(2304);
        this.gl.glEnable(2903);
        this.gl.glColorMaterial(1032, 5634);
        this.gl.glColorMaterial(1032, 4610);
        this.report("bot beginDraw()");
    }

    public void endDraw() {
        this.report("top endDraw()");
        if (this.hints[5]) {
            this.flush();
        }
        if (this.drawable != null) {
            this.drawable.swapBuffers();
        }
        this.report("bot endDraw()");
        if (this.drawable != null) {
            this.releaseContext();
        }
    }

    public GL beginGL() {
        this.gl.glPushMatrix();
        if (this.ctm == null) {
            this.ctm = new float[16];
        }
        this.ctm[0] = this.modelview.m00;
        this.ctm[1] = this.modelview.m10;
        this.ctm[2] = this.modelview.m20;
        this.ctm[3] = this.modelview.m30;
        this.ctm[4] = this.modelview.m01;
        this.ctm[5] = this.modelview.m11;
        this.ctm[6] = this.modelview.m21;
        this.ctm[7] = this.modelview.m31;
        this.ctm[8] = this.modelview.m02;
        this.ctm[9] = this.modelview.m12;
        this.ctm[10] = this.modelview.m22;
        this.ctm[11] = this.modelview.m32;
        this.ctm[12] = this.modelview.m03;
        this.ctm[13] = this.modelview.m13;
        this.ctm[14] = this.modelview.m23;
        this.ctm[15] = this.modelview.m33;
        this.gl.glMultMatrixf(this.ctm, 0);
        return this.gl;
    }

    public void endGL() {
        this.gl.glPopMatrix();
    }

    public void hint(int which) {
        boolean opengl2X = !this.hints[1];
        boolean opengl4X = this.hints[2];
        super.hint(which);
        if (which == 4) {
            this.gl.glDisable(2929);
            this.gl.glClear(256);
        } else if (which == -4) {
            this.gl.glEnable(2929);
        } else if (which == 1) {
            if (opengl2X) {
                this.releaseContext();
                this.context.destroy();
                this.context = null;
                this.allocate();
                throw new PApplet.RendererChangeException();
            }
        } else if (which != -1 && which == 2 && !opengl4X) {
            this.releaseContext();
            this.context.destroy();
            this.context = null;
            this.allocate();
            throw new PApplet.RendererChangeException();
        }
    }

    protected void endShapeLighting(boolean lights) {
        super.endShapeLighting(lights);
        if (lights) {
            int i = this.shapeFirst;
            while (i < this.shapeLast) {
                float[] v = this.vertices[i];
                v[3] = this.clamp(v[3] + v[28]);
                v[4] = this.clamp(v[4] + v[29]);
                v[5] = this.clamp(v[5] + v[30]);
                ++i;
            }
        }
    }

    protected void renderPoints(int start, int stop) {
        float sw = this.vertices[this.lines[start][0]][17];
        if (sw > 0.0f) {
            this.gl.glPointSize(sw);
            this.gl.glBegin(0);
            int i = start;
            while (i < stop) {
                float[] a = this.vertices[this.points[i][0]];
                this.gl.glColor4f(a[13], a[14], a[15], a[16]);
                this.gl.glVertex3f(a[21], a[22], a[23]);
                ++i;
            }
            this.gl.glEnd();
        }
    }

    protected void addLine(int a, int b) {
        this.addLineWithoutClip(a, b);
    }

    protected void renderLines(int start, int stop) {
        this.report("render_lines in");
        int j = 0;
        while (j < this.pathCount) {
            int i = this.pathOffset[j];
            float sw = this.vertices[this.lines[i][0]][17];
            if (sw > 0.0f) {
                this.gl.glLineWidth(sw);
                this.gl.glBegin(3);
                float[] a = this.vertices[this.lines[i][0]];
                this.gl.glColor4f(a[13], a[14], a[15], a[16]);
                this.gl.glVertex3f(a[21], a[22], a[23]);
                int k = 0;
                while (k < this.pathLength[j]) {
                    float[] b = this.vertices[this.lines[i][1]];
                    this.gl.glColor4f(b[13], b[14], b[15], b[16]);
                    this.gl.glVertex3f(b[21], b[22], b[23]);
                    ++i;
                    ++k;
                }
                this.gl.glEnd();
            }
            ++j;
        }
        this.report("render_lines out");
    }

    protected void addTriangle(int a, int b, int c) {
        this.addTriangleWithoutClip(a, b, c);
    }

    protected void renderTriangles(int start, int stop) {
        this.report("render_triangles in");
        int i = start;
        while (i < stop) {
            float[] a = this.vertices[this.triangles[i][0]];
            float[] b = this.vertices[this.triangles[i][1]];
            float[] c = this.vertices[this.triangles[i][2]];
            float ar = this.clamp(this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float ag = this.clamp(this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float ab = this.clamp(this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float br = this.clamp(this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float bg = this.clamp(this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float bb = this.clamp(this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float cr = this.clamp(this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float cg = this.clamp(this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float cb = this.clamp(this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            int textureIndex = this.triangles[i][3];
            if (textureIndex != -1) {
                this.report("before enable");
                this.gl.glEnable(3553);
                this.report("after enable");
                this.report("before bind");
                PImage texture = this.textures[textureIndex];
                this.bindTexture(texture);
                this.report("after bind");
                ImageCache cash = (ImageCache)texture.getCache(this);
                float uscale = (float)texture.width / (float)cash.twidth;
                float vscale = (float)texture.height / (float)cash.theight;
                this.gl.glBegin(4);
                this.gl.glColor4f(ar, ag, ab, a[6]);
                this.gl.glTexCoord2f(a[7] * uscale, a[8] * vscale);
                this.gl.glNormal3f(a[9], a[10], a[11]);
                this.gl.glEdgeFlag(a[12] == 1.0f);
                this.gl.glVertex3f(a[21], a[22], a[23]);
                this.gl.glColor4f(br, bg, bb, b[6]);
                this.gl.glTexCoord2f(b[7] * uscale, b[8] * vscale);
                this.gl.glNormal3f(b[9], b[10], b[11]);
                this.gl.glEdgeFlag(a[12] == 1.0f);
                this.gl.glVertex3f(b[21], b[22], b[23]);
                this.gl.glColor4f(cr, cg, cb, c[6]);
                this.gl.glTexCoord2f(c[7] * uscale, c[8] * vscale);
                this.gl.glNormal3f(c[9], c[10], c[11]);
                this.gl.glEdgeFlag(a[12] == 1.0f);
                this.gl.glVertex3f(c[21], c[22], c[23]);
                this.gl.glEnd();
                this.report("non-binding 6");
                this.gl.glDisable(3553);
            } else {
                this.gl.glBegin(4);
                this.gl.glColor4f(ar, ag, ab, a[6]);
                this.gl.glNormal3f(a[9], a[10], a[11]);
                this.gl.glEdgeFlag(a[12] == 1.0f);
                this.gl.glVertex3f(a[21], a[22], a[23]);
                this.gl.glColor4f(br, bg, bb, b[6]);
                this.gl.glNormal3f(b[9], b[10], b[11]);
                this.gl.glEdgeFlag(a[12] == 1.0f);
                this.gl.glVertex3f(b[21], b[22], b[23]);
                this.gl.glColor4f(cr, cg, cb, c[6]);
                this.gl.glNormal3f(c[9], c[10], c[11]);
                this.gl.glEdgeFlag(a[12] == 1.0f);
                this.gl.glVertex3f(c[21], c[22], c[23]);
                this.gl.glEnd();
            }
            ++i;
        }
        this.report("render_triangles out");
    }

    protected void bindTexture(PImage texture) {
        ImageCache cash = (ImageCache)texture.getCache(this);
        if (cash == null) {
            cash = new ImageCache();
            texture.setCache(this, cash);
            texture.setModified(true);
        }
        if (texture.isModified()) {
            cash.rebind(texture);
            texture.setModified(false);
        } else {
            this.gl.glBindTexture(3553, cash.tindex);
        }
    }

    public void smooth() {
        this.smooth = true;
        if (this.hints[1]) {
            this.gl.glEnable(2832);
            this.gl.glEnable(2848);
            this.gl.glEnable(2881);
        }
    }

    public void noSmooth() {
        this.smooth = false;
        if (this.hints[1]) {
            this.gl.glDisable(2832);
            this.gl.glDisable(2848);
            this.gl.glDisable(2881);
        }
    }

    public float textAscent() {
        Font font = this.textFont.getFont();
        if (this.textMode != 5 || font == null) {
            return super.textAscent();
        }
        FontMetrics metrics = this.parent.getFontMetrics(font);
        return metrics.getAscent();
    }

    public float textDescent() {
        Font font = this.textFont.getFont();
        if (this.textMode != 5 || font == null) {
            return super.textDescent();
        }
        FontMetrics metrics = this.parent.getFontMetrics(font);
        return metrics.getDescent();
    }

    public void textFont(PFont which) {
        super.textFont(which);
        if (this.textMode == 5 && this.textFont.findFont() == null) {
            PGraphicsOpenGL.showWarning("Cannot use " + which.getName() + " as with textMode(SHAPE) " + "because its native equivalent cannot be found.");
        }
    }

    protected boolean textModeCheck(int mode) {
        return this.textMode == 4 || this.textMode == 256 || this.textMode == 5;
    }

    protected float textWidthImpl(char[] buffer, int start, int stop) {
        Font font = this.textFont.getFont();
        if (this.textMode != 5 || font == null) {
            return super.textWidthImpl(buffer, start, stop);
        }
        Graphics2D graphics = (Graphics2D)this.parent.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext frc = graphics.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, buffer);
        float sum = 0.0f;
        int i = start;
        while (i < stop) {
            GlyphMetrics gm = gv.getGlyphMetrics(i);
            sum += gm.getAdvance();
            ++i;
        }
        return sum;
    }

    protected void textCharImpl(char ch, float x, float y) {
        if (this.textMode == 5) {
            if (this.textFont.getFont() == null) {
                PGraphics.showWarning("textMode(SHAPE) is disabled because the font \"" + this.textFont.getName() + "\" is not available.");
            } else {
                this.textCharShapeImpl(ch, x, y);
            }
        } else {
            super.textCharImpl(ch, x, y);
        }
    }

    protected void textCharShapeImpl(char ch, float x, float y) {
        boolean strokeSaved = this.stroke;
        this.stroke = false;
        float[] textPoints = new float[6];
        char[] textArray = new char[]{ch};
        Graphics2D graphics = (Graphics2D)this.parent.getGraphics();
        FontRenderContext frc = graphics.getFontRenderContext();
        Font font = this.textFont.getFont();
        GlyphVector gv = font.createGlyphVector(frc, textArray);
        Shape shp = gv.getOutline();
        PathIterator iter = shp.getPathIterator(null);
        this.glu.gluTessBeginPolygon(this.tobj, null);
        float lastX = 0.0f;
        float lastY = 0.0f;
        boolean DEBUG_OPCODES = false;
        while (!iter.isDone()) {
            int type = iter.currentSegment(textPoints);
            switch (type) {
                case 0: 
                case 1: {
                    if (type == 0) {
                        this.glu.gluTessBeginContour(this.tobj);
                    }
                    double[] vertex = new double[]{x + textPoints[0], y + textPoints[1], 0.0};
                    this.glu.gluTessVertex(this.tobj, vertex, 0, vertex);
                    lastX = textPoints[0];
                    lastY = textPoints[1];
                    break;
                }
                case 2: {
                    float t;
                    double[] vertex;
                    int i = 1;
                    while (i < this.bezierDetail) {
                        t = (float)i / (float)this.bezierDetail;
                        vertex = new double[]{x + this.bezierPoint(lastX, lastX + (float)((double)((textPoints[0] - lastX) * 2.0f) / 3.0), textPoints[2] + (float)((double)((textPoints[0] - textPoints[2]) * 2.0f) / 3.0), textPoints[2], t), y + this.bezierPoint(lastY, lastY + (float)((double)((textPoints[1] - lastY) * 2.0f) / 3.0), textPoints[3] + (float)((double)((textPoints[1] - textPoints[3]) * 2.0f) / 3.0), textPoints[3], t), 0.0};
                        this.glu.gluTessVertex(this.tobj, vertex, 0, vertex);
                        ++i;
                    }
                    lastX = textPoints[2];
                    lastY = textPoints[3];
                    break;
                }
                case 3: {
                    float t;
                    double[] vertex;
                    int i = 1;
                    while (i < this.bezierDetail) {
                        t = (float)i / (float)this.bezierDetail;
                        vertex = new double[]{x + this.bezierPoint(lastX, textPoints[0], textPoints[2], textPoints[4], t), y + this.bezierPoint(lastY, textPoints[1], textPoints[3], textPoints[5], t), 0.0};
                        this.glu.gluTessVertex(this.tobj, vertex, 0, vertex);
                        ++i;
                    }
                    lastX = textPoints[4];
                    lastY = textPoints[5];
                    break;
                }
                case 4: {
                    this.glu.gluTessEndContour(this.tobj);
                }
            }
            iter.next();
        }
        this.glu.gluTessEndPolygon(this.tobj);
        this.stroke = strokeSaved;
    }

    protected void updateProjection() {
        this.gl.glMatrixMode(5889);
        if (this.projectionFloats == null) {
            this.projectionFloats = new float[]{this.projection.m00, this.projection.m10, this.projection.m20, this.projection.m30, this.projection.m01, this.projection.m11, this.projection.m21, this.projection.m31, this.projection.m02, this.projection.m12, this.projection.m22, this.projection.m32, this.projection.m03, this.projection.m13, this.projection.m23, this.projection.m33};
        } else {
            this.projectionFloats[0] = this.projection.m00;
            this.projectionFloats[1] = this.projection.m10;
            this.projectionFloats[2] = this.projection.m20;
            this.projectionFloats[3] = this.projection.m30;
            this.projectionFloats[4] = this.projection.m01;
            this.projectionFloats[5] = this.projection.m11;
            this.projectionFloats[6] = this.projection.m21;
            this.projectionFloats[7] = this.projection.m31;
            this.projectionFloats[8] = this.projection.m02;
            this.projectionFloats[9] = this.projection.m12;
            this.projectionFloats[10] = this.projection.m22;
            this.projectionFloats[11] = this.projection.m32;
            this.projectionFloats[12] = this.projection.m03;
            this.projectionFloats[13] = this.projection.m13;
            this.projectionFloats[14] = this.projection.m23;
            this.projectionFloats[15] = this.projection.m33;
        }
        this.gl.glLoadMatrixf(this.projectionFloats, 0);
    }

    public void strokeWeight(float weight) {
        this.strokeWeight = weight;
    }

    public void strokeJoin(int join) {
        if (join != 8) {
            PGraphicsOpenGL.showMethodWarning("strokeJoin");
        }
    }

    public void strokeCap(int cap) {
        if (cap != 2) {
            PGraphicsOpenGL.showMethodWarning("strokeCap");
        }
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5634, this.colorBuffer, 0);
    }

    protected void ambientFromCalc() {
        super.ambientFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4608, this.colorBuffer, 0);
    }

    protected void specularFromCalc() {
        super.specularFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4610, this.colorBuffer, 0);
    }

    public void shininess(float shine) {
        super.shininess(shine);
        this.gl.glMaterialf(1032, 5633, shine);
    }

    protected void emissiveFromCalc() {
        super.emissiveFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5632, this.colorBuffer, 0);
    }

    public void ambientLight(float r, float g, float b) {
        super.ambientLight(r, g, b);
        this.glLightEnable(this.lightCount - 1);
        this.glLightAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void ambientLight(float r, float g, float b, float x, float y, float z) {
        super.ambientLight(r, g, b, x, y, z);
        this.glLightEnable(this.lightCount - 1);
        this.glLightAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void directionalLight(float r, float g, float b, float nx, float ny, float nz) {
        super.directionalLight(r, g, b, nx, ny, nz);
        this.glLightEnable(this.lightCount - 1);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightDirection(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void pointLight(float r, float g, float b, float x, float y, float z) {
        super.pointLight(r, g, b, x, y, z);
        this.glLightEnable(this.lightCount - 1);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void spotLight(float r, float g, float b, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        super.spotLight(r, g, b, x, y, z, nx, ny, nz, angle, concentration);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightDirection(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
        this.glLightSpotAngle(this.lightCount - 1);
        this.glLightSpotConcentration(this.lightCount - 1);
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        super.lightFalloff(constant, linear, quadratic);
        this.glLightFalloff(this.lightCount);
    }

    public void lightSpecular(float x, float y, float z) {
        super.lightSpecular(x, y, z);
        this.glLightSpecular(this.lightCount);
    }

    protected void lightPosition(int num, float x, float y, float z) {
        super.lightPosition(num, x, y, z);
        this.glLightPosition(num);
    }

    protected void lightDirection(int num, float x, float y, float z) {
        super.lightDirection(num, x, y, z);
        this.glLightDirection(num);
    }

    private void glLightAmbient(int num) {
        this.gl.glLightfv(16384 + num, 4608, this.lightDiffuse[num], 0);
    }

    private void glLightNoAmbient(int num) {
        if (this.zeroBuffer == null) {
            this.zeroBuffer = BufferUtil.newFloatBuffer(3);
        }
        this.gl.glLightfv(16384 + num, 4608, this.zeroBuffer);
    }

    private void glLightDiffuse(int num) {
        this.gl.glLightfv(16384 + num, 4609, this.lightDiffuse[num], 0);
    }

    private void glLightDirection(int num) {
        if (this.lightType[num] == 1) {
            this.gl.glLightfv(16384 + num, 4611, this.lightNormal[num].array(), 0);
        } else {
            this.gl.glLightfv(16384 + num, 4612, this.lightNormal[num].array(), 0);
        }
    }

    private void glLightEnable(int num) {
        this.gl.glEnable(16384 + num);
    }

    private void glLightFalloff(int num) {
        this.gl.glLightf(16384 + num, 4615, this.lightFalloffConstant[num]);
        this.gl.glLightf(16384 + num, 4616, this.lightFalloffLinear[num]);
        this.gl.glLightf(16384 + num, 4617, this.lightFalloffQuadratic[num]);
    }

    private void glLightPosition(int num) {
        this.gl.glLightfv(16384 + num, 4611, this.lightPosition[num].array(), 0);
    }

    private void glLightSpecular(int num) {
        this.gl.glLightfv(16384 + num, 4610, this.lightSpecular[num], 0);
    }

    private void glLightSpotAngle(int num) {
        this.gl.glLightf(16384 + num, 4614, this.lightSpotAngle[num]);
    }

    private void glLightSpotConcentration(int num) {
        this.gl.glLightf(16384 + num, 4613, this.lightSpotConcentration[num]);
    }

    protected void backgroundImpl(PImage image) {
        this.gl.glClearColor(this.backgroundR, this.backgroundG, this.backgroundB, 1.0f);
        this.gl.glClear(16640);
        this.set(0, 0, image);
    }

    protected void backgroundImpl() {
        this.gl.glClearColor(this.backgroundR, this.backgroundG, this.backgroundB, 1.0f);
        this.gl.glClear(16640);
    }

    private final void calcColorBuffer() {
        if (this.colorBuffer == null) {
            this.colorBuffer = new float[4];
        }
        this.colorBuffer[0] = this.calcR;
        this.colorBuffer[1] = this.calcG;
        this.colorBuffer[2] = this.calcB;
        this.colorBuffer[3] = this.calcA;
    }

    public void report(String where) {
        int err;
        if (!this.hints[6] && (err = this.gl.glGetError()) != 0) {
            String errString = this.glu.gluErrorString(err);
            String msg = "OpenGL error " + err + " at " + where + ": " + errString;
            PGraphics.showWarning(msg);
        }
    }

    public void loadPixels() {
        block10: {
            int x;
            if (this.pixels == null || this.pixels.length != this.width * this.height) {
                this.pixels = new int[this.width * this.height];
                this.pixelBuffer = BufferUtil.newIntBuffer(this.pixels.length);
            }
            this.gl.glReadPixels(0, 0, this.width, this.height, 6408, 5121, this.pixelBuffer);
            this.pixelBuffer.get(this.pixels);
            this.pixelBuffer.rewind();
            int index = 0;
            int yindex = (this.height - 1) * this.width;
            int y = 0;
            while (y < this.height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < this.width) {
                        temp = this.pixels[index];
                        this.pixels[index] = 0xFF000000 | this.pixels[yindex] >> 8 & 0xFFFFFF;
                        this.pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < this.width) {
                        temp = this.pixels[index];
                        this.pixels[index] = 0xFF000000 | this.pixels[yindex] << 16 & 0xFF0000 | this.pixels[yindex] & 0xFF00 | this.pixels[yindex] >> 16 & 0xFF;
                        this.pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= this.width * 2;
                ++y;
            }
            if (this.height % 2 != 1) break block10;
            index = this.height / 2 * this.width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < this.width) {
                    this.pixels[index] = 0xFF000000 | this.pixels[index] >> 8 & 0xFFFFFF;
                    ++x;
                }
            } else {
                x = 0;
                while (x < this.width) {
                    this.pixels[index] = 0xFF000000 | this.pixels[index] << 16 & 0xFF0000 | this.pixels[index] & 0xFF00 | this.pixels[index] >> 16 & 0xFF;
                    ++x;
                }
            }
        }
    }

    static void nativeToJavaRGB(PImage image) {
        int index = 0;
        int yindex = (image.height - 1) * image.width;
        int y = 0;
        while (y < image.height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < image.width) {
                    temp = image.pixels[index];
                    image.pixels[index] = 0xFF000000 | image.pixels[yindex] >> 8 & 0xFFFFFF;
                    image.pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < image.width) {
                    temp = image.pixels[index];
                    image.pixels[index] = 0xFF000000 | image.pixels[yindex] << 16 & 0xFF0000 | image.pixels[yindex] & 0xFF00 | image.pixels[yindex] >> 16 & 0xFF;
                    image.pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= image.width * 2;
            ++y;
        }
    }

    static void nativeToJavaARGB(PImage image) {
        int index = 0;
        int yindex = (image.height - 1) * image.width;
        int y = 0;
        while (y < image.height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < image.width) {
                    temp = image.pixels[index];
                    image.pixels[index] = image.pixels[yindex] & 0xFF000000 | image.pixels[yindex] >> 8 & 0xFFFFFF;
                    image.pixels[yindex] = temp & 0xFF000000 | temp >> 8 & 0xFFFFFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < image.width) {
                    temp = image.pixels[index];
                    image.pixels[index] = image.pixels[yindex] & 0xFF000000 | image.pixels[yindex] << 16 & 0xFF0000 | image.pixels[yindex] & 0xFF00 | image.pixels[yindex] >> 16 & 0xFF;
                    image.pixels[yindex] = temp & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= image.width * 2;
            ++y;
        }
    }

    static void javaToNativeRGB(PImage image) {
        int width = image.width;
        int height = image.height;
        int[] pixels = image.pixels;
        int index = 0;
        int yindex = (height - 1) * width;
        int y = 0;
        while (y < height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < image.width) {
                    temp = pixels[index];
                    pixels[index] = pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                    pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    temp = pixels[index];
                    pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                    pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= width * 2;
            ++y;
        }
    }

    static void javaToNativeARGB(PImage image) {
        int width = image.width;
        int height = image.height;
        int[] pixels = image.pixels;
        int index = 0;
        int yindex = (height - 1) * width;
        int y = 0;
        while (y < height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < image.width) {
                    temp = pixels[index];
                    pixels[index] = pixels[yindex] >> 24 & 0xFF | pixels[yindex] << 8 & 0xFFFFFF00;
                    pixels[yindex] = temp >> 24 & 0xFF | temp << 8 & 0xFFFFFF00;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    temp = pixels[index];
                    pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                    pixels[yindex] = pixels[yindex] & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= width * 2;
            ++y;
        }
    }

    public void updatePixels() {
        int index = 0;
        int yindex = (this.height - 1) * this.width;
        int y = 0;
        while (y < this.height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < this.width) {
                    temp = this.pixels[index];
                    this.pixels[index] = this.pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                    this.pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < this.width) {
                    temp = this.pixels[index];
                    this.pixels[index] = 0xFF000000 | this.pixels[yindex] << 16 & 0xFF0000 | this.pixels[yindex] & 0xFF00 | this.pixels[yindex] >> 16 & 0xFF;
                    this.pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= this.width * 2;
            ++y;
        }
        this.setRasterPos(0.0f, 0.0f);
        this.pixelBuffer.put(this.pixels);
        this.pixelBuffer.rewind();
        this.gl.glDrawPixels(this.width, this.height, 6408, 5121, this.pixelBuffer);
    }

    public void resize(int wide, int high) {
        PGraphics.showMethodWarning("resize");
    }

    public int get(int x, int y) {
        this.gl.glReadPixels(x, y, 1, 1, 6408, 5121, this.getsetBuffer);
        int getset = this.getsetBuffer.get(0);
        if (BIG_ENDIAN) {
            return 0xFF000000 | getset >> 8 & 0xFFFFFF;
        }
        return 0xFF000000 | getset << 16 & 0xFF0000 | getset & 0xFF00 | getset >> 16 & 0xFF;
    }

    protected PImage getImpl(int x, int y, int w, int h) {
        PImage newbie = new PImage(w, h);
        newbie.parent = this.parent;
        IntBuffer newbieBuffer = BufferUtil.newIntBuffer(w * h);
        this.gl.glReadPixels(x, y, w, h, 6408, 5121, newbieBuffer);
        newbieBuffer.get(newbie.pixels);
        PGraphicsOpenGL.nativeToJavaARGB(newbie);
        return newbie;
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int x, int y, int argb) {
        int getset = 0;
        getset = BIG_ENDIAN ? argb << 8 | 0xFF : argb & 0xFF00FF00 | argb << 16 & 0xFF0000 | argb >> 16 & 0xFF;
        this.getsetBuffer.put(0, getset);
        this.getsetBuffer.rewind();
        this.setRasterPos(x, this.height - y - 1);
        this.gl.glDrawPixels(1, 1, 6408, 5121, this.getsetBuffer);
    }

    public void set(int x, int y, PImage source) {
        int[] backup = new int[source.pixels.length];
        System.arraycopy(source.pixels, 0, backup, 0, source.pixels.length);
        PGraphicsOpenGL.javaToNativeARGB(source);
        IntBuffer setBuffer = BufferUtil.newIntBuffer(source.pixels.length);
        setBuffer.put(source.pixels);
        setBuffer.rewind();
        this.setRasterPos(x, this.height - y - source.height);
        this.gl.glDrawPixels(source.width, source.height, 6408, 5121, setBuffer);
        source.pixels = backup;
    }

    protected void setRasterPos(float x, float y) {
        float z = 0.0f;
        float w = 1.0f;
        this.gl.glPushAttrib(6144);
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDepthRange(z, z);
        this.gl.glViewport((int)x - 1, (int)y - 1, 2, 2);
        float fx = x - (float)((int)x);
        float fy = y - (float)((int)y);
        this.gl.glRasterPos4f(fx, fy, 0.0f, w);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glPopAttrib();
    }

    public void mask(int[] alpha) {
        PGraphics.showMethodWarning("mask");
    }

    public void mask(PImage alpha) {
        PGraphics.showMethodWarning("mask");
    }

    public void filter(int kind) {
        PImage temp = this.get();
        temp.filter(kind);
        this.set(0, 0, temp);
    }

    public void filter(int kind, float param) {
        PImage temp = this.get();
        temp.filter(kind, param);
        this.set(0, 0, temp);
    }

    protected final float clamp(float a) {
        return a < 1.0f ? a : 1.0f;
    }

    protected class ImageCache {
        int tindex = -1;
        int[] tpixels;
        IntBuffer tbuffer;
        public int twidth;
        public int theight;
        int[] tp;

        protected ImageCache() {
        }

        protected void finalize() {
            if (PGraphicsOpenGL.this.textureDeleteQueue.length == PGraphicsOpenGL.this.textureDeleteQueueCount) {
                PGraphicsOpenGL.this.textureDeleteQueue = PApplet.expand(PGraphicsOpenGL.this.textureDeleteQueue);
            }
            if (this.tindex != -1) {
                PGraphicsOpenGL.this.textureDeleteQueue[PGraphicsOpenGL.this.textureDeleteQueueCount++] = this.tindex;
            }
        }

        public void rebind(PImage source) {
            block29: {
                int p;
                block28: {
                    if (PGraphicsOpenGL.this.textureDeleteQueueCount != 0) {
                        PGraphicsOpenGL.this.gl.glDeleteTextures(PGraphicsOpenGL.this.textureDeleteQueueCount, PGraphicsOpenGL.this.textureDeleteQueue, 0);
                        PGraphicsOpenGL.this.textureDeleteQueueCount = 0;
                    }
                    if (this.tindex != -1) {
                        PGraphicsOpenGL.this.gl.glDeleteTextures(1, new int[]{this.tindex}, 0);
                    }
                    int[] tmp = new int[1];
                    PGraphicsOpenGL.this.gl.glGenTextures(1, tmp, 0);
                    this.tindex = tmp[0];
                    int width2 = this.nextPowerOfTwo(source.width);
                    int height2 = this.nextPowerOfTwo(source.height);
                    if (maxTextureSize == 0) {
                        int[] maxSize = new int[1];
                        PGraphicsOpenGL.this.gl.glGetIntegerv(3379, maxSize, 0);
                        maxTextureSize = maxSize[0];
                    }
                    if (width2 > maxTextureSize || height2 > maxTextureSize) {
                        throw new RuntimeException("Image width and height cannot be larger than " + maxTextureSize + " with this graphics card.");
                    }
                    if (width2 > this.twidth || height2 > this.theight) {
                        this.tpixels = null;
                    }
                    if (this.tpixels == null) {
                        this.twidth = width2;
                        this.theight = height2;
                        this.tpixels = new int[this.twidth * this.theight];
                        this.tbuffer = BufferUtil.newIntBuffer(this.twidth * this.theight);
                    }
                    p = 0;
                    int t = 0;
                    if (!BIG_ENDIAN) break block28;
                    switch (source.format) {
                        case 4: {
                            int y = 0;
                            while (y < source.height) {
                                int x = 0;
                                while (x < source.width) {
                                    this.tpixels[t++] = 0xFFFFFF00 | source.pixels[p++];
                                    ++x;
                                }
                                t += this.twidth - source.width;
                                ++y;
                            }
                            break block29;
                        }
                        case 1: {
                            int y = 0;
                            while (y < source.height) {
                                int x = 0;
                                while (x < source.width) {
                                    int pixel = source.pixels[p++];
                                    this.tpixels[t++] = pixel << 8 | 0xFF;
                                    ++x;
                                }
                                t += this.twidth - source.width;
                                ++y;
                            }
                            break block29;
                        }
                        case 2: {
                            int y = 0;
                            while (y < source.height) {
                                int x = 0;
                                while (x < source.width) {
                                    int pixel = source.pixels[p++];
                                    this.tpixels[t++] = pixel << 8 | pixel >> 24 & 0xFF;
                                    ++x;
                                }
                                t += this.twidth - source.width;
                                ++y;
                            }
                            break block0;
                        }
                    }
                    break block29;
                }
                switch (source.format) {
                    case 4: {
                        int y = 0;
                        while (y < source.height) {
                            int x = 0;
                            while (x < source.width) {
                                this.tpixels[t++] = source.pixels[p++] << 24 | 0xFFFFFF;
                                ++x;
                            }
                            t += this.twidth - source.width;
                            ++y;
                        }
                        break;
                    }
                    case 1: {
                        int y = 0;
                        while (y < source.height) {
                            int x = 0;
                            while (x < source.width) {
                                int pixel = source.pixels[p++];
                                this.tpixels[t++] = 0xFF000000 | (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00;
                                ++x;
                            }
                            t += this.twidth - source.width;
                            ++y;
                        }
                        break;
                    }
                    case 2: {
                        int y = 0;
                        while (y < source.height) {
                            int x = 0;
                            while (x < source.width) {
                                int pixel = source.pixels[p++];
                                this.tpixels[t++] = (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00FF00;
                                ++x;
                            }
                            t += this.twidth - source.width;
                            ++y;
                        }
                        break;
                    }
                }
            }
            this.tbuffer.put(this.tpixels);
            this.tbuffer.rewind();
            PGraphicsOpenGL.this.gl.glBindTexture(3553, this.tindex);
            PGraphicsOpenGL.this.gl.glPixelStorei(3317, 1);
            PGraphicsOpenGL.this.gl.glTexImage2D(3553, 0, 4, this.twidth, this.theight, 0, 6408, 5121, this.tbuffer);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10240, 9729.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10241, 9729.0f);
            PGraphicsOpenGL.this.glu.gluBuild2DMipmaps(3553, 4, this.twidth, this.theight, 6408, 5121, this.tbuffer);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10240, 9729.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10241, 9987.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10242, 33071.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10243, 33071.0f);
            PGraphicsOpenGL.this.gl.glTexEnvf(8960, 8704, 8448.0f);
        }

        private int nextPowerOfTwo(int val) {
            int ret = 1;
            while (ret < val) {
                ret <<= 1;
            }
            return ret;
        }
    }

    public class TessCallback
    extends GLUtessellatorCallbackAdapter {
        public void begin(int type) {
            switch (type) {
                case 6: {
                    PGraphicsOpenGL.this.beginShape(11);
                    break;
                }
                case 5: {
                    PGraphicsOpenGL.this.beginShape(10);
                    break;
                }
                case 4: {
                    PGraphicsOpenGL.this.beginShape(9);
                }
            }
        }

        public void end() {
            PGraphicsOpenGL.this.endShape();
        }

        public void edge(boolean e) {
            PGraphicsOpenGL.this.edge(e);
        }

        public void vertex(Object data) {
            double[] d;
            if (data instanceof double[]) {
                d = (double[])data;
                if (d.length != 3) {
                    throw new RuntimeException("TessCallback vertex() data isn't length 3");
                }
            } else {
                throw new RuntimeException("TessCallback vertex() data not understood");
            }
            PGraphicsOpenGL.this.vertex((float)d[0], (float)d[1], (float)d[2]);
        }

        public void error(int errnum) {
            String estring = PGraphicsOpenGL.this.glu.gluErrorString(errnum);
            PGraphics.showWarning("Tessellation Error: " + estring);
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            double[] vertex = new double[coords.length];
            vertex[0] = coords[0];
            vertex[1] = coords[1];
            vertex[2] = coords[2];
            outData[0] = vertex;
        }
    }
}

