/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;

public class PShape
implements PConstants {
    protected String name;
    protected HashMap<String, PShape> nameTable;
    public static final int GROUP = 0;
    public static final int PRIMITIVE = 1;
    public static final int PATH = 2;
    public static final int GEOMETRY = 3;
    protected int family;
    protected int primitive;
    protected PMatrix matrix;
    protected PImage image;
    public float width;
    public float height;
    protected boolean visible = true;
    protected boolean stroke;
    protected int strokeColor;
    protected float strokeWeight;
    protected int strokeCap;
    protected int strokeJoin;
    protected boolean fill;
    protected int fillColor;
    protected boolean style = true;
    protected float[] params;
    protected int vertexCount;
    protected float[][] vertices;
    public static final int VERTEX = 0;
    public static final int BEZIER_VERTEX = 1;
    public static final int CURVE_VERTEX = 2;
    public static final int BREAK = 3;
    protected int vertexCodeCount;
    protected int[] vertexCodes;
    protected boolean close;
    protected PShape parent;
    protected int childCount;
    protected PShape[] children;

    public PShape() {
        this.family = 0;
    }

    public PShape(int family) {
        this.family = family;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void disableStyle() {
        this.style = false;
        int i = 0;
        while (i < this.childCount) {
            this.children[i].disableStyle();
            ++i;
        }
    }

    public void enableStyle() {
        this.style = true;
        int i = 0;
        while (i < this.childCount) {
            this.children[i].enableStyle();
            ++i;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    protected void pre(PGraphics g) {
        if (this.matrix != null) {
            g.pushMatrix();
            g.applyMatrix(this.matrix);
        }
        if (this.style) {
            g.pushStyle();
            this.styles(g);
        }
    }

    protected void styles(PGraphics g) {
        if (this.stroke) {
            g.stroke(this.strokeColor);
            g.strokeWeight(this.strokeWeight);
            g.strokeCap(this.strokeCap);
            g.strokeJoin(this.strokeJoin);
        } else {
            g.noStroke();
        }
        if (this.fill) {
            g.fill(this.fillColor);
        } else {
            g.noFill();
        }
    }

    public void post(PGraphics g) {
        if (this.matrix != null) {
            g.popMatrix();
        }
        if (this.style) {
            g.popStyle();
        }
    }

    public void draw(PGraphics g) {
        if (this.visible) {
            this.pre(g);
            this.drawImpl(g);
            this.post(g);
        }
    }

    public void drawImpl(PGraphics g) {
        if (this.family == 0) {
            this.drawGroup(g);
        } else if (this.family == 1) {
            this.drawPrimitive(g);
        } else if (this.family == 3) {
            this.drawGeometry(g);
        } else if (this.family == 2) {
            this.drawPath(g);
        }
    }

    protected void drawGroup(PGraphics g) {
        int i = 0;
        while (i < this.childCount) {
            this.children[i].draw(g);
            ++i;
        }
    }

    protected void drawPrimitive(PGraphics g) {
        if (this.primitive == 2) {
            g.point(this.params[0], this.params[1]);
        } else if (this.primitive == 4) {
            if (this.params.length == 4) {
                g.line(this.params[0], this.params[1], this.params[2], this.params[3]);
            } else {
                g.line(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
            }
        } else if (this.primitive == 8) {
            g.triangle(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
        } else if (this.primitive == 16) {
            g.quad(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5], this.params[6], this.params[7]);
        } else if (this.primitive == 30) {
            if (this.image != null) {
                g.imageMode(0);
                g.image(this.image, this.params[0], this.params[1], this.params[2], this.params[3]);
            } else {
                g.rectMode(0);
                g.rect(this.params[0], this.params[1], this.params[2], this.params[3]);
            }
        } else if (this.primitive == 31) {
            g.ellipseMode(0);
            g.ellipse(this.params[0], this.params[1], this.params[2], this.params[3]);
        } else if (this.primitive == 32) {
            g.ellipseMode(0);
            g.arc(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
        } else if (this.primitive == 41) {
            if (this.params.length == 1) {
                g.box(this.params[0]);
            } else {
                g.box(this.params[0], this.params[1], this.params[2]);
            }
        } else if (this.primitive == 40) {
            g.sphere(this.params[0]);
        }
    }

    protected void drawGeometry(PGraphics g) {
        g.beginShape(this.primitive);
        if (this.style) {
            int i = 0;
            while (i < this.vertexCount) {
                g.vertex(this.vertices[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.vertexCount) {
                float[] vert = this.vertices[i];
                if (vert[2] == 0.0f) {
                    g.vertex(vert[0], vert[1]);
                } else {
                    g.vertex(vert[0], vert[1], vert[2]);
                }
                ++i;
            }
        }
        g.endShape();
    }

    protected void drawPath(PGraphics g) {
        if (this.vertices == null) {
            return;
        }
        g.beginShape();
        if (this.vertexCodeCount == 0) {
            if (this.vertices[0].length == 2) {
                int i = 0;
                while (i < this.vertexCount) {
                    g.vertex(this.vertices[i][0], this.vertices[i][1]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.vertexCount) {
                    g.vertex(this.vertices[i][0], this.vertices[i][1], this.vertices[i][2]);
                    ++i;
                }
            }
        } else {
            int index = 0;
            if (this.vertices[0].length == 2) {
                int j = 0;
                while (j < this.vertexCodeCount) {
                    switch (this.vertexCodes[j]) {
                        case 0: {
                            g.vertex(this.vertices[index][0], this.vertices[index][1]);
                            ++index;
                            break;
                        }
                        case 1: {
                            g.bezierVertex(this.vertices[index + 0][0], this.vertices[index + 0][1], this.vertices[index + 1][0], this.vertices[index + 1][1], this.vertices[index + 2][0], this.vertices[index + 2][1]);
                            index += 3;
                            break;
                        }
                        case 2: {
                            g.curveVertex(this.vertices[index][0], this.vertices[index][1]);
                            ++index;
                        }
                        case 3: {
                            g.breakShape();
                        }
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < this.vertexCodeCount) {
                    switch (this.vertexCodes[j]) {
                        case 0: {
                            g.vertex(this.vertices[index][0], this.vertices[index][1], this.vertices[index][2]);
                            ++index;
                            break;
                        }
                        case 1: {
                            g.bezierVertex(this.vertices[index + 0][0], this.vertices[index + 0][1], this.vertices[index + 0][2], this.vertices[index + 1][0], this.vertices[index + 1][1], this.vertices[index + 1][2], this.vertices[index + 2][0], this.vertices[index + 2][1], this.vertices[index + 2][2]);
                            index += 3;
                            break;
                        }
                        case 2: {
                            g.curveVertex(this.vertices[index][0], this.vertices[index][1], this.vertices[index][2]);
                            ++index;
                        }
                        case 3: {
                            g.breakShape();
                        }
                    }
                    ++j;
                }
            }
        }
        g.endShape(this.close ? 2 : 1);
    }

    public int getChildCount() {
        return this.childCount;
    }

    public PShape getChild(int index) {
        return this.children[index];
    }

    public PShape getChild(String target) {
        PShape found;
        if (this.name != null && this.name.equals(target)) {
            return this;
        }
        if (this.nameTable != null && (found = this.nameTable.get(target)) != null) {
            return found;
        }
        int i = 0;
        while (i < this.childCount) {
            PShape found2 = this.children[i].getChild(target);
            if (found2 != null) {
                return found2;
            }
            ++i;
        }
        return null;
    }

    public PShape findChild(String target) {
        if (this.parent == null) {
            return this.getChild(target);
        }
        return this.parent.findChild(target);
    }

    public void addChild(PShape who) {
        if (this.children == null) {
            this.children = new PShape[1];
        }
        if (this.childCount == this.children.length) {
            this.children = (PShape[])PApplet.expand(this.children);
        }
        this.children[this.childCount++] = who;
        who.parent = this;
        if (who.getName() != null) {
            this.addName(who.getName(), who);
        }
    }

    protected void addName(String nom, PShape shape) {
        if (this.parent != null) {
            this.parent.addName(nom, shape);
        } else {
            if (this.nameTable == null) {
                this.nameTable = new HashMap();
            }
            this.nameTable.put(nom, shape);
        }
    }

    public int getFamily() {
        return this.family;
    }

    public int getPrimitive() {
        return this.primitive;
    }

    public float[] getParams() {
        return this.getParams(null);
    }

    public float[] getParams(float[] target) {
        if (target == null || target.length != this.params.length) {
            target = new float[this.params.length];
        }
        PApplet.arrayCopy(this.params, target);
        return target;
    }

    public float getParam(int index) {
        return this.params[index];
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public float[] getVertex(int index) {
        if (index < 0 || index >= this.vertexCount) {
            String msg = "No vertex " + index + " for this shape, " + "only vertices 0 through " + (this.vertexCount - 1) + ".";
            throw new IllegalArgumentException(msg);
        }
        return this.vertices[index];
    }

    public float getVertexX(int index) {
        return this.vertices[index][0];
    }

    public float getVertexY(int index) {
        return this.vertices[index][1];
    }

    public float getVertexZ(int index) {
        return this.vertices[index][2];
    }

    public int[] getVertexCodes() {
        if (this.vertexCodes.length != this.vertexCodeCount) {
            this.vertexCodes = PApplet.subset(this.vertexCodes, 0, this.vertexCodeCount);
        }
        return this.vertexCodes;
    }

    public int getVertexCodeCount() {
        return this.vertexCodeCount;
    }

    public int getVertexCode(int index) {
        return this.vertexCodes[index];
    }

    public boolean contains(float x, float y) {
        if (this.family == 2) {
            boolean c = false;
            int i = 0;
            int j = this.vertexCount - 1;
            while (i < this.vertexCount) {
                if (this.vertices[i][1] > y != this.vertices[j][1] > y && x < (this.vertices[j][0] - this.vertices[i][0]) * (y - this.vertices[i][1]) / (this.vertices[j][1] - this.vertices[i][1]) + this.vertices[i][0]) {
                    c = !c;
                }
                j = i++;
            }
            return c;
        }
        throw new IllegalArgumentException("The contains() method is only implemented for paths.");
    }

    public void translate(float tx, float ty) {
        this.checkMatrix(2);
        this.matrix.translate(tx, ty);
    }

    public void translate(float tx, float ty, float tz) {
        this.checkMatrix(3);
        this.matrix.translate(tx, ty, 0.0f);
    }

    public void rotateX(float angle) {
        this.rotate(angle, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float angle) {
        this.rotate(angle, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float angle) {
        this.rotate(angle, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float angle) {
        this.checkMatrix(2);
        this.matrix.rotate(angle);
    }

    public void rotate(float angle, float v0, float v1, float v2) {
        this.checkMatrix(3);
        this.matrix.rotate(angle, v0, v1, v2);
    }

    public void scale(float s) {
        this.checkMatrix(2);
        this.matrix.scale(s);
    }

    public void scale(float x, float y) {
        this.checkMatrix(2);
        this.matrix.scale(x, y);
    }

    public void scale(float x, float y, float z) {
        this.checkMatrix(3);
        this.matrix.scale(x, y, z);
    }

    public void resetMatrix() {
        this.checkMatrix(2);
        this.matrix.reset();
    }

    public void applyMatrix(PMatrix source) {
        if (source instanceof PMatrix2D) {
            this.applyMatrix((PMatrix2D)source);
        } else if (source instanceof PMatrix3D) {
            this.applyMatrix((PMatrix3D)source);
        }
    }

    public void applyMatrix(PMatrix2D source) {
        this.applyMatrix(source.m00, source.m01, 0.0f, source.m02, source.m10, source.m11, 0.0f, source.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.checkMatrix(2);
        this.matrix.apply(n00, n01, n02, 0.0f, n10, n11, n12, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void apply(PMatrix3D source) {
        this.applyMatrix(source.m00, source.m01, source.m02, source.m03, source.m10, source.m11, source.m12, source.m13, source.m20, source.m21, source.m22, source.m23, source.m30, source.m31, source.m32, source.m33);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.checkMatrix(3);
        this.matrix.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    protected void checkMatrix(int dimensions) {
        if (this.matrix == null) {
            this.matrix = dimensions == 2 ? new PMatrix2D() : new PMatrix3D();
        } else if (dimensions == 3 && this.matrix instanceof PMatrix2D) {
            this.matrix = new PMatrix3D(this.matrix);
        }
    }
}

