/*
 * Decompiled with CFR 0.152.
 */
package main;

import audio.MIDI_Input;
import fullscreen.FullScreen;
import graphic.Brush;
import graphic.CanvasAnalysis;
import graphic.ColorManagement;
import graphic.DirectionManagement;
import graphic.HitBorderEvent;
import graphic.HitBorderEventListener;
import gui.Setup;
import gui.StartAnimation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import processing.core.PApplet;
import promidi.Note;

public class Main
extends PApplet
implements HitBorderEventListener {
    private static final long serialVersionUID = 5853628603517515934L;
    private int STAKKATO_TIME = 13;
    private int DURATION_TRESHOLD_SMALL = 150;
    private int HPS_TRESHOLD_SMALL = 19;
    private int DURATION_TRESHOLD_LARGE = 250;
    private int HPS_TRESHOLD_LARGE = 29;
    private boolean pdfOut = false;
    final JFileChooser fc = new JFileChooser();
    private String filename = "beginRecordFile";
    private Frame thisFrame;
    private FullScreen fullscreen;
    private MIDI_Input midiInput;
    private CanvasAnalysis canvasAnalysis;
    private ColorManagement colorManagement;
    private DirectionManagement directionManagement;
    private Setup primarySetup;
    private StartAnimation startAnimation;
    private boolean upAndRunning = true;
    private boolean notesArePlayed = false;
    private boolean paintingInProgress = false;
    private long startingPointForPlayedNotes;
    private long TIME_SPAN_FOR_PLAYED_NOTES = 700L;
    private boolean firstNote = true;
    private int stakkatoCounter1 = 0;
    private int stakkatoCounter2 = 0;
    private int[] initialColor = new int[]{255, 255, 255, 255};
    private Brush b1;
    private Brush b2;

    public static void main(String[] args) {
        PApplet.main(new String[]{Main.class.getName()});
    }

    @Override
    public void setup() {
        this.thisFrame = this.findFrame();
        this.thisFrame.setTitle("the singing Canvas");
        this.size(440, 700);
        this.frameRate(30.0f);
        this.fullscreen = new FullScreen(this);
        this.fullscreen.setShortcutsEnabled(true);
        this.thisFrame.setIconImage(this.getToolkit().getImage("sketch.ico"));
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        MenuBar menuBar = new MenuBar();
        Menu viewMenu = new Menu("View");
        menuBar.add(viewMenu);
        MenuItem fullScreenAction = new MenuItem("Fullscreen   cmd+f");
        viewMenu.add(fullScreenAction);
        fullScreenAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Main.this.fullscreen.setFullScreen(true);
            }
        });
        this.frame.setMenuBar(menuBar);
        this.midiInput = new MIDI_Input(this);
        this.primarySetup = new Setup(this);
        this.primarySetup.setMidiInputs(this.midiInput.getDeviceNames());
        this.primarySetup.hideGUI();
        this.initialize();
    }

    private void initialize() {
        this.background(255);
        this.beginRecord("processing.pdf.PGraphicsPDF", String.valueOf(this.filename) + ".pdf");
        this.primarySetup.showGUI();
        this.colorManagement = new ColorManagement();
        this.canvasAnalysis = new CanvasAnalysis(this, 20, 20);
        this.directionManagement = new DirectionManagement();
        this.startAnimation = new StartAnimation(this);
        this.midiInput.initialize();
        this.firstNote = true;
        this.smooth();
        this.b1 = new Brush(this, this.initialColor, this.width / 2, this.height / 2, 0.0f, 0.0f, 10, "BRUSH");
        this.b2 = new Brush(this, this.initialColor, this.width / 2, this.height / 2, 0.0f, 0.0f, 10, "FEATHER");
        this.b1.addHitBorderEventListener(this);
        this.b2.addHitBorderEventListener(this);
    }

    @Override
    public void draw() {
        if (!this.primarySetup.isVisible()) {
            this.paintingInProgress = this.startAnimation.getReadyState();
            this.checkIfNotesArePlayed();
            if (this.paintingInProgress && this.notesArePlayed) {
                this.b1.setSpeed(this.midiInput.getHpsCounterData());
                this.b1.setAlpha(this.midiInput.getVolumeAnalyserData());
                this.b1.setColor(this.colorManagement.getColor(this.midiInput.getNoteDetectionData(), this.midiInput.getPitch(), this.midiInput.getOverallTune()));
                this.b1.setThickness(this.midiInput.getNoteDurationsData(), this.midiInput.getPitch());
                this.directionManagement.adjustSteps(this.midiInput.getHpsCounterData());
                float dirX = this.directionManagement.analyseDirectionX(this.midiInput.getNoteTurningPointsTurns(), this.midiInput.getNoteTurningPointsMainDirection());
                float dirY = this.directionManagement.analyseDirectionY(this.midiInput.getNoteTurningPointsTurns(), this.midiInput.getNoteTurningPointsMainDirection());
                this.b1.setCurveDirection(dirX, dirY);
                this.b1.moveBrush();
                this.b2.setSpeed(this.midiInput.getHpsCounterData());
                this.b2.setAlpha(this.midiInput.getVolumeAnalyserData());
                this.b2.setColor(this.colorManagement.getColor(this.midiInput.getNoteDetectionData(), this.midiInput.getPitch(), this.midiInput.getOverallTune()));
                this.b2.setCurveDirection(dirY, dirX);
                this.b2.setThickness(0.0f, 0.0f);
                this.b2.moveBrush();
                if (this.midiInput.getNoteDurationsData() < (float)this.DURATION_TRESHOLD_SMALL && this.midiInput.getHpsCounterData() > this.HPS_TRESHOLD_SMALL) {
                    if (this.stakkatoCounter1 == 0) {
                        this.b1.setNewPosition(this.canvasAnalysis.getNewPosition(false));
                    }
                    ++this.stakkatoCounter1;
                    if (this.stakkatoCounter1 == this.STAKKATO_TIME) {
                        this.stakkatoCounter1 = 0;
                    }
                }
                if (this.midiInput.getNoteDurationsData() < (float)this.DURATION_TRESHOLD_LARGE && this.midiInput.getHpsCounterData() > this.HPS_TRESHOLD_LARGE) {
                    if (this.stakkatoCounter2 == 0) {
                        this.b2.setNewPosition(this.b1.getCurrentPosition());
                    }
                    ++this.stakkatoCounter2;
                    if (this.stakkatoCounter2 == this.STAKKATO_TIME) {
                        this.stakkatoCounter2 = 0;
                    }
                }
            } else {
                this.startAnimation.setAnimStage(this.midiInput.getReadyState());
            }
        } else {
            this.startAnimation.setAnimStage(0);
        }
    }

    public void noteOn(Note note, int device, int channel) {
        if (!this.primarySetup.isVisible() && this.upAndRunning && !this.pdfOut) {
            this.midiInput.noteOn(note, device, channel);
            this.notesArePlayed = true;
            this.startingPointForPlayedNotes = System.currentTimeMillis();
            if (this.firstNote) {
                this.firstNote = false;
                this.startAnimation.startTheAnimation();
            }
        }
    }

    public void noteOff(Note note, int device, int channel) {
        if (this.upAndRunning && !this.pdfOut) {
            this.midiInput.noteOff(note);
        }
    }

    @Override
    public void keyPressed() {
        if (this.key == '\u001b') {
            this.key = '\u0000';
            if (this.fullscreen.isFullScreen()) {
                this.fullscreen.setFullScreen(false);
            }
        }
        if (this.keyCode == 10) {
            this.startButton(0);
        }
        if (this.keyCode == 9) {
            this.primarySetup.changeInputFocus();
        }
        if (this.key == 'p' && !this.primarySetup.isVisible()) {
            this.printButton(0);
        }
    }

    private void checkIfNotesArePlayed() {
        if (System.currentTimeMillis() - this.startingPointForPlayedNotes > this.TIME_SPAN_FOR_PLAYED_NOTES) {
            this.notesArePlayed = false;
        }
    }

    public Frame findFrame() {
        Container f = this.getParent();
        while (!(f instanceof Frame) && f != null) {
            f = f.getParent();
        }
        return (Frame)f;
    }

    @Override
    public void hitBorderEventOccurred(HitBorderEvent evt) {
        if (evt.getMode() == "BRUSH") {
            ((Brush)evt.getSource()).setNewPosition(this.canvasAnalysis.getNewPosition(false));
        } else {
            ((Brush)evt.getSource()).setNewPosition(this.canvasAnalysis.getNewPosition(true));
        }
    }

    public void startButton(int value) {
        if (this.primarySetup.isVisible()) {
            if (this.primarySetup.getRadioState() == -1) {
                this.primarySetup.setMidiInputs(this.midiInput.getDeviceNames());
            } else {
                this.midiInput.openMidiInput(this.primarySetup.getRadioState());
                if (this.primarySetup.checkData()) {
                    this.endRecord();
                    String fileToDeletePath = this.dataPath(String.valueOf(this.sketchPath) + System.getProperty("file.separator") + this.filename + ".pdf");
                    File f = new File(fileToDeletePath);
                    if (f.exists()) {
                        f.delete();
                    }
                    this.filename = this.primarySetup.getFilename();
                    this.beginRecord("processing.pdf.PGraphicsPDF", String.valueOf(this.filename) + ".pdf");
                    this.primarySetup.hideGUI();
                }
            }
        }
    }

    public void printButton(int value) {
        this.strokeWeight(1.0f);
        this.endRecord();
        this.filename = "beginRecord";
        this.initialize();
    }
}

