/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.GFont;
import guicomponents.GSlider;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GWSlider
extends GSlider {
    public String unit;
    protected PImage _leftEnd;
    protected PImage _thumb;
    protected PImage _thumb_mouseover;
    protected PImage _rightEnd;
    protected PImage _centre;
    protected String _skin;
    protected int _numTicks;
    protected int _tickLength;
    protected int _tickOffset;
    protected int _precision;
    protected boolean _renderMaxMinLabel;
    protected boolean _renderValueLabel;
    protected boolean _stickToTicks;
    protected String[] _tickLabels;
    protected boolean _isMouseOverThumb;
    protected boolean _mousePressedOverThumb;
    protected int[] _tickPositions;
    protected float[] _tickValues;
    protected int _tickColour;
    protected int _fontColour;
    protected int _currTickStuck;

    public void setPrecision(int acc) {
        this._precision = PApplet.constrain(acc, 0, 6);
    }

    public void setValueType(int type) {
        this._valueType = type;
    }

    public void setValue(int newValue) {
        this.value = PApplet.constrain((float)newValue, this.minValue, this.maxValue);
        this.thumbTargetPos = (int)PApplet.map(this.value, this.minValue, this.maxValue, this.thumbMin, this.thumbMax);
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setValue(float newValue) {
        this.value = PApplet.constrain(newValue, this.minValue, this.maxValue);
        this.thumbTargetPos = (int)PApplet.map(this.value, this.minValue, this.maxValue, this.thumbMin, this.thumbMax);
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setValueToTickNumber(int tickNo) {
        if (this._stickToTicks) {
            tickNo = PApplet.constrain(tickNo, 0, this._numTicks);
            float newValue = PApplet.map(tickNo, 0.0f, this._numTicks, this.minValue, this.maxValue);
            this._stickToTickByValue(newValue);
        }
    }

    public void setTickCount(int nbrTicks) {
        this._numTicks = nbrTicks;
        this._tickLabels = null;
        this._calcTickPositions();
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setTickLabels(String[] lbls) {
        this._tickLabels = lbls;
        this._numTicks = lbls.length - 1;
        this._calcTickPositions();
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setStickToTicks(boolean stick) {
        this._stickToTicks = stick;
        if (stick) {
            this._stickToTickByValue(this.value);
        }
        this._calcTickPositions();
    }

    public void setTickLength(int l) {
        this._tickLength = PApplet.constrain(l, 1, 10);
        this._calcControlWidthHeight();
    }

    public void setRenderMaxMinLabel(boolean showMinMax) {
        this._renderMaxMinLabel = showMinMax;
        this._calcControlWidthHeight();
    }

    public void setRenderValueLabel(boolean showValue) {
        this._renderValueLabel = showValue;
    }

    public void setTickColour(int R, int G, int B) {
        this.setTickColour(this.winApp.color(R, G, B));
    }

    public void setTickColour(int c) {
        this._tickColour = c;
    }

    public void setFontColour(int R, int G, int B) {
        this.setFontColour(this.winApp.color(R, G, B));
    }

    public void setFontColour(int c) {
        this._fontColour = c;
    }

    public GWSlider(PApplet theApplet, int x, int y, int length) {
        this(theApplet, "gwSlider", x, y, length);
    }

    public GWSlider(PApplet theApplet, String skin, int x, int y, int length) {
        super(theApplet, x, y, length, 1);
        if (length < 1) {
            throw new RuntimeException("Length of slider must be greater than 0.");
        }
        this.createEventHandler(this.winApp, "handleSliderEvents", new Class[]{GSlider.class});
        this._skin = skin == null ? "gwSlider" : skin;
        this._numTicks = 5;
        this._tickLength = 5;
        this._tickOffset = 3;
        this._renderMaxMinLabel = true;
        this._renderValueLabel = true;
        this._stickToTicks = false;
        this._precision = 2;
        this._valueType = 0;
        this._tickColour = this.winApp.color(0);
        this._fontColour = this.winApp.color(0);
        this.unit = "";
        this._leftEnd = theApplet.loadImage(String.valueOf(this._skin) + "/end_left.png");
        this._rightEnd = theApplet.loadImage(String.valueOf(this._skin) + "/end_right.png");
        this._thumb = theApplet.loadImage(String.valueOf(this._skin) + "/handle.png");
        this._thumb_mouseover = theApplet.loadImage(String.valueOf(this._skin) + "/handle_mouseover.png");
        PImage cTemp = theApplet.loadImage(String.valueOf(this._skin) + "/centre.png");
        String files = "";
        if (this._leftEnd == null) {
            files = String.valueOf(files) + "end_left.png\n";
        }
        if (this._rightEnd == null) {
            files = String.valueOf(files) + "end_right.png\n";
        }
        if (this._thumb == null) {
            files = String.valueOf(files) + "handle.png\n";
        }
        if (this._thumb_mouseover == null) {
            files = String.valueOf(files) + "handle_mouseover.png\n";
        }
        if (cTemp == null) {
            files = String.valueOf(files) + "centre.png\n";
        }
        if (files != "") {
            PApplet.println("The following files could not be found for the skin " + this._skin + ": \n" + files + "\nCheck that these files are correctly placed in the data directory under a folder with" + " the same name as the skin used.\n");
        }
        if (cTemp.width != 1) {
            PApplet.println("The supplied centre image for this skin is not of width 1px.");
        }
        if (cTemp.height != this._leftEnd.height || cTemp.height != this._rightEnd.height) {
            PApplet.println("The image components of the slider are not all the same height.");
        }
        this.height = cTemp.height;
        int cWidth = length - this._leftEnd.width - this._rightEnd.width;
        if (cWidth < 0) {
            cWidth = 0;
        }
        this._centre = new PImage(cWidth, cTemp.height);
        cTemp.loadPixels();
        this._centre.loadPixels();
        int i = 0;
        while (i < this._centre.height) {
            int j = 0;
            while (j < this._centre.width) {
                this._centre.pixels[i * this._centre.width + j] = cTemp.pixels[i];
                ++j;
            }
            ++i;
        }
        this.thumbMin = this._leftEnd.width;
        this.thumbMax = this._leftEnd.width + this._centre.width;
        this.setLimits(50.0f, 0.0f, 100.0f);
        this.localFont = globalFont;
        this.winApp.textFont(this.localFont);
        this.winApp.textAlign(3);
        this._calcControlWidthHeight();
        this._calcTickPositions();
        this.winApp.registerKeyEvent(this);
    }

    protected void _calcControlWidthHeight() {
        this.width = this._leftEnd.width + this._centre.width + this._rightEnd.width;
        this.height = this._centre.height + this._tickLength + this._tickOffset;
        if (this._renderMaxMinLabel) {
            this.height += this.localFont.getFont().getSize();
        }
    }

    protected void _calcTickPositions() {
        Point p = new Point();
        this.calcAbsPosition(p);
        float sliderRange = this.maxValue - this.minValue;
        float dTick = sliderRange / (float)this._numTicks;
        this._tickPositions = new int[this._numTicks + 1];
        this._tickValues = new float[this._numTicks + 1];
        int i = 0;
        while (i <= this._numTicks) {
            this._tickPositions[i] = Math.round(PApplet.map(this.minValue + (float)i * dTick, this.minValue, this.maxValue, this.thumbMin, this.thumbMax));
            this._tickValues[i] = this.minValue + (float)i * dTick;
            ++i;
        }
    }

    protected void _stickToTickByValue(float v) {
        float sliderRange = this.maxValue - this.minValue;
        float dTick = sliderRange / (float)this._numTicks;
        int index = Math.round(PApplet.constrain(v - this.minValue, 0.0f, sliderRange) / dTick);
        this._currTickStuck = PApplet.constrain(index, 0, this._numTicks);
        this.thumbTargetPos = this._tickPositions[this._currTickStuck];
        this.value = this.minValue + (float)this._currTickStuck * dTick;
    }

    protected void _stickToTickByPosition(float pos) {
        Point p = new Point();
        this.calcAbsPosition(p);
        float sliderRange = this.maxValue - this.minValue;
        float dTick = sliderRange / (float)this._numTicks;
        float v = PApplet.map(pos, this.thumbMin, this.thumbMax, this.minValue, this.maxValue);
        int index = Math.round((v - this.minValue) / dTick);
        this._currTickStuck = PApplet.constrain(index, 0, this._tickPositions.length - 1);
        this.thumbTargetPos = this._tickPositions[this._currTickStuck];
    }

    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        Point p = new Point();
        this.calcAbsPosition(p);
        float sliderRange = this.maxValue - this.minValue;
        if (this.isVisible() && sliderRange > 0.0f) {
            boolean isMouseOver = this.isOver(event.getX(), event.getY());
            switch (event.getID()) {
                case 501: {
                    if (!isMouseOver) break;
                    this.takeFocus();
                    if (this.isOverThumb(event.getX(), event.getY())) {
                        this._mousePressedOverThumb = true;
                        break;
                    }
                    this._mousePressedOverThumb = false;
                    break;
                }
                case 502: {
                    if (focusIsWith == this && isMouseOver || this._mousePressedOverThumb) {
                        if (this._stickToTicks) {
                            this._stickToTickByPosition(this.winApp.mouseX - p.x);
                        } else {
                            this.thumbTargetPos = PApplet.constrain(this.winApp.mouseX - p.x, this.thumbMin, this.thumbMax);
                        }
                        this._isMouseOverThumb = this.isOverThumb(event.getX(), event.getY());
                        this._mousePressedOverThumb = false;
                        this.eventType = 771;
                        this.fireEvent();
                        break;
                    }
                    this._isMouseOverThumb = false;
                    this._mousePressedOverThumb = false;
                    break;
                }
                case 506: {
                    if (focusIsWith != this || !this._mousePressedOverThumb) break;
                    this.thumbTargetPos = PApplet.constrain(this.winApp.mouseX - p.x, this.thumbMin, this.thumbMax);
                    this.isValueChanging = true;
                    break;
                }
                case 503: {
                    this._isMouseOverThumb = this.isOverThumb(event.getX(), event.getY());
                }
            }
        }
    }

    public void keyEvent(KeyEvent e) {
        if (e.getID() == 401 && this.hasFocus()) {
            if (e.getKeyCode() == 37) {
                if (this._stickToTicks) {
                    this._currTickStuck = PApplet.constrain(this._currTickStuck - 1, 0, this._tickPositions.length - 1);
                    this.thumbTargetPos = this._tickPositions[this._currTickStuck];
                } else {
                    this.thumbTargetPos = PApplet.constrain(this.thumbTargetPos - 1, this.thumbMin, this.thumbMax);
                }
            } else if (e.getKeyCode() == 39) {
                if (this._stickToTicks) {
                    this._currTickStuck = PApplet.constrain(this._currTickStuck + 1, 0, this._tickPositions.length - 1);
                    this.thumbTargetPos = this._tickPositions[this._currTickStuck];
                } else {
                    this.thumbTargetPos = PApplet.constrain(this.thumbTargetPos + 1, this.thumbMin, this.thumbMax);
                }
            }
        }
    }

    public boolean isOver(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        float val = (float)((double)this._centre.height * 0.5 - (double)this._thumb.height * 0.5);
        return ax >= p.x && ax <= p.x + this.width && (float)ay >= (float)p.y + val && (float)ay <= (float)(p.y + this.height) - val;
    }

    public boolean isOverThumb(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        Rectangle r = new Rectangle((int)((double)(p.x + this.thumbPos) - 0.5 * (double)this._thumb.width - 1.0), (int)((double)p.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb.height - 1.0), this._thumb.width + 1, this._thumb.height + 1);
        return r.contains(ax, ay);
    }

    public void setFont(String fontname, int fontsize) {
        this.localFont = GFont.getFont(this.winApp, fontname, fontsize);
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        String format = null;
        switch (this._valueType) {
            case 0: {
                format = "%d%s";
                break;
            }
            case 1: {
                format = "%." + this._precision + "f%s";
                break;
            }
            case 2: {
                format = "%." + this._precision + "E%s";
            }
        }
        Point p = new Point();
        this.calcAbsPosition(p);
        this.winApp.image(this._leftEnd, p.x, p.y);
        this.winApp.image(this._centre, p.x + this._leftEnd.width, p.y);
        this.winApp.image(this._rightEnd, p.x + this._leftEnd.width + this._centre.width, p.y);
        this.winApp.pushStyle();
        this.winApp.textFont(this.localFont);
        this.winApp.textAlign(3);
        float tickDist = (float)this._centre.width / (float)this._numTicks;
        this.winApp.stroke(this._tickColour);
        this.winApp.strokeWeight(1.0f);
        this.winApp.fill(this._fontColour);
        float tickYPos = p.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getFont().getSize();
        int i = 0;
        while (i < this._tickPositions.length) {
            Point pos;
            if (this._tickLabels != null) {
                pos = new Point(this._tickPositions[i], (int)tickYPos);
                this.winApp.text(this._tickLabels[i], (float)(p.x + pos.x), (float)pos.y);
            } else if (i == 0 && this._renderMaxMinLabel) {
                pos = new Point(p.x + this._leftEnd.width + Math.round((float)i * tickDist), p.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getFont().getSize());
                if (this._valueType == 0) {
                    this.winApp.text(String.format(format, Math.round(this.minValue), this.unit), (float)pos.x, (float)pos.y);
                } else {
                    this.winApp.text(String.format(format, Float.valueOf(this.minValue), this.unit), (float)pos.x, (float)pos.y);
                }
            } else if (i == this._numTicks && this._renderMaxMinLabel) {
                pos = new Point(p.x + this._leftEnd.width + Math.round((float)i * tickDist), p.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getFont().getSize());
                if (this._valueType == 0) {
                    this.winApp.text(String.format(format, Math.round(this.maxValue), this.unit), (float)pos.x, (float)pos.y);
                } else {
                    this.winApp.text(String.format(format, Float.valueOf(this.maxValue), this.unit), (float)pos.x, (float)pos.y);
                }
            }
            this.winApp.beginShape(4);
            this.winApp.vertex(p.x + this._tickPositions[i], p.y + this._centre.height + this._tickOffset);
            this.winApp.vertex(p.x + this._tickPositions[i], p.y + this._centre.height + this._tickOffset + this._tickLength);
            this.winApp.endShape();
            this.winApp.pushStyle();
            this.winApp.stroke(230);
            this.winApp.beginShape(4);
            this.winApp.vertex(p.x + this._tickPositions[i] + 1, p.y + this._centre.height + this._tickOffset);
            this.winApp.vertex(p.x + this._tickPositions[i] + 1, p.y + this._centre.height + this._tickOffset + this._tickLength);
            this.winApp.endShape();
            this.winApp.popStyle();
            if (!this._isMouseOverThumb) {
                this.winApp.image(this._thumb, (long)(p.x + this.thumbPos) - Math.round((double)this._thumb.width * 0.5) + 1L, (float)((double)p.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb.height));
            } else {
                this.winApp.image(this._thumb_mouseover, (long)(p.x + this.thumbPos) - Math.round((double)this._thumb_mouseover.width * 0.5) + 1L, (float)((double)p.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb_mouseover.height));
            }
            if (this._renderValueLabel) {
                if (this._valueType == 0) {
                    this.winApp.text(String.format(format, Math.round(this.value), this.unit), (float)(p.x + this.thumbPos), (float)p.y - (float)this._thumb.height * 0.5f + 0.5f * (float)this._centre.height - 4.0f);
                } else {
                    this.winApp.text(String.format(format, Float.valueOf(this.value), this.unit), (float)(p.x + this.thumbPos), (float)p.y - (float)this._thumb.height * 0.5f + 0.5f * (float)this._centre.height - 4.0f);
                }
            }
            ++i;
        }
        this.winApp.popStyle();
    }
}

