/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GClip;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public class GTextField
extends GComponent {
    private static int fontLeadPad = 2;
    private int cursorPos = 0;
    private int startSelect = -1;
    private int endSelect = -1;
    private int startX = 0;
    private int startY = 0;
    private int endY = 1;
    private int leading;
    private boolean drawSepLines = false;
    private boolean multiLine = false;

    public GTextField(PApplet theApplet, String text, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.multiLine = false;
        this.textFieldCtorCore(text, width, height);
    }

    public GTextField(PApplet theApplet, String text, int x, int y, int width, int height, boolean multiLine) {
        super(theApplet, x, y);
        this.multiLine = multiLine;
        this.textFieldCtorCore(text, width, height);
    }

    private void textFieldCtorCore(String text, int width, int height) {
        this.width = Math.max(width, this.textWidth + 8);
        this.height = Math.max(height, (int)(1.5f * (float)this.localFont.getFont().getSize()));
        this.border = 1;
        this.leading = (int)(1.2f * (float)this.localFont.getFont().getSize());
        this.endY = Math.max(1, (int)Math.floor(this.height / this.leading));
        this.setText(text);
        this.createEventHandler(this.winApp, "handleTextFieldEvents", new Class[]{GTextField.class});
        this.registerAutos_DMPK(true, true, false, true);
        this.winApp.textFont(this.localFont);
    }

    public void setFont(String fontname, int fontSize, int fontLeading) {
        this.localFont = GFont.getFont(this.winApp, fontname, fontSize);
        this.height = Math.max(this.height, (int)(1.5f * (float)this.localFont.getFont().getSize() + 0.5f));
        this.leading = Math.max(fontSize + fontLeadPad, fontLeading);
        this.endY = (int)Math.floor(this.height / fontLeading);
        this.setText(this.text);
    }

    public void setFont(String fontname, int fontsize) {
        this.setFont(fontname, fontsize, this.leading);
    }

    protected void loseFocus(GComponent toThis) {
        this.endSelect = -1;
        this.startSelect = -1;
        focusIsWith = null;
    }

    private void appendToRightOfCursor(char c) {
        this.appendToRightOfCursor("" + c);
    }

    private void appendToRightOfCursor(String s) {
        String t2;
        String t1;
        if (this.startSelect != this.endSelect) {
            int start = Math.min(this.startSelect, this.endSelect);
            int end = Math.max(this.startSelect, this.endSelect);
            t1 = this.text.substring(0, start);
            t2 = this.text.substring(end);
            this.endSelect = this.cursorPos = start;
            this.startSelect = this.cursorPos;
        } else {
            t1 = this.text.substring(0, this.cursorPos);
            t2 = this.text.substring(this.cursorPos);
        }
        this.text = String.valueOf(t1) + s + t2;
        this.cursorPos += s.length();
        this.startSelect = this.endSelect = this.cursorPos;
        this.eventType = 257;
        this.fireEvent();
    }

    protected void backspaceChar() {
        if (this.startSelect != this.endSelect) {
            this.deleteSubstring(this.startSelect, this.endSelect);
        } else if (this.cursorPos > 0) {
            this.deleteSubstring(this.cursorPos - 1, this.cursorPos);
        }
    }

    private void deleteChar() {
        if (this.startSelect != this.endSelect) {
            this.deleteSubstring(this.startSelect, this.endSelect);
        } else if (this.cursorPos < this.text.length()) {
            this.deleteSubstring(this.cursorPos, this.cursorPos + 1);
        }
    }

    private void deleteSubstring(int startString, int endString) {
        int start = Math.min(startString, endString);
        int end = Math.max(startString, endString);
        this.text = String.valueOf(this.text.substring(0, start)) + this.text.substring(end);
        this.endSelect = this.cursorPos = start;
        this.startSelect = this.cursorPos;
        this.eventType = 257;
        this.fireEvent();
    }

    private void copySubstring(int start, int end) {
        int s = Math.min(start, end);
        int e = Math.max(start, end);
        GClip.copy(this.text.substring(s, e));
    }

    private Point cursorPosition(int pos) {
        String preCursor = this.text.substring(0, pos);
        int cursorPosY = preCursor.length() - preCursor.replaceAll("\n", "").length();
        int cursorPosX = preCursor.length() - preCursor.lastIndexOf("\n") - 1;
        return new Point(cursorPosX, cursorPosY);
    }

    private Point cursorPixPosition(int pos) {
        String preCursor = this.text.substring(0, pos);
        String thisline = preCursor.substring(Math.max(preCursor.lastIndexOf("\n") + 1, 0), preCursor.length());
        int cursorPixX = (int)this.winApp.textWidth(thisline.substring(this.startX, thisline.length()));
        int cursorPixY = (preCursor.length() - preCursor.replaceAll("\n", "").length() - this.startY) * this.leading;
        return new Point(cursorPixX, cursorPixY);
    }

    private int cursorPos1D(Point c) {
        String[] splittext = this.text.split("\n");
        int sumLinesBefore = 0;
        int i = 0;
        while (i < c.y) {
            sumLinesBefore += splittext[i].length() + 1;
            ++i;
        }
        return sumLinesBefore + c.x;
    }

    private Point cursorPos2D(int x, int y) {
        x -= 4;
        int cursorY = (y -= 4) / this.leading + this.startY;
        String[] splittext = this.text.split("\n");
        if (cursorY >= splittext.length) {
            return this.cursorPosition(this.cursorPos);
        }
        if (cursorY < 0) {
            return new Point(0, 0);
        }
        float prev = 0.0f;
        int i = this.startX;
        while (i < splittext[cursorY].length()) {
            float cur = this.winApp.textWidth(splittext[cursorY].substring(this.startX, i));
            if (cur > (float)x) {
                if (cur - (float)x < (float)x - prev) {
                    return new Point(i, cursorY);
                }
                return new Point(Math.max(0, i - 1), cursorY);
            }
            prev = cur;
            ++i;
        }
        return new Point(splittext[cursorY].length(), cursorY);
    }

    public String viewText() {
        this.showCursor();
        String[] splittext = PApplet.split(this.text, "\n");
        String[] cuttext = new String[this.endY - this.startY];
        int i = this.startY;
        while (i < this.endY) {
            if (i < splittext.length) {
                float twidth = this.winApp.textWidth(splittext[i].substring(Math.min(this.startX, splittext[i].length())));
                int charWidth = splittext[i].length() - 1;
                while (twidth > (float)(this.width - 8)) {
                    float w = this.winApp.textWidth(splittext[i].substring(charWidth, charWidth + 1));
                    --charWidth;
                    twidth -= w;
                }
                cuttext[i - this.startY] = splittext[i].substring(Math.min(this.startX, splittext[i].length()), Math.min(++charWidth, splittext[i].length()));
            } else {
                cuttext[i - this.startY] = "";
            }
            ++i;
        }
        String jointext = PApplet.join(cuttext, "\n");
        return jointext;
    }

    private void showCursor() {
        if (focusIsWith == this) {
            while (this.cursorPosition((int)this.cursorPos).x < this.startX) {
                --this.startX;
            }
            while (this.cursorPixPosition((int)this.cursorPos).x > this.width - 8) {
                ++this.startX;
            }
            while (this.cursorPosition((int)this.cursorPos).y > this.endY - 1) {
                ++this.startY;
                ++this.endY;
            }
            while (this.cursorPosition((int)this.cursorPos).y < this.startY) {
                --this.startY;
                --this.endY;
            }
        }
    }

    public void setText(String newValue) {
        this.text = newValue;
        if (!this.multiLine) {
            this.text = this.stripEOLs(this.text, ' ');
        }
        this.endSelect = -1;
        this.startSelect = -1;
        this.cursorPos = 0;
        this.eventType = 259;
        this.fireEvent();
    }

    public void setShowLines(boolean drawlines) {
        this.drawSepLines = drawlines;
    }

    public boolean getShowLines() {
        return this.drawSepLines;
    }

    public boolean scroll(int dir) {
        boolean result = false;
        switch (dir) {
            case 273: {
                return this.scrollUp();
            }
            case 274: {
                return this.scrollDown();
            }
            case 275: {
                return this.scrollLeft();
            }
            case 276: {
                return this.scrollRight();
            }
        }
        return result;
    }

    private boolean scrollRight() {
        String[] splitText = PApplet.split(this.text, "\n");
        this.winApp.textFont(this.localFont);
        int i = this.startY;
        while (i < this.endY) {
            float tw;
            if (this.startX < splitText[i].length() && (tw = this.winApp.textWidth(splitText[i].substring(this.startX))) > (float)(this.width - 8)) {
                ++this.startX;
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean scrollLeft() {
        if (this.startX > 0) {
            --this.startX;
            return true;
        }
        return false;
    }

    private boolean scrollUp() {
        if (this.multiLine && this.startY > 0) {
            --this.startY;
            --this.endY;
            return true;
        }
        return false;
    }

    private boolean scrollDown() {
        int nbrLines;
        if (this.multiLine && this.endY <= (nbrLines = this.text.split("\n").length)) {
            ++this.startY;
            ++this.endY;
            return true;
        }
        return false;
    }

    public void mouseEvent(MouseEvent e) {
        if (!this.visible || !this.enabled) {
            return;
        }
        this.winApp.textFont(this.localFont);
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        switch (e.getID()) {
            case 501: {
                if (!this.isOver(this.winApp.mouseX, this.winApp.mouseY)) break;
                if (focusIsWith != this) {
                    this.takeFocus();
                }
                this.endSelect = this.cursorPos = this.cursorPos1D(this.cursorPos2D(e.getX() - p.x, e.getY() - p.y));
                this.startSelect = this.cursorPos;
                break;
            }
            case 502: {
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                this.endSelect = this.cursorPos = this.cursorPos1D(this.cursorPos2D(e.getX() - p.x, e.getY() - p.y));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyEvent(KeyEvent e) {
        boolean shiftDown;
        if (!this.enabled) {
            return;
        }
        if (focusIsWith != this) return;
        this.winApp.textFont(this.localFont);
        int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean bl = shiftDown = (e.getModifiersEx() & 0x40) == 64;
        if (e.getID() == 401) {
            if (e.getKeyCode() == 35) {
                if (shiftDown) {
                    this.cursorPos = this.text.indexOf("\n", this.cursorPos) != -1 ? this.text.indexOf("\n", this.cursorPos) : this.text.length();
                    this.endSelect = this.cursorPos;
                    return;
                } else {
                    this.cursorPos = this.text.indexOf("\n", this.cursorPos) != -1 ? this.text.indexOf("\n", this.cursorPos) : this.text.length();
                    this.startSelect = this.endSelect = this.cursorPos;
                }
                return;
            } else if (e.getKeyCode() == 36) {
                if (shiftDown) {
                    this.cursorPos = this.text.lastIndexOf("\n", this.cursorPos) != this.cursorPos ? this.text.lastIndexOf("\n", this.cursorPos) + 1 : this.text.lastIndexOf("\n", this.cursorPos - 1) + 1;
                    this.startSelect = this.cursorPos;
                    return;
                } else {
                    this.cursorPos = this.text.lastIndexOf("\n", this.cursorPos) != this.cursorPos ? this.text.lastIndexOf("\n", this.cursorPos) + 1 : this.text.lastIndexOf("\n", this.cursorPos - 1) + 1;
                    this.startSelect = this.endSelect = this.cursorPos;
                }
                return;
            } else if (e.getKeyCode() == 37) {
                if (shiftDown) {
                    if (this.cursorPos <= 0) return;
                    --this.cursorPos;
                    this.endSelect = this.cursorPos;
                    return;
                } else {
                    if (this.cursorPos > 0) {
                        --this.cursorPos;
                    }
                    this.startSelect = this.endSelect = this.cursorPos;
                }
                return;
            } else if (e.getKeyCode() == 39) {
                if (shiftDown) {
                    if (this.cursorPos >= this.text.length()) return;
                    ++this.cursorPos;
                    this.endSelect = this.cursorPos;
                    return;
                } else {
                    if (this.cursorPos < this.text.length()) {
                        ++this.cursorPos;
                    }
                    this.startSelect = this.endSelect = this.cursorPos;
                }
                return;
            } else if (this.multiLine && e.getKeyCode() == 38) {
                String[] splittext = this.text.split("\n");
                if (shiftDown) {
                    if (this.cursorPosition((int)this.cursorPos).y <= 0) return;
                    this.startSelect = this.cursorPos = this.cursorPos1D(new Point(Math.min(this.cursorPosition((int)this.cursorPos).x, splittext[this.cursorPosition((int)this.cursorPos).y - 1].length()), this.cursorPosition((int)this.cursorPos).y - 1));
                    return;
                } else {
                    if (this.cursorPosition((int)this.cursorPos).y > 0) {
                        this.cursorPos = this.cursorPos1D(new Point(Math.min(this.cursorPosition((int)this.cursorPos).x, splittext[this.cursorPosition((int)this.cursorPos).y - 1].length()), this.cursorPosition((int)this.cursorPos).y - 1));
                    }
                    this.startSelect = this.endSelect = this.cursorPos;
                }
                return;
            } else if (this.multiLine && e.getKeyCode() == 40) {
                String[] splittext = this.text.split("\n");
                if (shiftDown) {
                    if (this.cursorPosition((int)this.cursorPos).y >= splittext.length - 1) return;
                    this.endSelect = this.cursorPos = this.cursorPos1D(new Point(Math.min(this.cursorPosition((int)this.cursorPos).x, splittext[this.cursorPosition((int)this.cursorPos).y + 1].length()), this.cursorPosition((int)this.cursorPos).y + 1));
                    return;
                } else {
                    if (this.cursorPosition((int)this.cursorPos).y < splittext.length - 1) {
                        this.cursorPos = this.cursorPos1D(new Point(Math.min(this.cursorPosition((int)this.cursorPos).x, splittext[this.cursorPosition((int)this.cursorPos).y + 1].length()), this.cursorPosition((int)this.cursorPos).y + 1));
                    }
                    this.startSelect = this.endSelect = this.cursorPos;
                }
                return;
            } else if (e.getKeyCode() == 127) {
                this.deleteChar();
                return;
            } else if (e.getKeyCode() == 10) {
                if (this.multiLine) {
                    this.appendToRightOfCursor("\n");
                }
                this.eventType = 258;
                this.fireEvent();
                return;
            } else {
                if ((e.getModifiers() & shortcutMask) != shortcutMask) return;
                switch (e.getKeyCode()) {
                    case 67: {
                        if (this.startSelect == this.endSelect) return;
                        this.copySubstring(this.startSelect, this.endSelect);
                        return;
                    }
                    case 86: {
                        if (this.multiLine) {
                            this.appendToRightOfCursor(GClip.paste());
                            return;
                        }
                        this.appendToRightOfCursor(this.stripEOLs(GClip.paste(), ' '));
                        return;
                    }
                    case 88: {
                        if (this.startSelect == this.endSelect) return;
                        this.copySubstring(this.startSelect, this.endSelect);
                        this.deleteSubstring(this.startSelect, this.endSelect);
                        return;
                    }
                    case 65: {
                        this.startSelect = 0;
                        this.endSelect = this.text.length();
                    }
                    default: {
                        return;
                    }
                }
            }
        } else {
            if (e.getID() != 400 || (e.getModifiers() & shortcutMask) == shortcutMask) return;
            if (e.getKeyChar() == '\b') {
                this.backspaceChar();
                return;
            } else {
                if (e.getKeyChar() == '\uffff' || !GTextField.validUnicode(e.getKeyChar())) return;
                this.appendToRightOfCursor(e.getKeyChar());
            }
        }
    }

    public void draw() {
        int i;
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        this.winApp.textFont(this.localFont);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        if (this.border > 0) {
            this.winApp.strokeWeight(this.border);
            this.winApp.stroke(this.localColor.txfBorder);
        } else {
            this.winApp.noStroke();
        }
        this.winApp.fill(this.localColor.txfBack);
        this.winApp.rect(pos.x, pos.y, this.width, this.height);
        if (this.drawSepLines) {
            this.winApp.stroke(PApplet.blendColor(this.localColor.txfBorder, this.winApp.color(100), 2));
            this.winApp.strokeWeight(1.0f);
            i = 1;
            while (i <= this.endY - this.startY) {
                this.winApp.line(pos.x + 4, pos.y + i * this.leading, pos.x + this.width - 4, pos.y + i * this.leading);
                ++i;
            }
        }
        this.winApp.noStroke();
        if (this.startSelect != this.endSelect) {
            this.winApp.fill(this.localColor.txfSelBack);
            i = Math.min(this.startSelect, this.endSelect);
            while (i < Math.max(this.startSelect, this.endSelect)) {
                if (this.cursorPosition((int)i).x >= this.startX && this.cursorPixPosition((int)i).x < this.width - 8 && this.cursorPosition((int)i).y >= this.startY && this.cursorPosition((int)i).y < this.endY) {
                    this.winApp.rect(pos.x + 4 + this.cursorPixPosition((int)i).x, pos.y + 2 + this.cursorPixPosition((int)i).y, Math.min(this.winApp.textWidth(this.text.substring(i, i + 1)), (float)(this.width - 8 - this.cursorPixPosition((int)i).x)), this.localFont.getFont().getSize() + 2);
                }
                ++i;
            }
        }
        this.winApp.fill(this.localColor.txfFont);
        this.winApp.textLeading(this.leading);
        this.winApp.text(this.viewText(), (float)(pos.x + 4), (float)(pos.y + 1), (float)(this.width + 8), (float)(this.height - 2));
        if (focusIsWith == this && this.winApp.millis() % 1000 > 500) {
            Point cursorPix = this.cursorPixPosition(this.cursorPos);
            this.winApp.noFill();
            this.winApp.stroke(this.localColor.txfCursor);
            this.winApp.strokeWeight(2.0f);
            this.winApp.line(pos.x + 4 + cursorPix.x, pos.y + cursorPix.y + 2, pos.x + 4 + cursorPix.x, pos.y + cursorPix.y + this.localFont.getFont().getSize() + 2);
            this.winApp.fill(this.localColor.txfFont);
        }
        this.winApp.popStyle();
    }

    private String stripEOLs(String oldText, char replacement) {
        String newText = oldText.replace('\n', replacement);
        return newText;
    }

    private static boolean validUnicode(char b) {
        char c = b;
        return c >= ' ' && c <= '~' || c >= '\u00a1' && c <= '\u017f' || c == '\u018f' || c == '\u0192' || c >= '\u01a0' && c <= '\u01a1' || c >= '\u01af' && c <= '\u01b0' || c >= '\u01d0' && c <= '\u01dc' || c >= '\u01fa' && c <= '\u01ff' || c >= '\u0218' && c <= '\u021b' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02b0' && c <= '\u02e9' || c >= '\u0300' && c <= '\u0345' || c >= '\u0374' && c <= '\u0375' || c == '\u037a' || c == '\u037e' || c >= '\u0384' && c <= '\u038a' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c >= '\u03da' || c >= '\u03dc' || c >= '\u03de' || c >= '\u03e0' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0486' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c9' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05c4' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f4' || c >= '\u060c' || c >= '\u061b' || c >= '\u061f' || c >= '\u0621' && c <= '\u063a' || c >= '\u0640' && c <= '\u0655' || c >= '\u0660' && c <= '\u06ee' || c >= '\u06f0' && c <= '\u06fe' || c >= '\u0901' && c <= '\u0939' || c >= '\u093c' && c <= '\u094d' || c >= '\u0950' && c <= '\u0954' || c >= '\u0958' && c <= '\u0970' || c >= '\u0e01' && c <= '\u0e3a' || c >= '\u1e80' && c <= '\u1e85' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u2000' && c <= '\u202e' || c >= '\u2030' && c <= '\u2046' || c == '\u2070' || c >= '\u2074' && c <= '\u208e' || c == '\u2091' || c >= '\u20a0' && c <= '\u20ac' || c >= '\u2100' && c <= '\u2138' || c >= '\u2153' && c <= '\u2182' || c >= '\u2190' && c <= '\u21ea' || c >= '\u2190' && c <= '\u21ea' || c >= '\u2000' && c <= '\u22f1' || c == '\u2302' || c >= '\u2320' && c <= '\u2321' || c >= '\u2460' && c <= '\u2469' || c == '\u2500' || c == '\u2502' || c == '\u250c' || c == '\u2510' || c == '\u2514' || c == '\u2518' || c == '\u251c' || c == '\u2524' || c == '\u252c' || c == '\u2534' || c == '\u253c' || c >= '\u2550' && c <= '\u256c' || c == '\u2580' || c == '\u2584' || c == '\u2588' || c == '\u258c' || c >= '\u2590' && c <= '\u2593' || c == '\u25a0' || c >= '\u25aa' && c <= '\u25ac' || c == '\u25b2' || c == '\u25ba' || c == '\u25bc' || c == '\u25c4' || c == '\u25c6' || c >= '\u25ca' && c <= '\u25cc' || c == '\u25cf' || c >= '\u25d7' && c <= '\u25d9' || c == '\u25e6' || c == '\u2605' || c == '\u260e' || c == '\u261b' || c == '\u261e' || c >= '\u263a' && c <= '\u263c' || c == '\u2640' || c == '\u2642' || c == '\u2660' || c == '\u2663' || c == '\u2665' || c == '\u2666' || c == '\u266a' || c == '\u266b' || c >= '\u2701' && c <= '\u2709' || c >= '\u270c' && c <= '\u2727' || c >= '\u2729' && c <= '\u274b' || c == '\u274d' || c >= '\u274f' && c <= '\u2752' || c == '\u2756' || c >= '\u2758' && c <= '\u275e' || c >= '\u2761' && c <= '\u2767' || c >= '\u2776' && c <= '\u2794' || c >= '\u2798' && c <= '\u27be' || c >= '\uf001' && c <= '\uf002' || c >= '\uf021' && c <= '\uf0ff' || c >= '\uf601' && c <= '\uf605' || c >= '\uf610' && c <= '\uf616' || c >= '\uf800' && c <= '\uf807' || c >= '\uf80a' && c <= '\uf80b' || c >= '\uf80e' && c <= '\uf811' || c >= '\uf814' && c <= '\uf815' || c >= '\uf81f' && c <= '\uf820' || c >= '\uf81f' && c <= '\uf820' || c == '\uf833';
    }

    public String toString() {
        return "Cursor pos " + this.cursorPos + "   sX " + this.startX + "   sY " + this.startY + "   eY " + this.endY + "    startSelect " + this.startSelect + "     endSelect " + this.endSelect;
    }
}

