/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public abstract class GSlider
extends GComponent {
    public static final int INTEGER = 0;
    public static final int DECIMAL = 1;
    public static final int EXPONENT = 2;
    protected float init;
    protected float maxValue = 0.0f;
    protected float minValue = 100.0f;
    protected float value;
    protected int _valueType;
    protected int thumbMin;
    protected int thumbMax;
    protected int thumbPos;
    protected int thumbTargetPos;
    protected int thumbSize = 10;
    protected int thumbInertia = 1;
    protected int offset;
    protected boolean isValueChanging = false;

    public GSlider(PApplet theApplet, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.width = width;
        this.height = height;
        this.registerAutos_DMPK(true, true, true, false);
        this.createEventHandler(this.winApp, "handleSliderEvents", new Class[]{GSlider.class});
    }

    public void setLimits(int init, int min, int max) {
        this.minValue = Math.min(min, max);
        this.maxValue = Math.max(min, max);
        this.init = Math.round(PApplet.constrain((float)init, this.minValue, this.maxValue));
        if ((float)(this.thumbMax - this.thumbMin) < this.maxValue - this.minValue && G4P.messages) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".setLimits");
            System.out.println("  not all values in the range " + min + " - " + max + " can be returned");
            System.out.print("  either reduce the range or make the slider ");
            if (this.getClass().getSimpleName().equals("GHorzSlider")) {
                System.out.print("width");
            } else {
                System.out.print("height");
            }
            System.out.println(" at least " + (max - min + this.thumbSize));
        }
        this.thumbTargetPos = this.thumbPos;
        this.setValue(init, true);
    }

    public void setLimits(float init, float min, float max) {
        this.minValue = Math.min(min, max);
        this.maxValue = Math.max(min, max);
        this.init = PApplet.constrain(init, this.minValue, this.maxValue);
        this.thumbTargetPos = this.thumbPos;
        this.setValue(this.init, true);
    }

    public void pre() {
        int inertia = this.thumbInertia;
        if (this.thumbPos == this.thumbTargetPos) {
            this.isValueChanging = false;
        } else {
            int change;
            while ((change = (this.thumbTargetPos - this.thumbPos) / inertia) == 0 && --inertia > 0) {
            }
            if (change != 0) {
                this.thumbPos += change;
                float newValue = PApplet.map(this.thumbPos, this.thumbMin, this.thumbMax, this.minValue, this.maxValue);
                boolean valueChanged = newValue != this.value;
                this.value = newValue;
                if (valueChanged) {
                    this.eventType = 257;
                    this.fireEvent();
                }
            } else {
                this.isValueChanging = false;
            }
        }
    }

    public void draw() {
    }

    public void mouseEvent(MouseEvent event) {
    }

    public boolean isOver(int ax, int ay) {
        return false;
    }

    public int getMinValue() {
        return Math.round(this.minValue);
    }

    public int getMaxValue() {
        return Math.round(this.maxValue);
    }

    public int getValue() {
        return Math.round(this.value);
    }

    public float getValuef() {
        if (this._valueType == 0) {
            return Math.round(this.value);
        }
        return this.value;
    }

    public boolean isValueChanging() {
        return this.isValueChanging;
    }

    public void setValue(int newValue) {
        this.value = PApplet.constrain((float)newValue, this.minValue, this.maxValue);
        this.thumbTargetPos = (int)PApplet.map(this.value, this.minValue, this.maxValue, this.thumbMin, this.thumbMax);
    }

    public void setValue(float newValue) {
        this.value = PApplet.constrain(newValue, this.minValue, this.maxValue);
        this.thumbTargetPos = (int)PApplet.map(this.value, this.minValue, this.maxValue, this.thumbMin, this.thumbMax);
    }

    public void setValue(int newValue, boolean ignoreInteria) {
        this.setValue(newValue);
        if (ignoreInteria) {
            this.thumbPos = this.thumbTargetPos;
        }
    }

    public void setValue(float newValue, boolean ignoreInteria) {
        this.setValue(newValue);
        if (ignoreInteria) {
            this.thumbPos = this.thumbTargetPos;
        }
    }

    public void setInertia(int inertia) {
        this.thumbInertia = PApplet.constrain(inertia, 1, 100);
    }
}

