/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GImageButton
extends GComponent {
    public static final int OFF = 0;
    public static final int OVER = 1;
    public static final int DOWN = 2;
    protected static PImage[] noImage = null;
    protected int status;
    protected PImage[] bimage = new PImage[3];
    protected PImage mask;
    protected boolean reportAllButtonEvents = false;

    public GImageButton(PApplet theApplet, String maskFile, String imgFile, int nbrImages, int x, int y) {
        super(theApplet, x, y);
        this.mask = this.getMask(maskFile);
        this.bimage = this.getImages(imgFile, nbrImages);
        this.width = this.bimage[0].width;
        this.height = this.bimage[0].height;
        this.createEventHandler(this.winApp, "handleImageButtonEvents", new Class[]{GImageButton.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    public GImageButton(PApplet theApplet, String maskFile, String[] imgFiles, int x, int y) {
        super(theApplet, x, y);
        this.mask = this.getMask(maskFile);
        this.bimage = this.getImages(imgFiles);
        this.width = this.bimage[0].width;
        this.height = this.bimage[0].height;
        this.createEventHandler(this.winApp, "handleImageButtonEvents", new Class[]{GImageButton.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    protected PImage[] getImages(String imgFile, int nbrImages) {
        nbrImages = PApplet.constrain(nbrImages, 1, 3);
        PImage[] imgs = new PImage[3];
        PImage img = this.winApp.loadImage(imgFile);
        if (imgFile == null || img == null) {
            this.missingFile(imgFile);
            imgs = this.getErrorImage();
        } else {
            int iw = img.width / nbrImages;
            int i = 0;
            while (i < nbrImages) {
                imgs[i] = new PImage(iw, img.height, 2);
                imgs[i].copy(img, i * iw, 0, iw, img.height, 0, 0, iw, img.height);
                ++i;
            }
            i = nbrImages;
            while (i < 3) {
                imgs[i] = imgs[nbrImages - 1];
                ++i;
            }
        }
        return imgs;
    }

    protected PImage[] getImages(String[] imgFiles) {
        PImage[] imgs = new PImage[3];
        int imgCount = 0;
        if (imgFiles == null || imgFiles.length < 1) {
            if (G4P.messages) {
                System.out.println("Error: you have not provided a list of image files for GImageButton");
            }
        } else {
            imgCount = 0;
            while (imgCount < imgFiles.length) {
                imgs[imgCount] = this.winApp.loadImage(imgFiles[imgCount]);
                if (imgs[imgCount] == null) {
                    this.missingFile(imgFiles[imgCount]);
                }
                ++imgCount;
            }
            int j = imgCount;
            while (j < 3) {
                imgs[j] = imgs[j - 1];
                ++j;
            }
        }
        if (imgs[0] == null) {
            imgs = this.getErrorImage();
        }
        return imgs;
    }

    protected PImage getMask(String mfile) {
        PImage img = null;
        if (mfile != null && (img = this.winApp.loadImage(mfile)) == null) {
            this.missingFile(mfile);
        }
        return img;
    }

    protected void missingFile(String fname) {
        if (G4P.messages) {
            System.out.println("\nUnable to locate file '" + fname + "' for GImageButton");
        }
    }

    protected PImage[] getErrorImage() {
        if (noImage == null) {
            noImage = this.getImages("noimage3.png", 3);
        }
        return noImage;
    }

    public boolean isOver(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        if (ax >= p.x && ax <= p.x + this.width && ay >= p.y && ay <= p.y + this.height) {
            int pixel;
            int dx = ax - p.x;
            int dy = ay - p.y;
            if (this.mask != null ? (pixel = this.mask.get(dx, dy) & 0xFFFFFF) == 0xFFFFFF : this.winApp.alpha(pixel = this.bimage[0].get(dx, dy)) != 0.0f) {
                return true;
            }
        }
        return false;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.imageMode(0);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        if (this.bimage[this.status] != null) {
            this.winApp.image(this.bimage[this.status], pos.x, pos.y);
        }
        this.winApp.popStyle();
    }

    public void fireAllEvents(boolean all) {
        this.reportAllButtonEvents = all;
    }

    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.status = 2;
                this.takeFocus();
                this.eventType = 770;
                if (!this.reportAllButtonEvents) break;
                this.fireEvent();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.loseFocus(null);
                this.eventType = 769;
                this.fireEvent();
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                if (this.isOver(this.winApp.mouseX, this.winApp.mouseY)) {
                    this.eventType = 769;
                    this.fireEvent();
                } else if (this.reportAllButtonEvents) {
                    this.eventType = 771;
                    this.fireEvent();
                }
                this.status = 0;
                break;
            }
            case 503: {
                this.status = this.isOver(this.winApp.mouseX, this.winApp.mouseY) ? 1 : 0;
            }
        }
    }
}

