/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GSlider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public class GHorzSlider
extends GSlider {
    public GHorzSlider(PApplet theApplet, int x, int y, int width, int height) {
        super(theApplet, x, y, width, height);
        this.initThumbDetails();
    }

    protected void initThumbDetails() {
        this.thumbSize = Math.max(20, this.width / 20);
        this.thumbMin = this.thumbSize / 2;
        this.thumbMax = this.width - this.thumbSize / 2;
        this.thumbTargetPos = this.thumbPos;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.sdrTrack);
        this.winApp.rect(pos.x, pos.y, this.width, this.height);
        this.winApp.fill(this.localColor.sdrThumb);
        this.winApp.rect(pos.x + this.thumbPos - this.thumbSize / 2, pos.y, this.thumbSize, this.height);
        if (this.border != 0) {
            this.winApp.strokeWeight(this.border);
            this.winApp.noFill();
            this.winApp.stroke(this.localColor.sdrBorder);
            this.winApp.rect(pos.x, pos.y, this.width, this.height);
        }
        this.winApp.popStyle();
    }

    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.takeFocus();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                this.isValueChanging = true;
                Point p = new Point(0, 0);
                this.calcAbsPosition(p);
                this.thumbTargetPos = PApplet.constrain(this.winApp.mouseX - this.offset - p.x, this.thumbMin, this.thumbMax);
            }
        }
    }

    public boolean isOver(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        if (ax >= p.x + this.thumbPos - this.thumbSize / 2 && ax <= p.x + this.thumbPos + this.thumbSize / 2 && ay >= p.y && ay <= p.y + this.height) {
            this.offset = ax - (p.x + this.thumbPos);
            return true;
        }
        return false;
    }
}

