/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GFont;
import guicomponents.GOption;
import guicomponents.GOptionGroup;
import guicomponents.GVertSlider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import processing.core.PApplet;
import processing.core.PImage;

public class GCombo
extends GComponent {
    protected static PImage imgArrow;
    protected int startRow;
    protected int maxRows = 5;
    protected int nbrRowsToShow;
    protected GOptionGroup optGroup;
    protected GVertSlider slider;
    protected boolean expanded = false;

    public GCombo(PApplet theApplet, String[] options, int maxRows, int x, int y, int width) {
        super(theApplet, x, y);
        this.maxRows = PApplet.constrain(maxRows, 1, 25);
        this.comboCtorCore(width);
        this.createOptions(options);
        this.createSlider();
    }

    private void comboCtorCore(int width) {
        this.children = new HashSet();
        if (imgArrow == null) {
            imgArrow = this.winApp.loadImage("combo0.png");
        }
        this.width = width;
        this.height = Math.max(this.localFont.getFont().getSize() + 4, GCombo.imgArrow.height);
        this.opaque = true;
        this.border = 1;
        this.createEventHandler(this.winApp, "handleComboEvents", new Class[]{GCombo.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    private void createSlider() {
        this.slider = new GVertSlider(this.winApp, this.width - 10, this.height, 10, this.maxRows * this.height);
        this.slider.setBorder(1);
        this.slider.setVisible(false);
        this.slider.setLimits(0, 0, this.maxRows - 1);
        this.slider.addEventHandler(this, "processSliderMotion", new Class[]{GVertSlider.class});
        this.add(this.slider);
    }

    private void createOptions(String[] optTexts) {
        this.optGroup = new GOptionGroup();
        int i = 0;
        while (i < optTexts.length) {
            GOption option = this.makeOption(optTexts[i]);
            if (option != null) {
                this.optGroup.addOption(option);
                this.add(option);
            }
            ++i;
        }
        this.optGroup.setSelected(0);
        this.text = this.optGroup.selectedText();
        this.nbrRowsToShow = Math.min(optTexts.length, this.maxRows);
    }

    public GOption makeOption(String optText) {
        GOption opt = null;
        if (optText != null && !optText.equals("")) {
            opt = new GOption(this.winApp, optText, 0, 0, this.width - 10);
            opt.addEventHandler(this, "processOptionSelection");
            opt.setVisible(false);
            opt.setOpaque(true);
            opt.setBorder(0);
        }
        return opt;
    }

    public void setFont(String fontname, int fontsize) {
        int tw = this.textWidth;
        int fs = this.localFont.getFont().getSize();
        this.localFont = GFont.getFont(this.winApp, fontname, fontsize);
        if (fontsize > fs) {
            this.height += fontsize - fs;
        }
        this.setText(this.text);
        if (this.textWidth > tw) {
            this.width += this.textWidth - tw;
        }
        ArrayList<GOption> options = this.optGroup.getOptions();
        int i = 0;
        while (i < options.size()) {
            options.get(i).setWidth(this.width - 10);
            ++i;
        }
        this.slider.setX(this.width - 10);
    }

    public void setColorScheme(int schemeNo) {
        this.localColor = GCScheme.getColor(this.winApp, schemeNo);
        this.slider.localColor = GCScheme.getColor(this.winApp, schemeNo);
        ArrayList<GOption> options = this.optGroup.getOptions();
        int i = 0;
        while (i < options.size()) {
            options.get((int)i).localColor = GCScheme.getColor(this.winApp, schemeNo);
            ++i;
        }
    }

    public void processSliderMotion(GVertSlider vertslider) {
        this.startRow = this.slider.getValue();
    }

    public void processOptionSelection(GOption sOpt, GOption dOpt) {
        this.text = this.optGroup.selectedText();
        if (sOpt != dOpt) {
            this.fireEvent();
        }
        this.shrink();
        this.loseFocus(null);
    }

    public void setSelected(int index) {
        this.optGroup.setSelected(index);
        this.setText(this.optGroup.selectedText());
    }

    public void setSelected(String optText) {
        this.optGroup.setSelected(optText);
        this.setText(this.optGroup.selectedText());
    }

    public boolean addOption(String optText) {
        GOption option = this.makeOption(optText);
        boolean ok = this.optGroup.addOption(option);
        if (ok) {
            this.add(option);
        }
        return ok;
    }

    public boolean addOption(int pos, String optText) {
        GOption option = this.makeOption(optText);
        boolean ok = this.optGroup.addOption(pos, option);
        if (ok) {
            this.add(option);
        }
        return ok;
    }

    public void removeOption(int index) {
        GOption option = this.optGroup.removeOption(index);
        if (option != null) {
            this.remove(option);
        }
    }

    public void removeOption(String optText) {
        GOption option = this.optGroup.removeOption(optText);
        if (option != null) {
            this.remove(option);
        }
    }

    public boolean isOver(int ax, int ay) {
        int y2;
        int x2;
        int y1;
        int x1;
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        if (this.expanded) {
            x1 = p.x;
            y1 = p.y;
            x2 = x1 + this.width;
            y2 = y1 + (this.nbrRowsToShow + 1) * this.height;
        } else {
            x1 = p.x + this.width - GCombo.imgArrow.width - 4;
            y1 = p.y + (this.height - GCombo.imgArrow.height) / 2 + 2;
            x2 = x1 + GCombo.imgArrow.width;
            y2 = y1 + GCombo.imgArrow.height;
        }
        return ax >= x1 && ax <= x2 && ay >= y1 && ay <= y2;
    }

    public void shrink() {
        this.expanded = false;
        int i = 0;
        while (i < this.optGroup.size()) {
            this.optGroup.get((int)i).visible = false;
            ++i;
        }
        this.slider.visible = false;
    }

    public void expand() {
        this.expanded = true;
        this.startRow = 0;
        this.slider.setLimits(0, 0, this.optGroup.size() - this.maxRows);
        this.takeFocus();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void loseFocus(GComponent grabber) {
        if (!this.children.contains(grabber)) {
            this.shrink();
            focusIsWith = null;
        }
    }

    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith != this && mouseOver) {
                    this.takeFocus();
                    break;
                }
                if (focusIsWith != this || this.isOver(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                break;
            }
            case 500: {
                if (focusIsWith != this || !this.isOver(this.winApp.mouseX, this.winApp.mouseY)) break;
                if (this.expanded) {
                    this.shrink();
                } else {
                    this.expand();
                }
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
            }
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        if (this.border == 0) {
            this.winApp.noStroke();
        } else {
            this.winApp.strokeWeight(this.border);
            this.winApp.stroke(this.localColor.txfBorder);
        }
        if (this.opaque) {
            this.winApp.fill(this.localColor.txfBack);
        } else {
            this.winApp.noFill();
        }
        this.winApp.rect(pos.x, pos.y, this.width, this.height);
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.txfFont);
        this.winApp.textFont(this.localFont, this.localFont.getFont().getSize());
        this.winApp.text(this.text, (float)(pos.x + 4), (float)(pos.y - 2 + (this.height - this.localFont.getFont().getSize()) / 2), (float)(this.width - 16), (float)this.height);
        this.winApp.fill(this.winApp.color(255, 255));
        this.winApp.image(imgArrow, pos.x + this.width - GCombo.imgArrow.width - 1, pos.y + (this.height - GCombo.imgArrow.height) / 2);
        if (this.expanded) {
            this.winApp.noStroke();
            this.winApp.fill(this.localColor.txfBack);
            this.winApp.rect(pos.x, pos.y + this.height, this.width, this.nbrRowsToShow * this.height);
            int i = 0;
            while (i < this.optGroup.size()) {
                GOption opt = this.optGroup.get(i);
                if (i >= this.startRow && i < this.startRow + this.nbrRowsToShow) {
                    opt.visible = true;
                    opt.y = this.height * (i - this.startRow + 1);
                    opt.draw();
                } else {
                    opt.visible = false;
                }
                ++i;
            }
            if (this.border != 0) {
                this.winApp.strokeWeight(this.border);
                this.winApp.stroke(this.localColor.txfBorder);
                this.winApp.noFill();
                this.winApp.rect(pos.x, pos.y + this.height, this.width, this.nbrRowsToShow * this.height);
            }
            if (this.optGroup.size() > this.maxRows) {
                this.slider.setVisible(true);
                this.slider.draw();
            }
        }
        this.winApp.popStyle();
    }

    public int selectedIndex() {
        return this.optGroup.selectedIndex();
    }

    public String selectedText() {
        return this.optGroup.selectedText();
    }

    public int deselectedIndex() {
        return this.optGroup.deselectedIndex();
    }

    public String deselectedText() {
        return this.optGroup.deselectedText();
    }
}

