/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GButton
extends GComponent {
    public static final int OFF = 0;
    public static final int OVER = 1;
    public static final int DOWN = 2;
    protected int status;
    protected PImage[] bimage = new PImage[3];
    protected int btnImgWidth = 0;
    protected int imageAlign = 4;
    protected boolean useImages = false;
    protected boolean reportAllButtonEvents = false;
    protected int imgAlignX;

    public GButton(PApplet theApplet, String text, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.setText(text);
        this.buttonCtorCore(width, height);
    }

    public GButton(PApplet theApplet, String imgFile, int nbrImages, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.setImages(imgFile, nbrImages);
        this.btnImgWidth = this.getMaxButtonImageWidth();
        this.buttonCtorCore(width, height);
    }

    public GButton(PApplet theApplet, String text, String imgFile, int nbrImages, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.setImages(imgFile, nbrImages);
        this.btnImgWidth = this.getMaxButtonImageWidth();
        this.setText(text);
        this.buttonCtorCore(width, height);
    }

    private void buttonCtorCore(int width, int height) {
        this.width = Math.max(width, this.textWidth + 8);
        this.height = Math.max(height, this.localFont.getFont().getSize() + 4);
        this.border = 1;
        this.setImageAlign(this.imageAlign);
        this.textAlignHorz = 4;
        this.textAlignVert = 64;
        this.calcAlignX();
        this.calcAlignY();
        this.createEventHandler(this.winApp, "handleButtonEvents", new Class[]{GButton.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    public void setColours(int normal, int mouseOver, int pressed) {
        this.localColor.btnOff = normal;
        this.localColor.btnOver = mouseOver;
        this.localColor.btnDown = pressed;
    }

    protected int getMaxButtonImageWidth() {
        int bw = 0;
        int i = 0;
        while (i < 3) {
            bw = Math.max(bw, this.bimage[i] == null ? 0 : this.bimage[i].width);
            ++i;
        }
        this.useImages = bw > 0;
        return bw;
    }

    protected int getMaxButtonImageHeight() {
        int bh = 0;
        int i = 0;
        while (i < 3) {
            bh = Math.max(bh, this.bimage[i] == null ? 0 : this.bimage[i].height);
            ++i;
        }
        return bh;
    }

    public void setImages(String ifileNormal, String ifileOver, String ifilePressed) {
        this.bimage[0] = this.winApp.loadImage(ifileNormal);
        if (this.bimage[0] == null && G4P.messages) {
            System.out.println("Can't find normal button image file");
        }
        this.bimage[1] = this.winApp.loadImage(ifileOver);
        if (this.bimage[1] == null && G4P.messages) {
            System.out.println("Can't find over button image file");
        }
        this.bimage[2] = this.winApp.loadImage(ifilePressed);
        if (this.bimage[2] == null && G4P.messages) {
            System.out.println("Can't find pressed button image file");
        }
        this.getMaxButtonImageWidth();
        if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
            this.imageAlign = 1;
        }
    }

    public void setImages(String[] imgFiles) {
        if (imgFiles != null && imgFiles.length > 1) {
            this.setImages(imgFiles[0], imgFiles[1 % imgFiles.length], imgFiles[2 % imgFiles.length]);
            this.getMaxButtonImageWidth();
            if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
                this.imageAlign = 1;
            }
        }
    }

    public void setImages(String imgFile, int nbrImages) {
        nbrImages = PApplet.constrain(nbrImages, 1, 3);
        if (imgFile != null && nbrImages > 0) {
            PImage img = this.winApp.loadImage(imgFile);
            if (img == null) {
                if (G4P.messages) {
                    System.out.println("Can't find button image file");
                }
            } else {
                this.setImages(img, nbrImages);
            }
            this.getMaxButtonImageWidth();
            if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
                this.imageAlign = 1;
            }
        }
    }

    public void setImages(PImage imgNormal, PImage imgOver, PImage imgPressed) {
        this.bimage[0] = imgNormal;
        this.bimage[1] = imgOver;
        this.bimage[2] = imgPressed;
        this.getMaxButtonImageWidth();
        if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
            this.imageAlign = 1;
        }
    }

    public void setImages(PImage[] images) {
        if (images != null) {
            int i = 0;
            while (i < images.length) {
                this.bimage[i] = images[i];
                ++i;
            }
            i = images.length;
            while (i < 3) {
                this.bimage[i] = this.bimage[images.length - 1];
                ++i;
            }
            this.getMaxButtonImageWidth();
            if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
                this.imageAlign = 1;
            }
        }
    }

    public void setImages(PImage img, int nbrImages) {
        if (img != null && nbrImages > 0) {
            int iw = img.width / nbrImages;
            int i = 0;
            while (i < nbrImages) {
                this.bimage[i] = new PImage(iw, img.height, 2);
                this.bimage[i].copy(img, i * iw, 0, iw, img.height, 0, 0, iw, img.height);
                ++i;
            }
            i = nbrImages;
            while (i < 3) {
                this.bimage[i] = this.bimage[nbrImages - 1];
                ++i;
            }
            this.getMaxButtonImageWidth();
            if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
                this.imageAlign = 1;
            }
        }
    }

    public void setColorScheme(int schemeNo) {
        this.localColor = GCScheme.getColor(this.winApp, schemeNo);
    }

    public void setText(String text) {
        if (text != null && text != "") {
            if (this.useImages && this.imageAlign == 4) {
                this.setImageAlign(1);
            }
            this.text = text;
            this.winApp.textFont(this.localFont, this.localFont.getFont().getSize());
            this.textWidth = Math.round(this.winApp.textWidth(text));
            this.calcAlignX();
            this.calcAlignY();
        }
    }

    public void setFont(String fontname, int fontsize) {
        this.setFont(fontname, fontsize, true);
    }

    public void setFont(String fontname, int fontsize, boolean resize) {
        int tw = this.textWidth;
        int fs = this.localFont.getFont().getSize();
        this.localFont = GFont.getFont(this.winApp, fontname, fontsize);
        if (resize) {
            if (fontsize > fs) {
                this.height += fontsize - fs;
            }
            this.setText(this.text);
            if (this.textWidth > tw) {
                this.width += this.textWidth - tw;
            }
        }
        this.calcAlignX();
        this.calcAlignY();
    }

    public void setImageAlign(int imgAlign) {
        if (this.useImages) {
            switch (imgAlign) {
                case 1: {
                    this.imageAlign = imgAlign;
                    this.imgAlignX = 4;
                    break;
                }
                case 2: {
                    this.imageAlign = imgAlign;
                    this.imgAlignX = this.width - this.btnImgWidth - 4;
                    break;
                }
                case 4: {
                    if (this.text.length() == 0) {
                        this.imageAlign = imgAlign;
                        this.imgAlignX = (this.width - this.btnImgWidth) / 2;
                        break;
                    }
                    this.imageAlign = 1;
                    this.imgAlignX = 4;
                }
            }
        }
        this.calcAlignX();
    }

    protected void calcAlignX() {
        int areaWidth = this.width;
        int imgX = 0;
        if (this.useImages) {
            areaWidth -= this.btnImgWidth;
            if (this.imageAlign == 1) {
                imgX = this.btnImgWidth;
            }
        }
        switch (this.textAlignHorz) {
            case 1: {
                this.alignX = imgX + this.border + 4;
                break;
            }
            case 2: {
                this.alignX = imgX + areaWidth - this.textWidth - this.border - 4;
                break;
            }
            case 4: {
                this.alignX = imgX + this.border + 4 + (areaWidth - this.textWidth) / 2;
            }
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        if (this.border == 0) {
            this.winApp.strokeWeight(0.0f);
            this.winApp.noStroke();
        } else {
            this.winApp.strokeWeight(this.border);
            this.winApp.stroke(this.localColor.btnBorder);
        }
        switch (this.status) {
            case 0: {
                this.winApp.fill(this.localColor.btnOff);
                break;
            }
            case 1: {
                this.winApp.fill(this.localColor.btnOver);
                break;
            }
            case 2: {
                this.winApp.fill(this.localColor.btnDown);
            }
        }
        this.winApp.rect(pos.x, pos.y, this.width, this.height);
        if (this.bimage[this.status] != null && this.useImages) {
            this.winApp.image(this.bimage[this.status], pos.x + this.imgAlignX, pos.y + (this.height - this.bimage[this.status].height) / 2);
        }
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.btnFont);
        this.winApp.textFont(this.localFont, this.localFont.getFont().getSize());
        this.winApp.text(this.text, (float)(pos.x + this.alignX), (float)(pos.y + this.alignY), (float)this.width, (float)this.height);
        this.winApp.popStyle();
    }

    public void fireAllEvents(boolean all) {
        this.reportAllButtonEvents = all;
    }

    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.status = 2;
                this.takeFocus();
                this.eventType = 770;
                if (!this.reportAllButtonEvents) break;
                this.fireEvent();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.loseFocus(null);
                this.eventType = 769;
                this.fireEvent();
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                if (this.isOver(this.winApp.mouseX, this.winApp.mouseY)) {
                    this.eventType = 769;
                    this.fireEvent();
                } else if (this.reportAllButtonEvents) {
                    this.eventType = 771;
                    this.fireEvent();
                }
                this.status = 0;
                break;
            }
            case 503: {
                this.status = this.isOver(this.winApp.mouseX, this.winApp.mouseY) ? 1 : 0;
            }
        }
    }
}

