/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GConstants;
import guicomponents.GCursorImageChanger;
import guicomponents.GFont;
import guicomponents.GMessenger;
import guicomponents.GWindow;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PStyle;

public class G4P
implements PConstants,
GConstants {
    private static HashSet<GComponent> allComponents = new HashSet();
    private static HashSet<GWindow> allWinApps = new HashSet();
    private static HashSet<PApplet> autoDrawDisabled = new HashSet();
    public static PApplet mainWinApp = null;
    public static PStyle g4pStyle = null;
    public static boolean messages = true;
    private static GCursorImageChanger mcd = new GCursorImageChanger();
    public static boolean overControl = false;
    public static boolean cursorChangeEnabled = false;
    public static int mouseOff = 0;
    public static int mouseOver = 12;
    private static final int PCAM_AVAILABLE = 0;
    private static final int PCAM_UNAVAILABLE = 1;
    private static final int PCAM_UNINITIALISED = 2;
    private static Object peasyCam;
    private static Method beginHud;
    private static Method endHud;
    private static int camStatus;

    static {
        camStatus = 2;
    }

    public static void setMouseOverEnabled(boolean enable) {
        cursorChangeEnabled = enable;
        if (!cursorChangeEnabled) {
            mainWinApp.cursor(mouseOff);
            Iterator<GWindow> iter = allWinApps.iterator();
            while (iter.hasNext()) {
                iter.next().papplet.cursor(mouseOff);
            }
        }
    }

    public static void cursor(int cursorOff, int cursorOver) {
        mouseOff = cursorOff;
        mouseOver = cursorOver;
    }

    public static void cursor(int cursorOver) {
        mouseOver = cursorOver;
    }

    public static void addComponent(GComponent c) {
        if (g4pStyle == null) {
            G4P.getStyle();
        }
        if (allComponents.contains(c)) {
            GMessenger.message(65793, c, null);
        } else {
            allComponents.add(c);
        }
    }

    public static void setMainApp(PApplet theApplet) {
        if (mainWinApp == null) {
            mainWinApp = theApplet;
            mainWinApp.registerPost(mcd);
        }
    }

    public static void addWindow(GWindow window) {
        allWinApps.add(window);
    }

    public static void removeWindow(GWindow window) {
        allWinApps.remove(window);
    }

    public static boolean isWindowActive(GWindow window) {
        return allWinApps.contains(window);
    }

    private static void getStyle() {
        PGraphics temp = new PGraphics();
        g4pStyle = temp.getStyle();
        G4P.g4pStyle.rectMode = 0;
        G4P.g4pStyle.ellipseMode = 3;
        G4P.g4pStyle.imageMode = 0;
        G4P.g4pStyle.shapeMode = 0;
        G4P.g4pStyle.colorMode = 1;
        G4P.g4pStyle.colorModeA = 255.0f;
        G4P.g4pStyle.colorModeX = 255.0f;
        G4P.g4pStyle.colorModeY = 255.0f;
        G4P.g4pStyle.colorModeZ = 255.0f;
    }

    public static void setTextMode(int mode) {
        if (mode == 4 || mode == 256 || mode == 5) {
            if (g4pStyle == null) {
                PGraphics temp = new PGraphics();
                g4pStyle = temp.getStyle();
            }
            G4P.g4pStyle.textMode = mode;
        }
    }

    public static void setColorScheme(PApplet theApplet, int schemeNo) {
        if (theApplet != null) {
            G4P.setMainApp(theApplet);
        } else if (mainWinApp == null) {
            return;
        }
        GComponent.globalColor = GCScheme.getColor(mainWinApp, schemeNo);
    }

    public static void setFont(PApplet theApplet, String fontName, int fontSize) {
        if (theApplet != null) {
            G4P.setMainApp(theApplet);
        } else if (mainWinApp == null) {
            return;
        }
        GComponent.globalFont = GFont.getFont(mainWinApp, fontName, fontSize);
    }

    public static boolean setPeasyCam(Object pcam) {
        camStatus = 1;
        if (!pcam.getClass().getSimpleName().equals("PeasyCam")) {
            GMessenger.message(-2113929215, pcam, null);
            return false;
        }
        try {
            beginHud = pcam.getClass().getMethod("beginHUD", null);
            endHud = pcam.getClass().getMethod("endHUD", null);
            peasyCam = pcam;
            camStatus = 0;
            return true;
        }
        catch (Exception excp) {
            GMessenger.message(-2113929214, null, null);
            camStatus = 1;
            return false;
        }
    }

    public static void draw() {
        if (camStatus != 0) {
            G4P.draw(mainWinApp);
        } else {
            try {
                beginHud.invoke(peasyCam, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            G4P.draw(mainWinApp);
            try {
                endHud.invoke(peasyCam, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void draw(PApplet app) {
        if (allComponents.size() > 0) {
            if (!autoDrawDisabled.contains(app)) {
                G4P.unregisterFromPAppletDraw(app);
            }
            app.hint(4);
            for (GComponent c : allComponents) {
                if (c.getParent() != null || c.getPApplet() != app) continue;
                c.draw();
            }
            app.hint(-4);
        }
    }

    private static void unregisterFromPAppletDraw(PApplet app) {
        for (GComponent c : allComponents) {
            if (c.getParent() != null || c.getPApplet() != app) continue;
            c.regDraw = false;
            c.getPApplet().unregisterDraw(c);
        }
        autoDrawDisabled.add(app);
    }

    public static void disableAutoDraw() {
        G4P.unregisterFromPAppletDraw(mainWinApp);
        GMessenger.message(65795, null, null);
    }

    public static boolean isAutoDrawOn() {
        return G4P.isAutoDrawOn(mainWinApp);
    }

    public static boolean isAutoDrawOn(PApplet app) {
        return !autoDrawDisabled.contains(app);
    }

    public static void messagesEnabled(boolean enable) {
        messages = enable;
    }
}

