/*
 * Decompiled with CFR 0.152.
 */
package gui;

import processing.core.PApplet;
import processing.core.PShape;

public class StartAnimation {
    private PApplet parent;
    private PShape loadingSymbol;
    private float SCALESTEPS = 0.8f;
    private float ROTATIONSTEPS = 0.05f;
    private float CANVAS_STRUCTURE_LIGHT = 20.0f;
    private float CANVAS_STRUCTURE_DARK = 40.0f;
    private long TIME_SPAN_FOR_NOTEDETECTION = 4000L;
    private int scale0 = 55;
    private int scale1 = 40;
    private int scale2 = 25;
    private int scale3 = 10;
    private float scale = 70.0f;
    private boolean direction = false;
    private boolean firstBeatGotPlayed = false;
    private long trynoteDetection;
    private boolean ready = false;

    public StartAnimation(PApplet parent) {
        this.parent = parent;
        this.loadingSymbol = parent.loadShape("gui/StartAnimation.svg");
    }

    public void setAnimStage(int stage) {
        if (!this.ready) {
            this.parent.background(255);
            this.parent.smooth();
            this.setScale(stage);
            this.loadingSymbol.rotate(this.ROTATIONSTEPS);
            if (this.scale != 0.0f) {
                this.parent.shape(this.loadingSymbol, this.parent.width / 2, this.parent.height / 2, this.scale, this.scale);
            }
        }
    }

    private void setScale(int stage) {
        int currentStage = stage;
        if (this.firstBeatGotPlayed && System.currentTimeMillis() - this.trynoteDetection > this.TIME_SPAN_FOR_NOTEDETECTION) {
            currentStage = 3;
        }
        if (currentStage == 0) {
            if (this.scale < (float)this.scale0 && this.direction) {
                this.scale += this.SCALESTEPS;
            } else {
                this.scale -= this.SCALESTEPS;
                this.direction = false;
                if (this.scale < (float)this.scale1) {
                    this.direction = true;
                }
            }
        }
        if (currentStage == 1) {
            if (this.scale < (float)this.scale1 && this.direction) {
                this.scale += this.SCALESTEPS;
            } else {
                this.scale -= this.SCALESTEPS;
                this.direction = false;
                if (this.scale < (float)this.scale2) {
                    this.direction = true;
                }
            }
        }
        if (currentStage == 2) {
            if (this.scale < (float)this.scale2 && this.direction) {
                this.scale += this.SCALESTEPS;
            } else {
                this.scale -= this.SCALESTEPS;
                this.direction = false;
                if (this.scale < (float)this.scale3) {
                    this.direction = true;
                }
            }
        }
        if (currentStage == 3) {
            this.structureCanvas(this.scale);
            if (this.scale < (float)this.scale3 && this.direction) {
                this.scale += this.SCALESTEPS;
            } else {
                this.scale -= this.SCALESTEPS;
                this.direction = false;
                if (this.scale <= 0.0f) {
                    this.parent.background(255);
                    this.ready = true;
                    this.parent.delay(200);
                    this.structureCanvas(0.0f);
                    return;
                }
            }
        }
    }

    public boolean getReadyState() {
        return this.ready;
    }

    public void startTheAnimation() {
        this.scale = 70.0f;
        this.trynoteDetection = System.currentTimeMillis();
        this.firstBeatGotPlayed = true;
    }

    public void structureCanvas(float scale) {
        int y = 0;
        if (scale != 0.0f) {
            this.parent.loadPixels();
            int currentPixel = 0;
            while (currentPixel < this.parent.width * this.parent.height) {
                int xPixel = currentPixel - y * this.parent.width;
                if (xPixel % 2 == 0 && y % 2 == 1 || xPixel % 2 == 1 && y % 2 == 0) {
                    this.parent.pixels[currentPixel] = this.parent.color((int)(255.0f - this.CANVAS_STRUCTURE_LIGHT * (1.0f / scale)));
                }
                if (xPixel % 2 == 0 && y % 2 == 0) {
                    this.parent.pixels[currentPixel] = this.parent.color((int)(255.0f - this.CANVAS_STRUCTURE_DARK * (1.0f / scale)));
                }
                if ((currentPixel + 1) % this.parent.width == 0) {
                    ++y;
                }
                ++currentPixel;
            }
            this.parent.updatePixels();
        } else {
            int currentPixel = 0;
            while (currentPixel < this.parent.width * this.parent.height) {
                int xPixel = currentPixel - y * this.parent.width;
                if (xPixel % 2 == 0 && y % 2 == 1 || xPixel % 2 == 1 && y % 2 == 0) {
                    this.parent.stroke((int)(255.0f - (this.CANVAS_STRUCTURE_LIGHT - 5.0f)));
                    this.parent.line(xPixel + 1, y + 1, xPixel + 1, y + 1);
                }
                if (xPixel % 2 == 0 && y % 2 == 0) {
                    this.parent.stroke((int)(255.0f - (this.CANVAS_STRUCTURE_DARK - 5.0f)));
                    this.parent.line(xPixel + 1, y + 1, xPixel + 1, y + 1);
                }
                if ((currentPixel + 1) % this.parent.width == 0) {
                    ++y;
                }
                ++currentPixel;
            }
        }
    }
}

