/*
 * Decompiled with CFR 0.152.
 */
package gui;

import controlP5.Button;
import controlP5.CVector3f;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControlWindowCanvas;
import controlP5.RadioButton;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import processing.core.PApplet;
import processing.pdf.PGraphicsPDF;

public class Setup {
    private ControlP5 controlP5;
    private PApplet parent;
    private Textlabel theSingingCanvas;
    private Textlabel titleLabel;
    private Textfield titleTextfield;
    private Textlabel artistLabel;
    private Textfield artistTextfield;
    private Textlabel chooseMidiLabel;
    private Textlabel printTextfield;
    private Textlabel warningText;
    private RadioButton radioButtons;
    private Button startButton;
    private int TEXTFIELD_WIDTH = 150;
    private int TEXTFIELD_HEIGHT = 14;
    private int DARK = 20;
    private int MEDIUM = 100;
    private int LIGHT = 200;
    private int PADDING_TOP = 400;
    private int PADDING_LEFT = (440 - this.TEXTFIELD_WIDTH) / 2;
    private String FONT = "Times New Roman";
    private int numberOfMidiDevices;
    private String START_TITLE = "Testmalen_Theme";

    public Setup(PApplet parent) {
        this.parent = parent;
        this.controlP5 = new ControlP5(parent);
        this.theSingingCanvas = this.controlP5.addTextlabel("theSingingCanvas", "the singing CANVAS", this.PADDING_LEFT, this.PADDING_TOP);
        this.theSingingCanvas.valueLabel().setColor(parent.color(this.DARK));
        this.theSingingCanvas.draw(parent);
        this.titleLabel = this.controlP5.addTextlabel("titleLabel", "this canvas will be", this.PADDING_LEFT, this.PADDING_TOP + 25);
        this.titleLabel.valueLabel().setColor(parent.color(this.MEDIUM));
        this.titleLabel.draw(parent);
        this.titleTextfield = this.controlP5.addTextfield("title", this.PADDING_LEFT, this.PADDING_TOP + 40, this.TEXTFIELD_WIDTH, this.TEXTFIELD_HEIGHT);
        this.titleTextfield.valueLabel().style().movePadding(-4, 0, 0, 0);
        this.titleTextfield.setColorBackground(255);
        this.titleTextfield.setColorForeground(this.LIGHT);
        this.titleTextfield.valueLabel().setColor(this.DARK);
        this.titleTextfield.setColorActive(this.DARK);
        this.titleTextfield.setFocus(true);
        this.titleTextfield.setValue("");
        this.titleTextfield.setAutoClear(false);
        this.artistLabel = this.controlP5.addTextlabel("artistLabel", "as played by", this.PADDING_LEFT, this.PADDING_TOP + 65);
        this.artistLabel.valueLabel().setColor(parent.color(this.MEDIUM));
        this.artistLabel.draw(parent);
        this.artistTextfield = this.controlP5.addTextfield("artist", this.PADDING_LEFT, this.PADDING_TOP + 80, this.TEXTFIELD_WIDTH, this.TEXTFIELD_HEIGHT);
        this.artistTextfield.valueLabel().style().movePadding(-4, 0, 0, 0);
        this.artistTextfield.setColorBackground(255);
        this.artistTextfield.setColorForeground(this.LIGHT);
        this.artistTextfield.valueLabel().setColor(this.DARK);
        this.artistTextfield.setColorActive(this.DARK);
        this.artistTextfield.setFocus(false);
        this.artistTextfield.setValue("");
        this.artistTextfield.setAutoClear(false);
        this.chooseMidiLabel = this.controlP5.addTextlabel("chooseMidiLabel", "choose your input:", this.PADDING_LEFT, this.PADDING_TOP + 105);
        this.chooseMidiLabel.valueLabel().setColor(parent.color(this.MEDIUM));
        this.chooseMidiLabel.draw(parent);
        this.warningText = this.controlP5.addTextlabel("warningText", "no Input available", this.PADDING_LEFT, this.PADDING_TOP + 120);
        this.warningText.valueLabel().setColor(parent.color(200, 0, 0));
        this.warningText.draw(parent);
        this.warningText.hide();
        this.radioButtons = this.controlP5.addRadioButton("radioButton", this.PADDING_LEFT, this.PADDING_TOP + 120);
        this.radioButtons.setNoneSelectedAllowed(false);
        this.radioButtons.setColorForeground(parent.color(100));
        this.radioButtons.setColorActive(parent.color(this.MEDIUM));
        this.radioButtons.setColorBackground(parent.color(255));
        this.radioButtons.setColorLabel(parent.color(this.DARK));
        this.radioButtons.setItemHeight(this.TEXTFIELD_HEIGHT);
        this.radioButtons.setItemWidth(this.TEXTFIELD_HEIGHT);
        this.radioButtons.setItemsPerRow(1);
        this.radioButtons.setSpacingRow(4);
        String[] fonts = PGraphicsPDF.listFonts();
        int font = 0;
        while (font < fonts.length) {
            if (fonts[font].equals(this.FONT)) {
                ControlFont h1 = new ControlFont(parent.createFont(this.FONT, 815.0f), 17);
                ControlFont p = new ControlFont(parent.createFont(this.FONT, 815.0f), 11);
                this.controlP5.setControlFont(p);
                this.titleTextfield.valueLabel().setControlFont(p);
                this.theSingingCanvas.valueLabel().setControlFont(h1);
                this.artistTextfield.valueLabel().setControlFont(p);
                break;
            }
            ++font;
        }
        this.controlP5.setAutoDraw(true);
        this.controlP5.show();
    }

    private void addToRadioButton(RadioButton theRadioButton, String theName, int theValue) {
        Toggle t = theRadioButton.addItem(theName, (float)theValue);
        t.captionLabel().setColorBackground(this.parent.color(230));
        t.captionLabel().style().movePadding(3, 0, 0, 2);
        t.captionLabel().style().moveMargin(-2, 100, 0, 0);
        t.valueLabel().style().marginTop = 15;
        t.captionLabel().style().backgroundHeight = this.TEXTFIELD_HEIGHT - 3;
        t.captionLabel().style().backgroundWidth = this.TEXTFIELD_WIDTH - this.TEXTFIELD_HEIGHT - 6;
        CVector3f pos = t.position();
        CVector3f absoloutePos = t.absolutePosition();
        RadioRect radioBox = new RadioRect(absoloutePos.x + pos.x, absoloutePos.y + pos.y, this.TEXTFIELD_HEIGHT - 1, this.TEXTFIELD_HEIGHT - 1);
        radioBox.post();
        this.controlP5.controlWindow.addCanvas(radioBox);
    }

    public void setMidiInputs(String[] inputDevices) {
        this.numberOfMidiDevices = inputDevices.length;
        int x = 0;
        while (x < inputDevices.length) {
            this.addToRadioButton(this.radioButtons, inputDevices[x], x);
            ++x;
        }
        this.printTextfield = this.controlP5.addTextlabel("printTextfield", "press <p> to print when finished", this.PADDING_LEFT, this.PADDING_TOP + 120 + (this.numberOfMidiDevices + 1) * (this.TEXTFIELD_HEIGHT + 2));
        this.printTextfield.valueLabel().setColor(this.parent.color(this.MEDIUM));
        this.printTextfield.draw(this.parent);
        this.startButton = this.controlP5.addButton("startButton", 0.0f, this.PADDING_LEFT + 27, this.PADDING_TOP + 120 + (this.numberOfMidiDevices + 2) * (this.TEXTFIELD_HEIGHT + 2), this.TEXTFIELD_WIDTH - 60, this.TEXTFIELD_HEIGHT);
        this.startButton.captionLabel().style().marginLeft = 17;
        this.startButton.captionLabel().style().movePadding(-1, 0, 0, 7);
        this.startButton.setColorBackground(this.parent.color(this.LIGHT));
        this.startButton.setColorForeground(this.MEDIUM);
        this.startButton.setCaptionLabel("start");
        this.startButton.setColorActive(this.parent.color(this.DARK));
        if (this.numberOfMidiDevices == 0) {
            this.startButton.hide();
            this.printTextfield.valueLabel().set("please make your Midi-Input available and restart");
            this.warningText.show();
        } else {
            this.radioButtons.activate(this.numberOfMidiDevices - 1);
        }
    }

    public int getRadioState() {
        int inputDevice = -1;
        int x = 0;
        while (x < this.numberOfMidiDevices) {
            if (this.radioButtons.getState(x)) {
                inputDevice = x;
                break;
            }
            ++x;
        }
        return inputDevice;
    }

    public void changeInputFocus() {
        if (this.titleTextfield.isFocus()) {
            this.titleTextfield.setFocus(false);
            this.artistTextfield.setFocus(true);
        } else if (this.artistTextfield.isFocus()) {
            this.artistTextfield.setFocus(false);
            this.titleTextfield.setFocus(true);
        }
        if (!this.titleTextfield.isFocus() && !this.artistTextfield.isFocus()) {
            this.titleTextfield.setFocus(true);
        }
    }

    public boolean checkData() {
        boolean ret = true;
        if (this.titleTextfield.getText() == "") {
            ret = false;
        }
        if (this.artistTextfield.getText() == "") {
            ret = false;
        }
        return ret;
    }

    public String getFilename() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd");
        sdf.format(cal.getTime());
        return String.valueOf(sdf.format(cal.getTime())) + "_" + this.titleTextfield.getText() + "_by_" + this.artistTextfield.getText();
    }

    public void hideGUI() {
        this.controlP5.setAutoDraw(false);
        this.controlP5.hide();
    }

    public void showGUI() {
        this.controlP5.setAutoDraw(true);
        this.controlP5.show();
    }

    public boolean isVisible() {
        return this.controlP5.isVisible();
    }

    class RadioRect
    extends ControlWindowCanvas {
        private float posX;
        private float posY;
        private int width;
        private int height;

        public RadioRect(float x, float y, int width, int height) {
            this.posX = x;
            this.posY = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public void draw(PApplet parent) {
            parent.stroke(parent.color(Setup.this.LIGHT));
            parent.noFill();
            parent.rect(this.posX, this.posY, this.width, this.height);
        }
    }
}

