/*
 * Decompiled with CFR 0.152.
 */
package graphic;

public class DirectionManagement {
    private int STEPS_INCREASE = 25;
    private int MAXMIMUM_INCREASE = 60;
    private float BASIC_SPEED = 0.3f;
    private float adjustedSteps = this.STEPS_INCREASE;
    private float oldDirectionX = 0.0f;
    private float oldDirectionY = 1.0f;
    private float newDirectionX = 0.0f;
    private float newDirectionY = 1.0f;
    private float translateDirectionX = 0.0f;
    private float translateDirectionY = 0.0f;
    private int lastTranslations = 0;
    private int translationsTodo = 0;
    private int lastTranslationSteps = 10;
    private int stepsX = 10;
    private int stepsY = 10;

    public void adjustSteps(int hPs) {
        this.adjustedSteps = this.STEPS_INCREASE + (this.MAXMIMUM_INCREASE - hPs);
    }

    public float analyseDirectionX(int turns, int mainDirection) {
        if (turns != this.lastTranslations) {
            this.lastTranslations = turns;
            this.translationsTodo = turns;
            this.lastTranslationSteps = (int)((float)turns * this.adjustedSteps);
            this.translateDirectionX = this.oldDirectionX;
        }
        this.newDirectionX = (float)(mainDirection * turns) * this.BASIC_SPEED;
        if (this.stepsX == 0) {
            this.stepsX = (int)((float)turns * this.adjustedSteps);
        }
        this.translateDirectionX();
        return this.oldDirectionX;
    }

    public float analyseDirectionY(int turns, int mainDirection) {
        this.newDirectionY = (float)(mainDirection * turns) * this.BASIC_SPEED;
        this.translateDirectionY();
        return this.oldDirectionY;
    }

    private void translateDirectionX() {
        if (this.stepsX > 0) {
            this.oldDirectionX += (this.newDirectionX - this.oldDirectionX) / (float)this.stepsX;
            --this.stepsX;
        } else {
            this.oldDirectionX = this.newDirectionX;
            if (this.translationsTodo > 0) {
                this.newDirectionX = this.translateDirectionX;
                this.translateDirectionX = this.oldDirectionX;
                --this.translationsTodo;
                this.stepsX = this.lastTranslationSteps;
                this.stepsY = this.lastTranslationSteps;
            }
        }
    }

    private void translateDirectionY() {
        if (this.stepsY > 0) {
            this.oldDirectionY += (this.newDirectionY - this.oldDirectionY) / (float)this.stepsY;
            --this.stepsY;
        } else {
            this.oldDirectionY = this.newDirectionY;
            if (this.translationsTodo > 0) {
                this.newDirectionY = this.translateDirectionY;
                this.translateDirectionY = this.oldDirectionY;
                --this.translationsTodo;
            }
        }
    }
}

