/*
 * Decompiled with CFR 0.152.
 */
package graphic;

import java.util.HashMap;

public class ColorManagement {
    private int MIX_STRENGTH = -1;
    private int PITCH_CORRECTION = 65;
    private int PITCH_MULTIPLIER = 6;
    private HashMap<String, int[]> colorMap = new HashMap();
    private int[] cDur = new int[]{255, 64, 39};
    private int[] gDur = new int[]{255, 118, 8};
    private int[] dDur = new int[]{255, 207, 39};
    private int[] aDur = new int[]{39, 188, 4};
    private int[] eDur = new int[]{180, 180, 180};
    private int[] hDur = new int[]{61, 140, 248};
    private int[] fisDur = new int[]{102, 2031, 240};
    private int[] desDur = new int[]{181, 107, 250};
    private int[] asDur = new int[]{170, 35, 209};
    private int[] esDur = new int[]{105, 88, 170};
    private int[] bDur = new int[]{113, 147, 181};
    private int[] fDur = new int[]{165, 62, 38};
    private int[] aMoll = new int[]{131, 76, 69};
    private int[] eMoll = new int[]{189, 132, 87};
    private int[] hMoll = new int[]{185, 150, 27};
    private int[] fisMoll = new int[]{71, 128, 57};
    private int[] cisMoll = new int[]{87, 110, 115};
    private int[] gisMoll = new int[]{77, 104, 140};
    private int[] disMoll = new int[]{63, 121, 142};
    private int[] bMoll = new int[]{144, 104, 180};
    private int[] fMoll = new int[]{131, 76, 147};
    private int[] cMoll = new int[]{84, 75, 118};
    private int[] gMoll = new int[]{75, 92, 110};
    private int[] dMoll = new int[]{107, 49, 41};

    public ColorManagement() {
        this.colorMap.put("C-Dur", this.cDur);
        this.colorMap.put("G-Dur", this.gDur);
        this.colorMap.put("D-Dur", this.dDur);
        this.colorMap.put("A-Dur", this.aDur);
        this.colorMap.put("E-Dur", this.eDur);
        this.colorMap.put("B-Dur", this.hDur);
        this.colorMap.put("F#-Dur", this.fisDur);
        this.colorMap.put("C#-Dur", this.desDur);
        this.colorMap.put("G#-Dur", this.asDur);
        this.colorMap.put("D#-Dur", this.esDur);
        this.colorMap.put("Bb-Dur", this.bDur);
        this.colorMap.put("F-Dur", this.fDur);
        this.colorMap.put("A-moll", this.aMoll);
        this.colorMap.put("E-moll", this.eMoll);
        this.colorMap.put("B-moll", this.hMoll);
        this.colorMap.put("F#-moll", this.fisMoll);
        this.colorMap.put("C#-moll", this.cisMoll);
        this.colorMap.put("G#-moll", this.gisMoll);
        this.colorMap.put("D#-moll", this.disMoll);
        this.colorMap.put("Bb-moll", this.bMoll);
        this.colorMap.put("F-moll", this.fMoll);
        this.colorMap.put("C-moll", this.cMoll);
        this.colorMap.put("G-moll", this.gMoll);
        this.colorMap.put("D-moll", this.dMoll);
    }

    public int[] getColor(String note, int pitch, String mainTune) {
        int[] mix = new int[]{128, 128, 128};
        int[] basic = new int[]{128, 128, 128};
        if (this.colorMap.containsKey(note)) {
            mix[0] = this.colorMap.get(note)[0];
            mix[1] = this.colorMap.get(note)[1];
            mix[2] = this.colorMap.get(note)[2];
        }
        if (this.colorMap.containsKey(mainTune)) {
            basic[0] = this.colorMap.get(mainTune)[0];
            basic[1] = this.colorMap.get(mainTune)[1];
            basic[2] = this.colorMap.get(mainTune)[2];
        }
        if (this.MIX_STRENGTH < 0) {
            mix[0] = (Math.abs(this.MIX_STRENGTH) * basic[0] + mix[0]) / (Math.abs(this.MIX_STRENGTH) + 1);
            mix[1] = (Math.abs(this.MIX_STRENGTH) * basic[1] + mix[1]) / (Math.abs(this.MIX_STRENGTH) + 1);
            mix[2] = (Math.abs(this.MIX_STRENGTH) * basic[2] + mix[2]) / (Math.abs(this.MIX_STRENGTH) + 1);
        }
        if (this.MIX_STRENGTH > 0) {
            mix[0] = (Math.abs(this.MIX_STRENGTH) * mix[0] + basic[0]) / (Math.abs(this.MIX_STRENGTH) + 1);
            mix[1] = (Math.abs(this.MIX_STRENGTH) * mix[1] + basic[1]) / (Math.abs(this.MIX_STRENGTH) + 1);
            mix[2] = (Math.abs(this.MIX_STRENGTH) * mix[2] + basic[2]) / (Math.abs(this.MIX_STRENGTH) + 1);
        }
        if (this.MIX_STRENGTH == 0) {
            mix[0] = (mix[0] + basic[0]) / 2;
            mix[1] = (mix[1] + basic[1]) / 2;
            mix[2] = (mix[2] + basic[2]) / 2;
        }
        int pitchCorrection = (pitch - this.PITCH_CORRECTION) * this.PITCH_MULTIPLIER;
        int x = 0;
        while (x < 3) {
            int n = x;
            mix[n] = mix[n] + pitchCorrection;
            if (mix[x] < 0) {
                mix[x] = 0;
            }
            if (mix[x] > 255) {
                mix[x] = 255;
            }
            ++x;
        }
        return mix;
    }
}

