/*
 * Decompiled with CFR 0.152.
 */
package graphic;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import processing.core.PApplet;

public class CanvasAnalysis {
    private PApplet parent;
    private int checkSizeX;
    private int checkSizeY;
    private int amountX;
    private int currentMode = 0;
    private int[] availibleFields;
    private int MODE = 10;

    public CanvasAnalysis(PApplet parent, int checkSizeX, int checkSizeY) {
        this.parent = parent;
        this.checkSizeX = checkSizeX;
        this.checkSizeY = checkSizeY;
        this.amountX = parent.width / checkSizeX;
    }

    public SortedMap<Integer, Integer> analyseCanvas(boolean mode) {
        HashMap<Integer, Integer> analysedPixels = new HashMap<Integer, Integer>();
        this.parent.loadPixels();
        int y = 0;
        int field = 0;
        int y_fields = 0;
        int x = 0;
        int currentPixel = 0;
        while (currentPixel < this.parent.width * this.parent.height - 2) {
            if (analysedPixels.containsKey(field)) {
                int oldFieldValue = (Integer)analysedPixels.get(field);
                analysedPixels.put(field, (int)((float)oldFieldValue + this.parent.brightness(this.parent.pixels[currentPixel])));
            } else {
                analysedPixels.put(field, (int)this.parent.brightness(this.parent.pixels[currentPixel]));
            }
            if ((currentPixel + 4) % this.checkSizeX == 0) {
                ++x;
            }
            if ((currentPixel + 4) % this.checkSizeX == 0 && x % this.amountX == 0) {
                ++y;
                x = 0;
            }
            if ((currentPixel + 4) % this.checkSizeX == 0 && x % this.amountX == 0 && y % this.checkSizeY == 0) {
                y = 0;
                ++y_fields;
            }
            field = x + y_fields * this.amountX;
            currentPixel += 4;
        }
        TreeMap<Integer, Integer> sortedFields = mode ? new TreeMap<Integer, Integer>(new ValueComparerWhite(analysedPixels)) : new TreeMap(new ValueComparerBlack(analysedPixels));
        sortedFields.putAll(analysedPixels);
        return sortedFields;
    }

    public int[] getNewPosition(boolean mode) {
        int[] ret = new int[2];
        SortedMap<Integer, Integer> sortedFields = this.analyseCanvas(mode);
        int pos = sortedFields.isEmpty() ? 300 : sortedFields.firstKey();
        this.availibleFields = new int[0];
        int x = 0;
        Iterator<Integer> iter = sortedFields.keySet().iterator();
        while (iter.hasNext()) {
            this.availibleFields = this.reSizeArray(this.availibleFields, iter.next());
            ++x;
        }
        pos = this.currentMode < this.availibleFields.length ? this.availibleFields[this.currentMode] : this.parent.height / this.checkSizeY * this.amountX / 2;
        ++this.currentMode;
        if (this.currentMode == this.MODE) {
            this.currentMode = 0;
        }
        ret[0] = this.checkSizeX / 2 + pos % this.amountX * this.checkSizeX;
        ret[1] = this.checkSizeY / 2 + (pos - pos % this.amountX) / this.amountX * this.checkSizeY;
        return ret;
    }

    private int[] reSizeArray(int[] oldArray, int value) {
        int[] copy = new int[oldArray.length + 1];
        int i = 0;
        while (i < oldArray.length) {
            copy[i] = oldArray[i];
            ++i;
        }
        copy[oldArray.length] = value;
        return copy;
    }

    public static class ValueComparerBlack<K, V extends Comparable<V>>
    implements Comparator<K> {
        private Map<K, V> data = null;

        public ValueComparerBlack(Map<K, V> data) {
            this.data = data;
        }

        @Override
        public int compare(K key1, K key2) {
            Comparable value2;
            Comparable value1 = (Comparable)this.data.get(key1);
            int c = value1.compareTo(value2 = (Comparable)this.data.get(key2));
            if (c != 0) {
                return c;
            }
            Integer h1 = key1.hashCode();
            Integer h2 = key2.hashCode();
            return h1.compareTo(h2);
        }
    }

    public static class ValueComparerWhite<K, V extends Comparable<V>>
    implements Comparator<K> {
        private Map<K, V> data = null;

        public ValueComparerWhite(Map<K, V> data) {
            this.data = data;
        }

        @Override
        public int compare(K key1, K key2) {
            Comparable value1 = (Comparable)this.data.get(key1);
            Comparable value2 = (Comparable)this.data.get(key2);
            int c = value2.compareTo(value1);
            if (c != 0) {
                return c;
            }
            Integer h1 = key1.hashCode();
            Integer h2 = key2.hashCode();
            return h1.compareTo(h2);
        }
    }
}

