/*
 * Decompiled with CFR 0.152.
 */
package graphic;

import graphic.HitBorderEvent;
import graphic.HitBorderEventListener;
import javax.swing.event.EventListenerList;
import processing.core.PApplet;

public class Brush {
    private int SPEED_DECREASE_BRUSH = 45;
    private int SPEED_DECREASE_FEATHER = 30;
    private int BASIC_ALPHA = 160;
    private float THICKNESS_DECREASE = 28.0f;
    private float THICKNESS_TRANSLATION_STEPS = 40.0f;
    private float PITCH_START = 80.0f;
    private float FEATHER = 2.0f;
    private float BASIC_FEATHER_WIDTH = 1.0f;
    private float MAX_FEATHER_THICKNESS = 10.0f;
    private int FEATHER_BLACKENER = 50;
    private float MIN_SPEED = 0.4f;
    private String mode;
    protected EventListenerList listenerList = new EventListenerList();
    private HitBorderEvent hitBorderEvent;
    private PApplet parent;
    private float positionX;
    private float positionY;
    private float oldPositionX;
    private float oldPositionY;
    private float newThickness;
    private float thickness;
    private float thicknessSteps = 0.0f;
    private float dirX;
    private float dirY;
    private float directionX;
    private float directionY;
    private float curveDirX = 0.0f;
    private float curveDirY = 0.0f;
    private int[] color = new int[4];
    private float speed;

    public Brush(PApplet parent, int[] brushColor, int positionX, int positionY, float dirX, float dirY, int thickness, String mode) {
        this.parent = parent;
        this.positionX = positionX;
        this.positionY = positionY;
        this.oldPositionX = positionX;
        this.oldPositionY = positionY;
        this.thickness = thickness;
        this.color = brushColor;
        this.dirX = dirX;
        this.dirY = dirY;
        this.mode = mode;
        this.hitBorderEvent = new HitBorderEvent(this, mode);
    }

    public void moveBrush() {
        this.oldPositionX = this.positionX;
        this.oldPositionY = this.positionY;
        this.directionX = this.dirX + this.curveDirX;
        this.directionY = this.dirY + this.curveDirY;
        this.positionX += this.directionX * this.speed;
        this.positionY += this.directionY * this.speed;
        if (this.mode == "BRUSH") {
            this.translateThickness();
        }
        if (this.mode == "FEATHER") {
            this.thicknessSteps = this.THICKNESS_TRANSLATION_STEPS;
            this.thickness = this.newThickness;
        }
        this.parent.strokeWeight(this.thickness);
        this.parent.smooth();
        this.parent.stroke(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.parent.line(this.oldPositionX, this.oldPositionY, this.positionX, this.positionY);
        if (this.positionX < 0.0f || this.positionX > (float)this.parent.width) {
            this.dirX = -this.dirX;
            this.fireHitBorderEvent(this.hitBorderEvent);
        }
        if (this.positionY < 0.0f || this.positionY > (float)this.parent.height) {
            this.fireHitBorderEvent(this.hitBorderEvent);
            this.dirY = -this.dirY;
        }
    }

    public void setSpeed(float newSpeed) {
        if (this.mode == "BRUSH") {
            this.speed = newSpeed / (float)this.SPEED_DECREASE_BRUSH;
            if (this.speed <= 0.0f) {
                this.speed = this.MIN_SPEED;
            }
        }
        if (this.mode == "FEATHER") {
            this.speed = newSpeed / (float)this.SPEED_DECREASE_FEATHER;
            if (this.speed <= 0.0f) {
                this.speed = this.MIN_SPEED;
            }
        }
    }

    public void setAlpha(int alpha) {
        if (this.mode == "BRUSH") {
            this.color[3] = (int)((float)(alpha * this.BASIC_ALPHA / 127) + this.speed * 7.0f);
        } else if (this.mode == "FEATHER") {
            this.color[3] = (int)((float)(alpha * this.BASIC_ALPHA / 30) + this.speed * 7.0f);
        }
    }

    public void setThickness(float thickness, float pitch) {
        if (this.mode == "BRUSH") {
            this.newThickness = thickness / this.THICKNESS_DECREASE + (this.PITCH_START - pitch);
        } else if (this.mode == "FEATHER") {
            this.newThickness = this.FEATHER + this.BASIC_FEATHER_WIDTH + (Math.abs(this.directionX) - Math.abs(this.directionY)) * this.FEATHER;
            if (thickness > this.MAX_FEATHER_THICKNESS) {
                thickness = this.MAX_FEATHER_THICKNESS;
            }
        } else {
            this.newThickness = thickness;
        }
        if (this.newThickness <= 0.0f) {
            this.newThickness = 0.2f;
        }
        this.thicknessSteps = 0.0f;
    }

    public void setColor(int[] newColor) {
        if (this.mode == "BRUSH") {
            this.color[0] = newColor[0];
            this.color[1] = newColor[1];
            this.color[2] = newColor[2];
        } else if (this.mode == "FEATHER") {
            int col = (newColor[0] + newColor[1] + newColor[2]) / 3;
            if ((col -= this.FEATHER_BLACKENER) < 0) {
                col = 0;
            }
            if (col > 150) {
                col = 150;
            }
            this.color[0] = col;
            this.color[1] = col;
            this.color[2] = col;
        } else {
            this.color[0] = newColor[0];
            this.color[1] = newColor[1];
            this.color[2] = newColor[2];
        }
    }

    public void setCurveDirection(float curveDirectionX, float curveDirectionY) {
        this.curveDirX = curveDirectionX;
        this.curveDirY = curveDirectionY;
    }

    public void addHitBorderEventListener(HitBorderEventListener listener) {
        this.listenerList.add(HitBorderEventListener.class, listener);
    }

    public void removeHitBorderEventListener(HitBorderEventListener listener) {
        this.listenerList.remove(HitBorderEventListener.class, listener);
    }

    public void fireHitBorderEvent(HitBorderEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == HitBorderEventListener.class) {
                ((HitBorderEventListener)listeners[i + 1]).hitBorderEventOccurred(evt);
            }
            i += 2;
        }
    }

    public void setNewPosition(int[] newPosition) {
        this.positionX = newPosition[0];
        this.positionY = newPosition[1];
    }

    private void translateThickness() {
        if (this.thickness != this.newThickness) {
            this.thicknessSteps += 1.0f;
            this.thickness = this.thicknessSteps != this.THICKNESS_TRANSLATION_STEPS ? (this.thickness += (this.newThickness - this.thickness) / (this.THICKNESS_TRANSLATION_STEPS - this.thicknessSteps)) : this.newThickness;
        }
    }

    public int[] getCurrentPosition() {
        int[] ret = new int[]{(int)this.oldPositionX, (int)this.oldPositionY};
        return ret;
    }
}

