/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.Label;
import controlP5.Tab;
import processing.core.PApplet;

public class Numberbox
extends Controller {
    protected int cnt;
    protected boolean isActive;
    public static int LEFT = 0;
    public static int UP = 1;
    public static int RIGHT = 2;
    public static int DOWN = 3;
    protected int _myNumberCount = 1;
    protected float _myMultiplier = 1.0f;
    protected static int autoWidth = 70;
    protected static int autoHeight = 15;
    protected CVector3f autoSpacing = new CVector3f(10.0f, 20.0f, 0.0f);

    public Numberbox(ControlP5 controlP5, Tab tab, String string, float f, int n, int n2, int n3, int n4) {
        super(controlP5, tab, string, n, n2, n3, n4);
        this._myValue = f;
        this._myValueLabel = new Label("" + this._myValue, n3, 12, this.color.colorValueLabel);
        this._myMin = -1000000.0f;
        this._myMax = 1000000.0f;
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isActive && !ControlP5.keyHandler.isAltDown) {
            if (this._myNumberCount == 1) {
                this.setValue(this._myValue + (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY) * this._myMultiplier);
            } else {
                this.setValue(this._myValue + (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX) * this._myMultiplier);
            }
        }
    }

    public void mousePressed() {
        this.isActive = true;
    }

    public void mouseReleased() {
        this.isActive = false;
    }

    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public void setMultiplier(float f) {
        this._myMultiplier = f;
    }

    public float multiplier() {
        return this._myMultiplier;
    }

    public void setValue(float f) {
        this._myValue = f;
        this._myValue = Math.max(this._myMin, Math.min(this._myMax, this._myValue));
        this.broadcast(1);
        this._myValueLabel.set(this.adjustValue(this._myValue));
    }

    public void setDirection(int n) {
        this._myNumberCount = n == 0 || n == 1 ? n : 1;
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public Controller linebreak() {
        this.controlP5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "numberbox");
    }

    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new NumberboxDisplay();
            }
        }
    }

    class NumberboxDisplay
    implements ControllerDisplay {
        NumberboxDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            pApplet.fill(Numberbox.this.color.colorBackground);
            pApplet.rect(0.0f, 0.0f, Numberbox.this.width, Numberbox.this.height);
            pApplet.fill(Numberbox.this.isActive ? Numberbox.this.color.colorActive : Numberbox.this.color.colorForeground);
            int n = Numberbox.this.height / 2;
            pApplet.triangle(0.0f, n - 6, 6.0f, n, 0.0f, n + 6);
            Numberbox.this._myCaptionLabel.draw(pApplet, 0, Numberbox.this.height + 4);
            Numberbox.this._myValueLabel.draw(pApplet, 10, n - Numberbox.this._myValueLabel.height() / 2 + 3);
        }
    }
}

