/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import processing.core.PApplet;

public class Matrix
extends Controller {
    protected int cnt;
    protected int[][] myMarkers;
    protected int stepX;
    protected int stepY;
    protected int cellX;
    protected int cellY;
    protected boolean isPressed;
    protected int _myCellX;
    protected int _myCellY;
    protected int sum;
    protected long _myTime;
    protected int _myInterval;
    protected int currentX = -1;
    protected int currentY = -1;

    public Matrix(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        super(controlP5, controllerGroup, string, n3, n4, n5, n6);
        this._myCellX = n;
        this._myCellY = n2;
        this.sum = this._myCellX * this._myCellY;
        this.stepX = this.width / this._myCellX;
        this.stepY = this.height / this._myCellY;
        this.myMarkers = new int[this._myCellX][this._myCellY];
        for (int i = 0; i < this._myCellX; ++i) {
            for (int j = 0; j < this._myCellY; ++j) {
                this.myMarkers[i][j] = -1;
            }
        }
        this._myTime = System.currentTimeMillis();
        this._myInterval = 100;
    }

    public void setInterval(int n) {
        this._myInterval = n;
    }

    public int getInterval() {
        return this._myInterval;
    }

    public void updateInternalEvents(PApplet pApplet) {
        int n;
        if (System.currentTimeMillis() > this._myTime + (long)this._myInterval) {
            ++this.cnt;
            this.cnt %= this._myCellX;
            this._myTime = System.currentTimeMillis();
            for (n = 0; n < this._myCellY; ++n) {
                if (this.myMarkers[this.cnt][n] != 1) continue;
                this._myValue = 0.0f;
                this._myValue = (this.cnt << 0) + (n << 8);
                this.setValue(this._myValue);
            }
        }
        this.setIsInside(this.inside());
        if (this.getIsInside() && this.isPressed) {
            n = (int)(((float)pApplet.mouseX - this.position.x) / (float)this.stepX);
            int n2 = (int)(((float)pApplet.mouseY - this.position.y) / (float)this.stepY);
            if (n != this.currentX || n2 != this.currentY) {
                boolean bl = this.myMarkers[n][n2] == 1;
                for (int i = 0; i < this._myCellY; ++i) {
                    this.myMarkers[n][i] = 0;
                }
                if (!bl) {
                    this.myMarkers[n][n2] = 1;
                }
                this.currentX = n;
                this.currentY = n2;
            }
        }
    }

    protected void onEnter() {
        this.isActive = true;
    }

    protected void onLeave() {
        this.isActive = false;
    }

    public void mousePressed() {
        this.isActive = this.getIsInside();
        if (this.getIsInside()) {
            this.isPressed = true;
        }
    }

    protected void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public void mouseReleased() {
        if (this.isActive) {
            this.isActive = false;
        }
        this.isPressed = false;
        this.currentX = -1;
        this.currentY = -1;
    }

    public void setValue(float f) {
        this._myValue = f;
        this.broadcast(1);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void set(int n, int n2, boolean bl) {
        this.myMarkers[n][n2] = bl ? 1 : 0;
    }

    public static int getX(int n) {
        return n >> 0 & 0xFF;
    }

    public static int getY(int n) {
        return n >> 8 & 0xFF;
    }

    public static int getX(float f) {
        return (int)f >> 0 & 0xFF;
    }

    public static int getY(float f) {
        return (int)f >> 8 & 0xFF;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "matrix");
    }

    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new MatrixDisplay();
                break;
            }
        }
    }

    class MatrixDisplay
    implements ControllerDisplay {
        MatrixDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            pApplet.noStroke();
            pApplet.fill(Matrix.this.color.colorBackground);
            pApplet.rect(0.0f, 0.0f, Matrix.this.width, Matrix.this.height);
            pApplet.noStroke();
            if (Matrix.this.isInside()) {
                pApplet.fill(Matrix.this.color.colorForeground);
                pApplet.rect((int)(((float)pApplet.mouseX - Matrix.this.position.x) / (float)Matrix.this.stepX) * Matrix.this.stepX, (int)(((float)pApplet.mouseY - Matrix.this.position.y) / (float)Matrix.this.stepY) * Matrix.this.stepY, Matrix.this.stepX, Matrix.this.stepY);
            }
            pApplet.stroke(Matrix.this.color.colorActive);
            pApplet.line(Matrix.this.cnt * Matrix.this.stepX, 0.0f, Matrix.this.cnt * Matrix.this.stepX, Matrix.this.height);
            pApplet.noStroke();
            pApplet.fill(Matrix.this.color.colorActive);
            for (int i = 0; i < Matrix.this._myCellX; ++i) {
                for (int j = 0; j < Matrix.this._myCellY; ++j) {
                    if (Matrix.this.myMarkers[i][j] != 1) continue;
                    pApplet.rect(i * Matrix.this.stepX, j * Matrix.this.stepY, Matrix.this.stepX - 1, Matrix.this.stepY - 1);
                }
            }
        }
    }
}

