/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControllerGroup;
import controlP5.ListBoxItem;
import controlP5.Slider;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;

public class ListBox
extends ControlGroup
implements ControlListener {
    protected int _myItemHeight = 13;
    protected int maxButtons = 0;
    protected int _myOriginalBackgroundHeight = 0;
    protected Slider _myScrollbar;
    protected String _myName;
    protected float _myScrollValue = 0.0f;
    protected boolean isScrollbarVisible = true;
    protected int _myHeight;
    protected List<ListBoxItem> items = new ArrayList<ListBoxItem>();
    protected List<Button> buttons = new ArrayList<Button>();
    protected int spacing = 1;
    protected boolean isMultipleChoice = false;
    protected boolean pulldown;

    protected ListBox(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, 9);
        this._myWidth = n3;
        this._myName = string;
        this._myBackgroundHeight = n4;
        this._myScrollbar = new Slider(this.controlP5, this._myParent, string + "Scroller", 0.0f, 1.0f, 1.0f, this._myWidth + 1, 0, 10, this._myBackgroundHeight);
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.setMoveable(false);
        this._myScrollbar.setLabelVisible(false);
        this._myScrollbar.setParent(this);
        this._myScrollbar.addListener(this);
        this._myScrollbar.setVisible(false);
        this._myScrollbar.hide();
        this._myScrollbar.updateDisplayMode(0);
        this.add(this._myScrollbar);
        this.setHeight(this._myBackgroundHeight);
    }

    public void hideScrollbar() {
        this.isScrollbarVisible = false;
        this._myScrollbar.hide();
    }

    public void showScrollbar() {
        this.isScrollbarVisible = true;
        if (this.items.size() * this._myItemHeight > this._myBackgroundHeight && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
    }

    public boolean isScrollbarVisible() {
        return this.isScrollbarVisible;
    }

    public void scroll(float f) {
        if (this.items.size() * this._myItemHeight > this._myBackgroundHeight) {
            this._myScrollbar.setValue(PApplet.abs(1.0f - PApplet.min(PApplet.max(0.0f, f), 1.0f)));
        }
    }

    private void scroll() {
        int n = 0;
        if (this.buttons.size() < this.items.size() && this.isScrollbarVisible) {
            this._myScrollbar.show();
            n = (int)Math.abs(this._myScrollValue * (float)(this.items.size() - this.buttons.size()));
        } else {
            this._myScrollbar.hide();
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).setColor(this.items.get(n + i).getColor());
            this.buttons.get(i).captionLabel().set(this.items.get((int)(n + i)).text);
            this.buttons.get((int)i)._myValue = this.items.get((int)(n + i)).value;
        }
    }

    public void setItemHeight(int n) {
        this._myItemHeight = n;
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get((int)i).height = n;
            this.buttons.get((int)i).position.y = (n + this.spacing) * i;
        }
        this.setHeight(this._myOriginalBackgroundHeight);
    }

    public ListBox setHeight(int n) {
        this._myOriginalBackgroundHeight = n;
        this._myBackgroundHeight = this._myOriginalBackgroundHeight / (this._myItemHeight + this.spacing) * (this._myItemHeight + this.spacing);
        this.maxButtons = this._myBackgroundHeight / (this._myItemHeight + this.spacing);
        int n2 = this._myBackgroundHeight / (this._myItemHeight + this.spacing);
        int n3 = this.buttons.size();
        if (n2 < n3) {
            for (int i = this.buttons.size() - 1; i >= n2; --i) {
                this.controlP5.remove(this.controlP5.controller(this.buttons.get(i).name()));
                this.controllers.remove(this.buttons.get(i));
                this.buttons.remove(i);
            }
        } else if (n3 < n2) {
            int n4 = Math.min(n2, this.items.size());
            this.addListButton(n4 -= n3);
        }
        this.updateBackground();
        this.scroll();
        return this;
    }

    private void updateScroll() {
        this._myScrollValue = this._myScrollbar.value();
        this._myScrollbar.setValue(this._myScrollValue);
        if (this.buttons.size() < this.items.size() && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
        this.updateBackground();
        this.scroll();
    }

    private void updateBackground() {
        if (this.items.size() * (this._myItemHeight + this.spacing) < this._myOriginalBackgroundHeight) {
            this._myBackgroundHeight = this.items.size() * (this._myItemHeight + this.spacing);
        }
        if (this.buttons.size() < this.items.size()) {
            this._myScrollbar.setHeight(this._myBackgroundHeight - this.spacing);
            this._myScrollbar.show();
        } else {
            this._myScrollbar.hide();
        }
    }

    public ListBox setWidth(int n) {
        this._myWidth = n;
        for (int i = 1; i < this.controllers.size(); ++i) {
            ((Button)this.controllers.get((int)i)).width = n;
        }
        this._myScrollbar.position.x = this._myWidth + 1;
        return this;
    }

    protected void addListButton(int n) {
        for (int i = 0; i < n && this.buttons.size() < this.maxButtons; ++i) {
            int n2 = this.buttons.size();
            Button button = new Button(this.controlP5, this, this._myName + "Button" + n2, n2, 0, n2 * (this._myItemHeight + this.spacing), this._myWidth, this._myItemHeight, false);
            button.setMoveable(false);
            this.add(button);
            this.controlP5.register(button);
            button.setBroadcast(false);
            button.addListener(this);
            this.buttons.add(button);
        }
        this.updateScroll();
    }

    public ListBoxItem addItem(String string, int n) {
        ListBoxItem listBoxItem = new ListBoxItem(this, string, n);
        this.items.add(listBoxItem);
        this.addListButton(1);
        return listBoxItem;
    }

    public void removeItem(String string) {
        try {
            for (int i = this.items.size() - 1; i >= 0; --i) {
                if (!this.items.get((int)i).name.equals(string)) continue;
                this.items.remove(i);
            }
            if (this.buttons.size() > this.items.size()) {
                String string2 = ((Button)this.controllers.get(this.buttons.size())).name();
                this.buttons.remove(this.controlP5.controller(string2));
                this.controllers.remove(this.controlP5.controller(string2));
                this.controlP5.remove(string2);
            }
            this.updateScroll();
        }
        catch (Exception exception) {
            ControlP5.logger().finer("ScrollList.removeItem exception:" + exception);
        }
    }

    public ListBoxItem item(int n) {
        return this.items.get(n);
    }

    public ListBoxItem item(String string) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (!this.items.get((int)i).name.equals(string)) continue;
            return this.items.get(i);
        }
        return null;
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.controller() instanceof Button) {
            try {
                this._myValue = controlEvent.controller().value();
                ControlEvent controlEvent2 = new ControlEvent(this);
                if (this.pulldown) {
                    this.close();
                    this.setLabel(controlEvent.label());
                }
                this.controlP5.controlbroadcaster().broadcast(controlEvent2, 1);
                ((Button)controlEvent.controller()).onLeave();
                ((Button)controlEvent.controller()).setIsInside(false);
            }
            catch (Exception exception) {
                ControlP5.logger().warning("ScrollList.controlEvent exception:" + exception);
            }
        } else {
            this._myScrollValue = -(1.0f - controlEvent.value());
            this.scroll();
        }
    }

    public void actAsPulldownMenu(boolean bl) {
        this.pulldown = bl;
        if (this.pulldown) {
            this.close();
        }
    }

    public void clear() {
        int n;
        for (n = this.items.size() - 1; n >= 0; --n) {
            this.removeItem(this.items.get((int)n).name);
        }
        this.items.clear();
        for (n = this.buttons.size() - 1; n >= 0; --n) {
            this.controlP5.remove(this.buttons.get(n));
        }
        this._myBackgroundHeight = 0;
    }

    public void setColorActive(int n) {
        super.setColorActive(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get((int)i).getColor().colorActive = n;
        }
    }

    public void setColorForeground(int n) {
        super.setColorForeground(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get((int)i).getColor().colorForeground = n;
        }
    }

    public void setColorBackground(int n) {
        super.setColorBackground(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get((int)i).getColor().colorBackground = n;
        }
    }

    public void setColorLabel(int n) {
        super.setColorLabel(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get((int)i).getColor().colorCaptionLabel = n;
        }
    }

    public void setColorValue(int n) {
        super.setColorValue(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get((int)i).getColor().colorValueLabel = n;
        }
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "listBox");
    }
}

