/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlWindow;
import controlP5.ControllerInterface;
import processing.core.PApplet;
import processing.core.PGraphics;

class ControlPicking {
    PGraphics _myLookupImage;
    ControlWindow _myWindow;
    protected boolean isImplemeted = false;

    protected ControlPicking(ControlWindow controlWindow) {
        this._myWindow = controlWindow;
        if (this.isImplemeted) {
            this._myLookupImage = controlWindow.papplet().createGraphics(controlWindow.papplet().width, controlWindow.papplet().height, "processing.core.PGraphics3D");
        }
    }

    public void reset() {
        if (this.isImplemeted) {
            this._myLookupImage.beginDraw();
            this._myLookupImage.background(0x44000000);
            this._myLookupImage.endDraw();
        }
    }

    public void update(ControllerInterface controllerInterface) {
        if (this.isImplemeted) {
            this._myLookupImage.beginDraw();
            this._myLookupImage.noStroke();
            this._myLookupImage.fill(controllerInterface.getPickingColor());
            float f = controllerInterface.position().x() + controllerInterface.parent().absolutePosition().x();
            float f2 = controllerInterface.position().y() + controllerInterface.parent().absolutePosition().y();
            this._myLookupImage.rect(f, f2, controllerInterface.getWidth(), controllerInterface.getHeight());
            this._myLookupImage.endDraw();
        }
    }

    public void display(PApplet pApplet) {
        if (this.isImplemeted) {
            pApplet.image(this._myLookupImage, 0.0f, 0.0f);
        }
    }

    public int getNextColor() {
        return 100;
    }
}

