/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControllerGroup;
import controlP5.Label;
import processing.core.PApplet;

public class ControlGroup
extends ControllerGroup
implements ControlListener {
    protected Button _myCloseButton;
    protected int _myBackgroundHeight = 0;
    protected int _myBackgroundColor = 0xFFFFFF;
    protected boolean isEventActive = false;
    protected boolean isBarVisible = true;

    public ControlGroup(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2);
        this._myValueLabel = new Label("");
        this._myWidth = n3;
        this._myHeight = n4;
    }

    public void mousePressed() {
        if (this.isCollapse && !ControlP5.keyHandler.isAltDown) {
            boolean bl = this.isOpen = !this.isOpen;
            if (this.isEventActive) {
                this.controlP5.controlbroadcaster().broadcast(new ControlEvent(this), 0);
            }
        }
    }

    public ControlGroup activateEvent(boolean bl) {
        this.isEventActive = bl;
        return this;
    }

    public int getBackgroundHeight() {
        return this._myBackgroundHeight;
    }

    public void setBackgroundHeight(int n) {
        this._myBackgroundHeight = n;
    }

    public void setBackgroundColor(int n) {
        this._myBackgroundColor = n;
    }

    public void setBarHeight(int n) {
        this._myHeight = n;
    }

    protected void preDraw(PApplet pApplet) {
        if (this.isOpen) {
            pApplet.fill(this._myBackgroundColor);
            pApplet.rect(0.0f, 0.0f, this._myWidth, this._myBackgroundHeight - 1);
        }
    }

    protected void postDraw(PApplet pApplet) {
        if (this.isBarVisible) {
            pApplet.fill(this.isInside ? this.color.colorForeground : this.color.colorBackground);
            pApplet.rect(0.0f, -1.0f, this._myWidth, -this._myHeight);
            this._myLabel.draw(pApplet, 2, -this._myHeight);
            if (this.isCollapse) {
                pApplet.fill(this.color.colorActive);
                if (this.isOpen) {
                    pApplet.triangle(this._myWidth - 10, -this._myHeight / 2 - 3, this._myWidth - 4, -this._myHeight / 2 - 3, this._myWidth - 7, -this._myHeight / 2);
                } else {
                    pApplet.triangle(this._myWidth - 10, -this._myHeight / 2, this._myWidth - 4, -this._myHeight / 2, this._myWidth - 7, -this._myHeight / 2 - 3);
                }
            }
        }
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setName("group");
        controlP5XMLElement.setAttribute("width", new Integer(this._myWidth));
        controlP5XMLElement.setAttribute("height", new Integer(this._myHeight));
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (!this.controllers.get(i).isXMLsavable()) continue;
            controlP5XMLElement.addChild(this.controllers.get(i).getAsXML());
        }
    }

    public void addCloseButton() {
        if (this._myCloseButton == null) {
            this._myCloseButton = new Button(this.controlP5, this, this.name() + "close", 1.0f, this._myWidth + 1, -10, 12, 9);
            this._myCloseButton.setLabel("X");
            this._myCloseButton.addListener(this);
        }
    }

    public void removeCloseButton() {
        if (this._myCloseButton == null) {
            this._myCloseButton.remove();
        }
        this._myCloseButton = null;
    }

    public void hideBar() {
        this.isBarVisible = false;
    }

    public void showBar() {
        this.isBarVisible = true;
    }

    public boolean isBarVisible() {
        return this.isBarVisible;
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.controller().name().equals(this.name() + "close")) {
            this.hide();
        }
    }

    public String stringValue() {
        return "" + this._myValue;
    }

    public float value() {
        return this._myValue;
    }

    public float[] arrayValue() {
        return this._myArrayValue;
    }

    public void setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
    }

    public String toString() {
        return super.toString();
    }
}

