/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlCanvas;
import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Slider;
import processing.core.PApplet;

public class ColorPicker
extends ControlGroup {
    protected Slider sliderRed;
    protected Slider sliderGreen;
    protected Slider sliderBlue;
    protected Slider sliderAlpha;
    protected ControlCanvas currentColor;

    protected ColorPicker(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this.isBarVisible = false;
        this.isCollapse = false;
        this._myArrayValue = new float[]{255.0f, 255.0f, 255.0f, 255.0f};
        this.currentColor = this.addCanvas(new ColorField());
        this.sliderRed = this.controlP5.addSlider(string + "-red", 0.0f, 255.0f, 0, 0, n3, 10);
        this.sliderRed.setId(0);
        this.sliderRed.isBroadcast = false;
        this.sliderRed.addListener(this);
        this.sliderRed.setValue(255.0f);
        this.sliderRed.moveTo(this);
        this.sliderRed.setMoveable(false);
        this.sliderRed.setColorBackground(-10092544);
        this.sliderRed.setColorForeground(-5636096);
        this.sliderRed.setColorActive(-65536);
        this.sliderRed.captionLabel().setVisible(false);
        this.sliderRed.setDecimalPrecision(0);
        this.sliderGreen = this.controlP5.addSlider(string + "-green", 0.0f, 255.0f, 0, 11, n3, 10);
        this.sliderGreen.setId(1);
        this.sliderGreen.isBroadcast = false;
        this.sliderGreen.addListener(this);
        this.sliderGreen.setValue(255.0f);
        this.sliderGreen.moveTo(this);
        this.sliderGreen.setMoveable(false);
        this.sliderGreen.setColorBackground(-16751104);
        this.sliderGreen.setColorForeground(-16733696);
        this.sliderGreen.setColorActive(-16711936);
        this.sliderGreen.captionLabel().setVisible(false);
        this.sliderGreen.setDecimalPrecision(0);
        this.sliderBlue = this.controlP5.addSlider(string + "-blue", 0.0f, 255.0f, 0, 22, n3, 10);
        this.sliderBlue.setId(2);
        this.sliderBlue.isBroadcast = false;
        this.sliderBlue.addListener(this);
        this.sliderBlue.setValue(255.0f);
        this.sliderBlue.moveTo(this);
        this.sliderBlue.setMoveable(false);
        this.sliderBlue.setColorBackground(-16777114);
        this.sliderBlue.setColorForeground(-16777046);
        this.sliderBlue.setColorActive(-16776961);
        this.sliderBlue.captionLabel().setVisible(false);
        this.sliderBlue.setDecimalPrecision(0);
        this.sliderAlpha = this.controlP5.addSlider(string + "-alpha", 0.0f, 255.0f, 0, 33, n3, 10);
        this.sliderAlpha.setId(3);
        this.sliderAlpha.isBroadcast = false;
        this.sliderAlpha.addListener(this);
        this.sliderAlpha.setValue(255.0f);
        this.sliderAlpha.moveTo(this);
        this.sliderAlpha.setMoveable(false);
        this.sliderAlpha.setColorBackground(-10066330);
        this.sliderAlpha.setColorForeground(-5592406);
        this.sliderAlpha.setColorActive(-1);
        this.sliderAlpha.captionLabel().setVisible(false);
        this.sliderAlpha.setDecimalPrecision(0);
        this.sliderAlpha.valueLabel().setColor(-16777216);
    }

    public void controlEvent(ControlEvent controlEvent) {
        this._myArrayValue[controlEvent.id()] = controlEvent.value();
    }

    public void setArrayValue(float[] fArray) {
        this.sliderRed.setValue(fArray[0]);
        this.sliderGreen.setValue(fArray[1]);
        this.sliderBlue.setValue(fArray[2]);
        this.sliderAlpha.setValue(fArray[3]);
        this._myArrayValue = fArray;
    }

    public void setColorValue(int n) {
        this.setArrayValue(new float[]{n >> 16 & 0xFF, n >> 8 & 0xFF, n >> 0 & 0xFF, n >> 24 & 0xFF});
    }

    public int getColorValue() {
        int n = -1;
        return n & (int)this._myArrayValue[3] << 24 | (int)this._myArrayValue[0] << 16 | (int)this._myArrayValue[1] << 8 | (int)this._myArrayValue[2] << 0;
    }

    public String toString() {
        return "type:\tColorPicker\n" + super.toString();
    }

    class ColorField
    extends ControlCanvas {
        ColorField() {
        }

        public void draw(PApplet pApplet) {
            pApplet.fill(ColorPicker.this._myArrayValue[0], ColorPicker.this._myArrayValue[1], ColorPicker.this._myArrayValue[2], ColorPicker.this._myArrayValue[3]);
            pApplet.rect(0.0f, 44.0f, ColorPicker.this.getWidth(), 15.0f);
        }
    }
}

