/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import controlP5.Tab;
import processing.core.PApplet;

public class Button
extends Controller {
    protected int cnt;
    protected boolean isPressed;
    protected boolean isOn = false;
    protected static int autoWidth = 70;
    protected static int autoHeight = 20;
    protected int activateBy = 1;
    protected boolean isSwitch = false;

    protected Button(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myValue = f;
    }

    protected Button(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, int n, int n2, int n3, int n4, boolean bl) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myValue = f;
    }

    public Button() {
        super(null, null, null, 0.0f, 0.0f, 1, 1);
    }

    public Button(ControlP5 controlP5, String string) {
        super(controlP5, controlP5.tab("default"), string, 0.0f, 0.0f, 1, 1);
    }

    protected void onEnter() {
        this.isActive = true;
    }

    protected void onLeave() {
        this.isActive = false;
    }

    public void mousePressed() {
        this.isActive = this.getIsInside();
        this.isPressed = true;
        if (this.activateBy == 2) {
            this.activate();
        }
    }

    public void mouseReleased() {
        this.isPressed = false;
        if (this.activateBy == 1) {
            this.activate();
        }
        this.isActive = false;
    }

    public Button activateBy(int n) {
        this.activateBy = n == 2 ? 2 : 1;
        return this;
    }

    protected void activate() {
        if (this.isActive) {
            this.isActive = false;
            if (this.parent() instanceof Tab) {
                this.setIsInside(false);
            }
            this.setValue(this._myValue);
            this.isOn = !this.isOn;
        }
    }

    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public void setValue(float f) {
        this._myValue = f;
        this.broadcast(1);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "button");
    }

    public Button setSwitch(boolean bl) {
        this.isSwitch = bl;
        return this;
    }

    public Button setOn() {
        if (this.isSwitch) {
            this.isOn = false;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public Button setOff() {
        if (this.isSwitch) {
            this.isOn = true;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public boolean booleanValue() {
        return this.isOn;
    }

    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new ButtonDisplay();
                break;
            }
            case 1: {
                this._myDisplay = new ButtonImageDisplay();
                break;
            }
            case 2: {
                this._myDisplay = new ButtonSpriteDisplay();
                break;
            }
        }
    }

    public String toString() {
        return "type:\tButton\n" + super.toString();
    }

    class ButtonImageDisplay
    implements ControllerDisplay {
        ButtonImageDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Button.this.isOn && Button.this.isSwitch) {
                pApplet.image(Button.this.availableImages[3] ? Button.this.images[3] : Button.this.images[0], 0.0f, 0.0f);
                return;
            }
            if (Button.this.getIsInside()) {
                if (Button.this.isPressed) {
                    pApplet.image(Button.this.availableImages[2] ? Button.this.images[2] : Button.this.images[0], 0.0f, 0.0f);
                } else {
                    pApplet.image(Button.this.availableImages[1] ? Button.this.images[1] : Button.this.images[0], 0.0f, 0.0f);
                }
            } else {
                pApplet.image(Button.this.images[0], 0.0f, 0.0f);
            }
        }
    }

    class ButtonDisplay
    implements ControllerDisplay {
        ButtonDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Button.this.isOn && Button.this.isSwitch) {
                pApplet.fill(Button.this.color.colorActive);
            } else if (Button.this.getIsInside()) {
                if (Button.this.isPressed) {
                    pApplet.fill(Button.this.color.colorActive);
                } else {
                    pApplet.fill(Button.this.color.colorForeground);
                }
            } else {
                pApplet.fill(Button.this.color.colorBackground);
            }
            pApplet.rect(0.0f, 0.0f, Button.this.width, Button.this.height);
            if (Button.this.isLabelVisible) {
                Button.this._myCaptionLabel.draw(pApplet, 4, Button.this.height / 2 - 3);
            }
        }
    }

    class ButtonSpriteDisplay
    implements ControllerDisplay {
        ButtonSpriteDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Button.this.isOn && Button.this.isSwitch) {
                Button.this.sprite.setState(2);
            } else if (Button.this.isActive) {
                if (Button.this.isPressed) {
                    Button.this.sprite.setState(2);
                } else {
                    Button.this.sprite.setState(1);
                }
            } else {
                Button.this.sprite.setState(0);
            }
            pApplet.fill(0);
            Button.this.sprite.draw(pApplet);
        }
    }
}

