/*
 * Decompiled with CFR 0.152.
 */
package audio;

public class VolumeAnalyser {
    private long TIME_SPAN = 2000L;
    private int totalVolume = 0;
    private int currentVolume = 0;
    private int lastcurrentVolume = 0;
    private long startSecond = 0L;
    private int averageVolume = 0;
    private int totalPlayedBeats = 0;
    private int currentPlayedBeats = 0;
    private int runTime = 0;
    private boolean firstHit = true;
    private boolean firstCheck = true;
    private boolean ready = false;

    public void beatGotPlayed(int volume) {
        if (this.firstHit) {
            this.firstHit = false;
            this.startSecond = System.currentTimeMillis();
        }
        ++this.totalPlayedBeats;
        ++this.currentPlayedBeats;
        this.totalVolume += volume;
        this.currentVolume += volume;
        this.analyseVolume();
    }

    private void analyseVolume() {
        if (System.currentTimeMillis() - this.startSecond > this.TIME_SPAN) {
            if (this.currentPlayedBeats == 0) {
                this.ready = false;
            }
            ++this.runTime;
            this.analyseTotalVolume();
            this.lastcurrentVolume = this.currentVolume / this.currentPlayedBeats;
            this.currentVolume = 0;
            this.currentPlayedBeats = 0;
            this.startSecond = System.currentTimeMillis();
        }
    }

    private void analyseTotalVolume() {
        if (this.firstCheck) {
            this.firstCheck = false;
        } else {
            this.ready = true;
            this.averageVolume = this.totalVolume / this.totalPlayedBeats;
        }
    }

    public boolean getReadyState() {
        return this.ready;
    }

    public int getaverageVolume() {
        return this.averageVolume;
    }

    public int getcurrentVolume() {
        return this.lastcurrentVolume;
    }
}

