/*
 * Decompiled with CFR 0.152.
 */
package audio;

public class PitchDetection {
    private long TIME_SPAN = 750L;
    private long startingPoint;
    private int pitchCounter = 0;
    private int currentPitch = 0;
    private int lastPitch = 0;
    private boolean firstNote = true;

    public void noteOnEvent(int pitch) {
        if (this.firstNote) {
            this.firstNote = false;
            this.startingPoint = System.currentTimeMillis();
        }
        ++this.pitchCounter;
        this.currentPitch += pitch;
        if (System.currentTimeMillis() - this.startingPoint > this.TIME_SPAN) {
            if (this.pitchCounter > 0) {
                this.lastPitch = this.currentPitch / this.pitchCounter;
            }
            this.currentPitch = 0;
            this.pitchCounter = 0;
            this.startingPoint = System.currentTimeMillis();
        }
    }

    public int getCurrentPitch() {
        return this.lastPitch;
    }
}

