/*
 * Decompiled with CFR 0.152.
 */
package audio;

public class NoteTurningPoints {
    private int BASIC_NOTE = 50;
    private long TIME_SPAN = 750L;
    private int previousNote = 0;
    private boolean direction = true;
    private int lastMainDirection = 0;
    private int mainDirection = 0;
    private int lastAverageTurns = 0;
    private int currentAverageTurns = 0;
    private long startingPoint = System.currentTimeMillis();
    private boolean firstNote = true;

    public void noteOnEvent(int note) {
        if (this.firstNote) {
            this.firstNote = false;
            this.startingPoint = System.currentTimeMillis();
        }
        if (note > this.BASIC_NOTE) {
            if (this.previousNote != 0) {
                if (note > this.previousNote) {
                    if (!this.direction) {
                        ++this.currentAverageTurns;
                    }
                    ++this.mainDirection;
                    this.direction = true;
                }
                if (note < this.previousNote) {
                    if (this.direction) {
                        ++this.currentAverageTurns;
                    }
                    this.direction = false;
                    --this.mainDirection;
                }
            }
            this.previousNote = note;
        }
        if (System.currentTimeMillis() - this.startingPoint > this.TIME_SPAN) {
            this.lastAverageTurns = this.currentAverageTurns;
            this.currentAverageTurns = 0;
            this.lastMainDirection = this.mainDirection;
            this.mainDirection = 0;
            this.startingPoint = System.currentTimeMillis();
        }
    }

    public int getAverageTurns() {
        return this.lastAverageTurns;
    }

    public int getMainDirection() {
        return this.lastMainDirection;
    }
}

