/*
 * Decompiled with CFR 0.152.
 */
package audio;

import java.util.HashMap;

public class NoteDurations {
    private HashMap<Integer, Long> playedNotes = new HashMap();
    private boolean firstNote = true;
    private long currentLength = 0L;
    private long startingPoint;
    private long countedNotes = 0L;
    private long oldCurrentLength = 0L;
    private long TIME_SPAN = 1500L;

    public void noteOnEvent(int note, int velocity) {
        if (this.firstNote) {
            this.firstNote = false;
            this.startingPoint = System.currentTimeMillis();
        }
        long localTime = System.currentTimeMillis();
        if (!this.playedNotes.containsKey(note)) {
            this.playedNotes.put(note, localTime);
        }
        ++this.countedNotes;
    }

    public void noteOffEvent(int note) {
        if (this.playedNotes.containsKey(note)) {
            long length = System.currentTimeMillis() - this.playedNotes.get(note);
            this.currentLength += length;
            this.playedNotes.remove(note);
        }
        if (System.currentTimeMillis() - this.startingPoint > this.TIME_SPAN) {
            this.startingPoint = System.currentTimeMillis();
            if (this.countedNotes > 0L) {
                this.oldCurrentLength = this.currentLength / this.countedNotes;
            }
            this.currentLength = 0L;
            this.countedNotes = 0L;
        }
    }

    public float getCurrentAvgLength() {
        return this.oldCurrentLength;
    }
}

