/*
 * Decompiled with CFR 0.152.
 */
package audio;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class NoteDetection {
    private long TIME_SPAN_FOR_OVERALL_KEY = 3000L;
    private long TIME_SPAN_FOR_TRIADS = 300L;
    private int[] clearArray = new int[0];
    private String[] notes = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "Bb", "B"};
    private long startingPoint_for_Overall_Key;
    private HashMap<Integer, Integer> playedNotes = new HashMap();
    private int[] totalTriads = new int[0];
    private HashMap<String, Integer> playedTriads = new HashMap();
    private long startingPoint_for_Triads;
    private int[] timeTriads = new int[0];
    private String currentTune;
    private String[] readyTunes = new String[0];
    private boolean ready = false;
    private boolean firstNote = true;

    public NoteDetection() {
        this.startingPoint_for_Triads = System.currentTimeMillis();
    }

    public void analyseNotes(int notePlayed) {
        if (this.firstNote) {
            this.firstNote = false;
            this.startingPoint_for_Overall_Key = System.currentTimeMillis();
            this.startingPoint_for_Triads = System.currentTimeMillis();
        }
        int note = notePlayed % 12;
        this.checkForTune(note);
        this.TriadDetection(note);
    }

    private void TriadDetection(int note) {
        boolean triadnoteExistsAlready = false;
        int i = 0;
        while (i < this.totalTriads.length) {
            if (note == this.totalTriads[i]) {
                triadnoteExistsAlready = true;
                break;
            }
            ++i;
        }
        if (!triadnoteExistsAlready) {
            this.totalTriads = this.reSizeArray(this.totalTriads, note);
            if (this.totalTriads.length == 3) {
                this.checkForTriad(this.totalTriads);
                this.totalTriads = this.clearArray;
            }
        }
        if (System.currentTimeMillis() - this.startingPoint_for_Triads > this.TIME_SPAN_FOR_TRIADS) {
            if (this.timeTriads.length == 3) {
                this.checkForTriad(this.timeTriads);
            }
            this.startingPoint_for_Triads = System.currentTimeMillis();
            this.timeTriads = this.clearArray;
        }
        boolean timeTriadNoteExists = false;
        int i2 = 0;
        while (i2 < this.timeTriads.length) {
            if (note == this.timeTriads[i2]) {
                timeTriadNoteExists = true;
                break;
            }
            ++i2;
        }
        if (!timeTriadNoteExists) {
            this.timeTriads = this.reSizeArray(this.timeTriads, note);
        }
    }

    private void checkForTune(int note) {
        if (this.playedNotes.containsKey(note)) {
            int newValue = this.playedNotes.get(note) + 1;
            this.playedNotes.put(note, newValue);
        } else {
            this.playedNotes.put(note, 1);
        }
        TreeMap<Integer, Integer> sortedNotes = new TreeMap<Integer, Integer>(new ValueComparer<Integer, Integer>(this.playedNotes));
        sortedNotes.putAll(this.playedNotes);
        int dur_tune = 4;
        int[] playedNotesCheck = new int[]{};
        int x = 0;
        Iterator iter = sortedNotes.keySet().iterator();
        while (iter.hasNext()) {
            if (x >= 7) break;
            playedNotesCheck = this.reSizeArray(playedNotesCheck, (Integer)iter.next());
            ++x;
        }
        Arrays.sort(playedNotesCheck);
        if (System.currentTimeMillis() - this.startingPoint_for_Overall_Key > this.TIME_SPAN_FOR_OVERALL_KEY) {
            this.playedNotes = new HashMap();
            this.startingPoint_for_Overall_Key = System.currentTimeMillis();
            TreeMap<String, Integer> sortedTriads = new TreeMap<String, Integer>(new ValueComparer<String, Integer>(this.playedTriads));
            sortedTriads.putAll(this.playedTriads);
            this.prepareTunesForExport(sortedTriads);
        }
        if (playedNotesCheck.length == 7) {
            int distance = 0;
            boolean distanceCount = false;
            int i = 0;
            while (true) {
                if (i == 5) {
                    if (playedNotesCheck[6] - playedNotesCheck[0] == 11 && distanceCount) break;
                    if (playedNotesCheck[6] - playedNotesCheck[0] == 11 && !distanceCount) {
                        distanceCount = true;
                        dur_tune = playedNotesCheck[i];
                    }
                    if (playedNotesCheck[6] - playedNotesCheck[0] == 10 && distanceCount) {
                        ++distance;
                    }
                    i = 0;
                } else {
                    ++i;
                }
                if (playedNotesCheck[i + 1] - playedNotesCheck[i] == 1 && distanceCount) break;
                if (playedNotesCheck[i + 1] - playedNotesCheck[i] == 1 && !distanceCount) {
                    distanceCount = true;
                    dur_tune = playedNotesCheck[i + 1];
                }
                if (playedNotesCheck[i + 1] - playedNotesCheck[i] != 2 || !distanceCount) continue;
                ++distance;
            }
            if (distance == 3) {
                dur_tune -= 5;
            }
            int moll_tune = dur_tune - 3;
            int moll_tune_count = 0;
            if (this.playedNotes.containsKey(moll_tune)) {
                moll_tune_count = this.playedNotes.get(moll_tune);
            }
            int dur_tune_count = 0;
            if (this.playedNotes.containsKey(dur_tune)) {
                dur_tune_count = this.playedNotes.get(dur_tune);
            }
            if (dur_tune_count > moll_tune_count) {
                this.currentTune = String.valueOf(this.detectNote(dur_tune)) + "-Dur";
                if (!this.playedTriads.containsKey(String.valueOf(this.detectNote(dur_tune)) + "-Dur")) {
                    this.playedTriads.put(String.valueOf(this.detectNote(dur_tune)) + "-Dur", 1);
                } else {
                    int newValue = this.playedTriads.get(String.valueOf(this.detectNote(dur_tune)) + "-Dur") + 1;
                    this.playedTriads.put(String.valueOf(this.detectNote(dur_tune)) + "-Dur", newValue);
                }
            } else if (moll_tune_count > dur_tune_count) {
                this.currentTune = String.valueOf(this.detectNote(moll_tune)) + "-moll";
                if (!this.playedTriads.containsKey(String.valueOf(this.detectNote(moll_tune)) + "-moll")) {
                    this.playedTriads.put(String.valueOf(this.detectNote(moll_tune)) + "-moll", 1);
                } else {
                    int newValue = this.playedTriads.get(String.valueOf(this.detectNote(moll_tune)) + "-moll") + 1;
                    this.playedTriads.put(String.valueOf(this.detectNote(moll_tune)) + "-moll", newValue);
                }
            }
        }
    }

    private boolean checkForTriad(int[] triadNotes) {
        int a = triadNotes[1] - triadNotes[0];
        int b = triadNotes[2] - triadNotes[1];
        if (triadNotes[0] == triadNotes[1] || triadNotes[1] == triadNotes[2] || triadNotes[0] == triadNotes[2]) {
            return false;
        }
        Arrays.sort(triadNotes);
        boolean ret = false;
        if (triadNotes.length == 3) {
            String triad = "no Triad found";
            if (a == 5 || b == 5) {
                if (a == 5) {
                    triad = b == 4 ? String.valueOf(this.detectNote(triadNotes[1])) + "-Dur" : String.valueOf(this.detectNote(triadNotes[1])) + "-moll";
                }
                if (b == 5) {
                    triad = a == 3 ? String.valueOf(this.detectNote(triadNotes[2])) + "-Dur" : String.valueOf(this.detectNote(triadNotes[2])) + "-moll";
                }
            }
            if (a == 3 && b == 4 || a == 4 && b == 3) {
                triad = a == 4 ? String.valueOf(this.detectNote(triadNotes[0])) + "-Dur" : String.valueOf(this.detectNote(triadNotes[0])) + "-moll";
            }
            if (triad != "no Triad found") {
                ret = true;
                this.currentTune = triad;
                if (!this.playedTriads.containsKey(triad)) {
                    this.playedTriads.put(triad, 1);
                } else {
                    int newValue = this.playedTriads.get(triad) + 1;
                    this.playedTriads.put(triad, newValue);
                }
            }
        }
        return ret;
    }

    private String detectNote(int notePlayed) {
        int note = notePlayed % 12;
        return this.notes[note];
    }

    private int[] reSizeArray(int[] oldArray, int note) {
        int[] copy = new int[oldArray.length + 1];
        int i = 0;
        while (i < oldArray.length) {
            copy[i] = oldArray[i];
            ++i;
        }
        copy[oldArray.length] = note;
        return copy;
    }

    private String[] reSizeArray(String[] oldArray, String newString) {
        String[] copy = new String[oldArray.length + 1];
        int i = 0;
        while (i < oldArray.length) {
            copy[i] = oldArray[i];
            ++i;
        }
        copy[oldArray.length] = newString;
        return copy;
    }

    private void prepareTunesForExport(SortedMap<String, Integer> tunesForExport) {
        this.readyTunes = new String[0];
        Iterator<String> iter = tunesForExport.keySet().iterator();
        while (iter.hasNext()) {
            this.readyTunes = this.reSizeArray(this.readyTunes, iter.next());
        }
        this.ready = true;
    }

    public void reset() {
    }

    public void resetAll() {
        this.playedTriads = new HashMap();
    }

    public boolean getReadyState() {
        return this.ready;
    }

    public String getOverallTune() {
        String ret = "";
        if (this.readyTunes.length > 0) {
            ret = this.readyTunes[0];
        }
        return ret;
    }

    public String getCurrentTune() {
        return this.currentTune;
    }

    public static class ValueComparer<K, V extends Comparable<V>>
    implements Comparator<K> {
        private Map<K, V> data = null;

        public ValueComparer(Map<K, V> data) {
            this.data = data;
        }

        @Override
        public int compare(K key1, K key2) {
            Comparable value1 = (Comparable)this.data.get(key1);
            Comparable value2 = (Comparable)this.data.get(key2);
            int c = value2.compareTo(value1);
            if (c != 0) {
                return c;
            }
            Integer h1 = key1.hashCode();
            Integer h2 = key2.hashCode();
            return h1.compareTo(h2);
        }
    }
}

