/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.HpS_Counter;
import audio.NoteDetection;
import audio.NoteDurations;
import audio.NoteTurningPoints;
import audio.PitchDetection;
import audio.VolumeAnalyser;
import processing.core.PApplet;
import promidi.MidiIO;
import promidi.Note;

public class MIDI_Input {
    private PApplet parent;
    private MidiIO midiIO;
    private NoteDetection noteDetection;
    private VolumeAnalyser volumeAnalyser;
    private HpS_Counter hpsCounter;
    private NoteDurations noteDurations;
    private NoteTurningPoints noteTurningPoints;
    private PitchDetection pitchDetection;

    public MIDI_Input(PApplet p) {
        this.parent = p;
        this.midiIO = MidiIO.getInstance(this.parent);
        this.midiIO.printDevices();
    }

    public void initialize() {
        this.noteDetection = new NoteDetection();
        this.volumeAnalyser = new VolumeAnalyser();
        this.hpsCounter = new HpS_Counter();
        this.noteDurations = new NoteDurations();
        this.noteTurningPoints = new NoteTurningPoints();
        this.pitchDetection = new PitchDetection();
    }

    public void openMidiInput(int device) {
        this.midiIO.openInput(device, 0);
    }

    public void noteOn(Note note, int device, int channel) {
        int vol = note.getVelocity();
        if (vol != 0) {
            this.noteDetection.analyseNotes(note.getPitch());
            this.volumeAnalyser.beatGotPlayed(vol);
            this.hpsCounter.beatGotPlayed();
            this.noteDurations.noteOnEvent(note.getPitch(), note.getVelocity());
            this.noteTurningPoints.noteOnEvent(note.getPitch());
            this.pitchDetection.noteOnEvent(note.getPitch());
        }
    }

    public void noteOff(Note note) {
        this.noteDurations.noteOffEvent(note.getPitch());
    }

    public void reset() {
        this.noteDetection.resetAll();
    }

    public String getNoteDetectionData() {
        return this.noteDetection.getCurrentTune();
    }

    public String getOverallTune() {
        return this.noteDetection.getOverallTune();
    }

    public int getVolumeAnalyserData() {
        return this.volumeAnalyser.getcurrentVolume();
    }

    public int getHpsCounterData() {
        return this.hpsCounter.getCurrentHPS();
    }

    public float getNoteDurationsData() {
        return this.noteDurations.getCurrentAvgLength();
    }

    public int getNoteTurningPointsTurns() {
        return this.noteTurningPoints.getAverageTurns();
    }

    public int getNoteTurningPointsMainDirection() {
        return this.noteTurningPoints.getMainDirection();
    }

    public int getPitch() {
        return this.pitchDetection.getCurrentPitch();
    }

    public int getNumberOfInputs() {
        return this.midiIO.numberOfInputDevices();
    }

    public String[] getDeviceNames() {
        String[] devices = new String[this.midiIO.numberOfInputDevices()];
        int x = 0;
        while (x < this.midiIO.numberOfInputDevices()) {
            devices[x] = this.midiIO.getInputDeviceName(x);
            ++x;
        }
        return devices;
    }

    public int getReadyState() {
        int ret = 0;
        if (this.noteDetection.getReadyState()) {
            ++ret;
        }
        if (this.volumeAnalyser.getReadyState()) {
            ++ret;
        }
        if (this.hpsCounter.getReadyState()) {
            ++ret;
        }
        return ret;
    }
}

